/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.wsdlanalyzer.matcher;

import de.dfki.wsdlanalyzer.mapping.Mapping;
import de.dfki.wsdlanalyzer.mapping.MappingPartList;
import de.dfki.wsdlanalyzer.matrix.ScoreMap;
import de.dfki.wsdlanalyzer.parser.SimpleTypeLookupTable;
import de.dfki.wsdlanalyzer.types.BindingList;
import de.dfki.wsdlanalyzer.types.ComplexType;
import de.dfki.wsdlanalyzer.types.Element;
import de.dfki.wsdlanalyzer.types.ElementList;
import de.dfki.wsdlanalyzer.types.Message;
import de.dfki.wsdlanalyzer.types.MessageList;
import de.dfki.wsdlanalyzer.types.MessageParameter;
import de.dfki.wsdlanalyzer.types.Operation;
import de.dfki.wsdlanalyzer.types.OperationList;
import de.dfki.wsdlanalyzer.types.PortType;
import de.dfki.wsdlanalyzer.types.PortTypeList;
import de.dfki.wsdlanalyzer.types.Sequence;
import de.dfki.wsdlanalyzer.types.Service;
import de.dfki.wsdlanalyzer.types.TypeList;
import de.dfki.wsdlanalyzer.types.WsdlFile;
import java.util.ArrayList;
import java.util.ListIterator;

public class TreeEditMatcher {
    private String sourceFileName;
    private String targetFileName;
    private Service sourceService;
    private Service targetService;
    private BindingList sourceBindings;
    private BindingList targetBindings;
    private PortTypeList sourcePortTypes;
    private PortTypeList targetPortTypes;
    private MessageList sourceMessages;
    private MessageList targetMessages;
    private TypeList sourceTypes;
    private TypeList targetTypes;
    private ElementList sourceElements;
    private ElementList targetElements;
    private SimpleTypeLookupTable lookupTable;
    private ScoreMap scoreMatrix;
    private int minScore = 0;
    private int maxScore = 10;
    private int groupingBonus = 10;
    private int arrayBonus = 2;
    private int sequenceBonus = 5;
    private boolean edit = true;
    private Mapping serviceMapping;

    public TreeEditMatcher(Service source, WsdlFile sourcefile, Service target, WsdlFile targetfile, SimpleTypeLookupTable l) {
        this.sourceFileName = sourcefile.getWsdlFileName();
        this.sourceService = source;
        this.sourceBindings = sourcefile.getBindings();
        this.sourcePortTypes = sourcefile.getPorttypelist();
        this.sourceMessages = sourcefile.getMessageList();
        this.sourceTypes = sourcefile.getTypeList();
        this.sourceElements = sourcefile.getElementlist();
        this.targetFileName = targetfile.getWsdlFileName();
        this.targetService = target;
        this.targetBindings = targetfile.getBindings();
        this.targetPortTypes = targetfile.getPorttypelist();
        this.targetMessages = targetfile.getMessageList();
        this.targetTypes = targetfile.getTypeList();
        this.targetElements = targetfile.getElementlist();
        this.lookupTable = l;
        this.serviceMapping = new Mapping(this.sourceService.getName(), this.targetService.getName(), this.sourceService.getNodeIdentifier(), this.targetService.getNodeIdentifier());
    }

    public int matchServices() {
        for (String sourcePortName : this.sourceService.keySet()) {
            String sourceBinding = this.sourceService.get(sourcePortName).getBinding();
            String sourceName = this.sourceBindings.get(sourceBinding).getPortType();
            PortType sourcePortType = this.sourcePortTypes.get(sourceName);
            for (String targetPortName : this.targetService.keySet()) {
                Mapping portMapping = new Mapping(sourcePortName, targetPortName, this.sourceService.get(sourcePortName).getNodeIdentifier(), this.targetService.get(targetPortName).getNodeIdentifier());
                String targetBinding = this.targetService.get(targetPortName).getBinding();
                Mapping bindingMapping = new Mapping(sourceBinding, targetBinding, this.sourceBindings.get(sourceBinding).getNodeIdentifier(), this.targetBindings.get(targetBinding).getNodeIdentifier());
                String targetName = this.targetBindings.get(targetBinding).getPortType();
                PortType targetPortType = this.targetPortTypes.get(targetName);
                Mapping portTypeMapping = this.matchPortTypes(sourcePortType, targetPortType);
                if (portTypeMapping == null) continue;
                MappingPartList portTypePartList = new MappingPartList();
                portTypePartList.addMapping(portTypeMapping);
                bindingMapping.addMappingPartList(portTypePartList);
                MappingPartList bindingPartList = new MappingPartList();
                bindingPartList.addMapping(bindingMapping);
                portMapping.addMappingPartList(bindingPartList);
                MappingPartList portPartList = new MappingPartList();
                portPartList.addMapping(portMapping);
                this.serviceMapping.addMappingPartList(portPartList);
            }
        }
        return this.serviceMapping.getScore();
    }

    public Mapping matchPortTypes(PortType sourceporttype, PortType targetporttype) {
        OperationList sourceOperations = sourceporttype.getOperationlist();
        OperationList targetOperations = targetporttype.getOperationlist();
        if (!sourceOperations.isEmpty() && !targetOperations.isEmpty()) {
            ScoreMap operationMatrix = new ScoreMap(sourceOperations.length(), targetOperations.length(), sourceporttype.getName(), targetporttype.getName(), this.edit);
            int porttypescore = -1;
            for (String sourceName : sourceOperations.keySet()) {
                Operation sourceOperation = sourceOperations.getOperation(sourceName);
                for (String targetName : targetOperations.keySet()) {
                    Operation targetOperation = targetOperations.getOperation(targetName);
                    Mapping operationMapping = this.matchOperations(sourceOperation, targetOperation);
                    operationMatrix.setValue(operationMapping);
                }
            }
            operationMatrix.computeMatches();
            Mapping portTypeMapping = operationMatrix.getMapping();
            return portTypeMapping;
        }
        Mapping nullMapping = new Mapping(sourceporttype.getName(), targetporttype.getName(), sourceporttype.getNodeIdentifier(), targetporttype.getNodeIdentifier());
        nullMapping.setScore(0);
        return nullMapping;
    }

    private Mapping matchOperations(Operation sourceop, Operation targetop) {
        Mapping operationMapping = new Mapping(sourceop.getName(), targetop.getName(), sourceop.getNodeIdentifier(), targetop.getNodeIdentifier());
        MappingPartList messagePartList = new MappingPartList();
        Message sourceInputMessage = this.sourceMessages.getMessage(sourceop.getInput());
        Message targetInputMessage = this.targetMessages.getMessage(targetop.getInput());
        Mapping inputMapping = this.matchMessages(sourceInputMessage, targetInputMessage);
        messagePartList.addMapping(inputMapping);
        Message sourceOutputMessage = this.sourceMessages.getMessage(sourceop.getOutput());
        Message targetOutputMessage = this.targetMessages.getMessage(targetop.getOutput());
        Mapping outputMapping = this.matchMessages(sourceOutputMessage, targetOutputMessage);
        messagePartList.addMapping(outputMapping);
        if (sourceop.getFault() != null && targetop.getFault() != null) {
            Message sourceFaultMessage = this.sourceMessages.getMessage(sourceop.getFault());
            Message targetFaultMessage = this.targetMessages.getMessage(targetop.getFault());
            Mapping faultMapping = this.matchMessages(sourceFaultMessage, targetFaultMessage);
            messagePartList.addMapping(faultMapping);
        }
        operationMapping.addMappingPartList(messagePartList);
        return operationMapping;
    }

    private Mapping matchMessages(Message sourcemessage, Message targetmessage) {
        ScoreMap parameterMatrix = new ScoreMap(sourcemessage.getParameterList().size(), targetmessage.getParameterList().size(), sourcemessage.getName(), targetmessage.getName(), this.edit);
        if (!sourcemessage.isEmpty() && !targetmessage.isEmpty()) {
            ListIterator<MessageParameter> sourceList = sourcemessage.getParameterList().listIterator();
            while (sourceList.hasNext()) {
                MessageParameter sourceParameter = sourceList.next();
                ListIterator<MessageParameter> targetList = targetmessage.getParameterList().listIterator();
                while (targetList.hasNext()) {
                    MessageParameter targetParameter = targetList.next();
                    Mapping parameterMapping = this.matchParameter(sourceParameter, targetParameter);
                    parameterMatrix.setValue(parameterMapping);
                }
            }
            parameterMatrix.computeMatches();
            Mapping messageMapping = parameterMatrix.getMapping();
            return messageMapping;
        }
        Mapping nullMapping = new Mapping(sourcemessage.getName(), targetmessage.getName(), sourcemessage.getNodeIdentifier(), targetmessage.getNodeIdentifier());
        nullMapping.setScore(0);
        return nullMapping;
    }

    private Mapping matchParameter(MessageParameter sourceparameter, MessageParameter targetparameter) {
        Mapping parameterMapping = new Mapping(sourceparameter.getName(), targetparameter.getName());
        if (this.lookupTable.lookupSimpleType(sourceparameter.getType())) {
            if (this.lookupTable.lookupSimpleType(targetparameter.getType())) {
                parameterMapping.setScore(this.lookupTable.getMatchingScore(sourceparameter.getType(), targetparameter.getType()));
            } else {
                ComplexType complextype = this.targetTypes.getType(targetparameter.getType());
                Mapping typeMapping = this.matchMixedTypes(sourceparameter.getName(), sourceparameter.getType(), targetparameter.getName(), complextype);
                MappingPartList typePartList = new MappingPartList();
                typePartList.addMapping(typeMapping);
                parameterMapping.addMappingPartList(typePartList);
            }
        } else if (this.lookupTable.lookupSimpleType(targetparameter.getType())) {
            ComplexType complextype = this.sourceTypes.getType(sourceparameter.getType());
            Mapping typeMapping = this.matchMixedTypes(sourceparameter.getName(), complextype, targetparameter.getName(), targetparameter.getType());
            MappingPartList typePartList = new MappingPartList();
            typePartList.addMapping(typeMapping);
            parameterMapping.addMappingPartList(typePartList);
        } else {
            ComplexType sourcetype = this.sourceTypes.getType(sourceparameter.getType());
            ComplexType targettype = this.targetTypes.getType(targetparameter.getType());
            Mapping typeMapping = this.matchComplexTypes(sourceparameter.getName(), sourcetype, targetparameter.getName(), targettype);
            MappingPartList typePartList = new MappingPartList();
            typePartList.addMapping(typeMapping);
            parameterMapping.addMappingPartList(typePartList);
        }
        return parameterMapping;
    }

    private int matchIdenticalTypes(ComplexType type) {
        int elementcount = type.getElementList().size();
        int groupingcount = 1;
        for (Element element : type.getElementList()) {
            if (this.lookupTable.lookupSimpleType(element.getType())) continue;
            System.out.println("element: " + element.getType());
            ComplexType complextype = this.sourceTypes.getType(element.getType());
            elementcount += this.matchIdenticalTypes(complextype);
            ++groupingcount;
        }
        return (elementcount + groupingcount) * this.maxScore * 2;
    }

    private Mapping matchMixedTypes(String sourcename, ComplexType sourcetype, String targetname, String targettype) {
        ScoreMap typeMatrix = new ScoreMap(sourcetype.getElementList().size(), 1, sourcename, targetname, this.edit);
        int typeScore = -1;
        if (!sourcetype.isArray()) {
            if (!sourcetype.getElementList().isEmpty()) {
                ListIterator<Element> elements = sourcetype.getElementList().listIterator();
                while (elements.hasNext()) {
                    Element sourceelement = elements.next();
                    if (this.lookupTable.lookupSimpleType(sourceelement.getType())) {
                        Mapping elementMapping = new Mapping(sourceelement.getName(), targetname);
                        elementMapping.setRequirementsIdentifier(sourceelement.getNodeIdentifier());
                        int matchScore = this.lookupTable.getMatchingScore(sourceelement.getType(), targettype);
                        elementMapping.setScore(matchScore);
                        typeMatrix.setValue(elementMapping);
                        continue;
                    }
                    ComplexType complextypeelement = this.sourceTypes.getType(sourceelement.getType());
                    Mapping elementMapping = this.matchMixedTypes(sourceelement.getName(), complextypeelement, targetname, targettype);
                    typeMatrix.setValue(elementMapping);
                }
                typeMatrix.computeMatches();
                Mapping typeMapping = typeMatrix.getMapping();
                return typeMapping;
            }
            Mapping nullMapping = new Mapping(sourcename, targetname);
            nullMapping.setScore(0);
            return nullMapping;
        }
        Mapping nullMapping = new Mapping(sourcename, targetname);
        nullMapping.setScore(0);
        return nullMapping;
    }

    private Mapping matchMixedTypes(String sourcename, String sourcetype, String targetname, ComplexType targettype) {
        ScoreMap typeMatrix = new ScoreMap(1, targettype.getElementList().size(), sourcename, targetname, this.edit);
        int typeScore = -1;
        if (!targettype.isArray()) {
            if (!targettype.getElementList().isEmpty()) {
                ListIterator<Element> elements = targettype.getElementList().listIterator();
                while (elements.hasNext()) {
                    Element targetelement = elements.next();
                    if (this.lookupTable.lookupSimpleType(targetelement.getType())) {
                        Mapping elementMapping = new Mapping(sourcename, targetelement.getName());
                        elementMapping.setCandidateIdentifier(targetelement.getNodeIdentifier());
                        int matchScore = this.lookupTable.getMatchingScore(sourcetype, targetelement.getType());
                        elementMapping.setScore(matchScore);
                        typeMatrix.setValue(elementMapping);
                        continue;
                    }
                    ComplexType complextypeelement = this.targetTypes.getType(targetelement.getType());
                    Mapping elementMapping = this.matchMixedTypes(sourcename, sourcetype, targetelement.getName(), complextypeelement);
                    typeMatrix.setValue(elementMapping);
                }
                typeMatrix.computeMatches();
                Mapping typeMapping = typeMatrix.getMapping();
                return typeMapping;
            }
            Mapping nullMapping = new Mapping(sourcename, targetname);
            nullMapping.setScore(0);
            return nullMapping;
        }
        Mapping nullMapping = new Mapping(sourcename, targetname);
        nullMapping.setScore(0);
        return nullMapping;
    }

    private Mapping matchComplexTypes(String sourcename, ComplexType sourcetype, String targetname, ComplexType targettype) {
        int typeScore = 0;
        if (sourcetype.isArray()) {
            if (targettype.isArray()) {
                return this.matchArrayTypes(sourcetype, targettype);
            }
            Mapping nullMapping = new Mapping(sourcename, targetname);
            nullMapping.setScore(0);
            return nullMapping;
        }
        if (targettype.isArray()) {
            Mapping nullMapping = new Mapping(sourcename, targetname);
            nullMapping.setScore(0);
            return nullMapping;
        }
        boolean Score = false;
        if (sourcetype.getTotalLeaves() == targettype.getTotalLeaves() && sourcetype.getNumberOfLeafElements() != targettype.getNumberOfLeafElements() && sourcetype.getNumberOfNonLeafElements() != targettype.getNumberOfNonLeafElements()) {
            System.out.println(String.valueOf(sourcename) + " = " + targetname + " : " + sourcetype.getTotalLeaves());
            System.out.println("\n types with different leaves: " + (sourcetype.getNumberOfLeafElements() - targettype.getNumberOfLeafElements()) + ", " + (sourcetype.getNumberOfNonLeafElements() - targettype.getNumberOfNonLeafElements()));
        }
        if (sourcetype.getGrouping() == targettype.getGrouping()) {
            typeScore += this.groupingBonus;
        }
        if (sourcetype.getGrouping() == 1 && targettype.getGrouping() == 1) {
            Sequence sourcesequence = this.generateSequence(sourcetype);
            Sequence targetsequence = this.generateSequence(targettype);
            Mapping typeMapping = this.matchSequences(sourcetype, sourcesequence, targettype, targetsequence);
            typeMapping.addScoreBonus(typeScore);
            return typeMapping;
        }
        if (!sourcetype.isEmpty() && !targettype.isEmpty()) {
            ScoreMap typeMatrix = new ScoreMap(sourcetype.getElementList().size(), targettype.getElementList().size(), sourcename, targetname, this.edit);
            ListIterator<Element> sourceelements = sourcetype.getElementList().listIterator();
            while (sourceelements.hasNext()) {
                Element sourceelement = sourceelements.next();
                ListIterator<Element> targetelements = targettype.getElementList().listIterator();
                while (targetelements.hasNext()) {
                    Element targetelement = targetelements.next();
                    Mapping elementMapping = this.matchElements(sourceelement, targetelement);
                    typeMatrix.setValue(elementMapping);
                }
            }
            typeMatrix.computeMatches();
            Mapping typeMapping = typeMatrix.getMapping();
            return typeMapping;
        }
        Mapping nullMapping = new Mapping(sourcename, targetname);
        nullMapping.setScore(0);
        return nullMapping;
    }

    private Mapping matchArrayTypes(ComplexType sourcetype, ComplexType targettype) {
        Mapping arrayMapping = new Mapping(sourcetype.getName(), targettype.getName(), sourcetype.getNodeIdentifier(), targettype.getNodeIdentifier());
        int arrayscore = -1;
        String sourcearraytype = sourcetype.getArrayType();
        String targetarraytype = targettype.getArrayType();
        if (this.lookupTable.lookupSimpleType(sourcearraytype)) {
            if (this.lookupTable.lookupSimpleType(targetarraytype)) {
                arrayscore = this.lookupTable.getMatchingScore(sourcearraytype, targetarraytype) * this.arrayBonus;
                arrayMapping.setScore(arrayscore);
            } else {
                ComplexType complextype = this.targetTypes.getType(targetarraytype);
                Mapping typeMapping = this.matchMixedTypes(sourcetype.getName(), sourcearraytype, targettype.getName(), complextype);
                MappingPartList typePartList = new MappingPartList();
                typePartList.addMapping(typeMapping);
                arrayMapping.addMappingPartList(typePartList);
            }
        } else if (this.lookupTable.lookupSimpleType(targetarraytype)) {
            ComplexType complextype = this.sourceTypes.getType(sourcearraytype);
            Mapping typeMapping = this.matchMixedTypes(sourcetype.getName(), complextype, targettype.getName(), targetarraytype);
            MappingPartList typePartList = new MappingPartList();
            typePartList.addMapping(typeMapping);
            arrayMapping.addMappingPartList(typePartList);
        } else {
            ComplexType complexsourcetype = this.sourceTypes.getType(sourcearraytype);
            ComplexType complextargettype = this.targetTypes.getType(targetarraytype);
            Mapping typeMapping = this.matchComplexTypes(sourcetype.getName(), complexsourcetype, targettype.getName(), complextargettype);
            MappingPartList typePartList = new MappingPartList();
            typePartList.addMapping(typeMapping);
            arrayMapping.addMappingPartList(typePartList);
        }
        arrayMapping.setScore(arrayMapping.getScore() * this.arrayBonus);
        return arrayMapping;
    }

    private Mapping matchElements(Element sourceelement, Element targetelement) {
        Mapping elementMapping = new Mapping(sourceelement.getName(), targetelement.getName(), sourceelement.getNodeIdentifier(), targetelement.getNodeIdentifier());
        int elementScore = 0;
        if (sourceelement.getMinOccur() >= 0 && targetelement.getMinOccur() >= 0 && sourceelement.getMinOccur() == targetelement.getMinOccur()) {
            ++elementScore;
        }
        if (sourceelement.getMaxOccur() >= 0 && targetelement.getMaxOccur() >= 0 && sourceelement.getMaxOccur() == targetelement.getMaxOccur()) {
            ++elementScore;
        }
        if (!this.lookupTable.lookupSimpleType(sourceelement.getType())) {
            if (this.lookupTable.lookupSimpleType(targetelement.getType())) {
                ComplexType complextype = this.sourceTypes.getType(sourceelement.getType());
                String simpletype = targetelement.getType();
                Mapping typeMapping = this.matchMixedTypes(sourceelement.getName(), complextype, targetelement.getName(), targetelement.getType());
                MappingPartList typePartList = new MappingPartList();
                typePartList.addMapping(typeMapping);
                elementMapping.addMappingPartList(typePartList);
            } else {
                ComplexType complexsourcetype = this.sourceTypes.getType(sourceelement.getType());
                ComplexType complextargettype = this.targetTypes.getType(targetelement.getType());
                Mapping typeMapping = this.matchComplexTypes(sourceelement.getName(), complexsourcetype, targetelement.getName(), complextargettype);
                MappingPartList typePartList = new MappingPartList();
                typePartList.addMapping(typeMapping);
                elementMapping.addMappingPartList(typePartList);
            }
        } else if (this.lookupTable.lookupSimpleType(targetelement.getType())) {
            elementMapping.setScore(this.lookupTable.getMatchingScore(sourceelement.getType(), targetelement.getType()));
        } else {
            ComplexType complextype = this.targetTypes.getType(targetelement.getType());
            Mapping typeMapping = this.matchMixedTypes(sourceelement.getName(), sourceelement.getType(), targetelement.getName(), complextype);
            MappingPartList typePartList = new MappingPartList();
            typePartList.addMapping(typeMapping);
            elementMapping.addMappingPartList(typePartList);
        }
        elementMapping.addScoreBonus(elementScore);
        return elementMapping;
    }

    private Mapping matchSequences(ComplexType sourcetype, Sequence source, ComplexType targettype, Sequence target) {
        Mapping sequenceMapping = new Mapping(sourcetype.getName(), targettype.getName(), sourcetype.getNodeIdentifier(), targettype.getNodeIdentifier());
        int sequenceScore = 0;
        int elementScore = 0;
        ArrayList<Integer> index = new ArrayList<Integer>();
        if (source.getLength() == target.getLength()) {
            MappingPartList mappingPartList = new MappingPartList();
            int i = 0;
            while (i < source.getLength()) {
                Element sourceelement = source.getElement(i);
                Element targetelement = target.getElement(i);
                Mapping elementMapping = this.matchElements(sourceelement, targetelement);
                mappingPartList.addMapping(elementMapping);
                ++i;
            }
            sequenceMapping.addMappingPartList(mappingPartList);
            sequenceMapping.addScoreBonus(this.sequenceBonus);
            return sequenceMapping;
        }
        if (source.getLength() < target.getLength()) {
            ArrayList<MappingPartList> tmplist = new ArrayList<MappingPartList>();
            int j = 0;
            while (j <= target.getLength() - source.getLength()) {
                int tmpScore = 0;
                MappingPartList mappingPartList = new MappingPartList();
                int i = 0;
                while (i < source.getLength()) {
                    Element sourceelement = source.getElement(i);
                    Element targetelement = target.getElement(i + j);
                    Mapping elementMapping = this.matchElements(sourceelement, targetelement);
                    elementScore = elementMapping.getScore();
                    tmpScore += elementScore;
                    mappingPartList.addMapping(elementMapping);
                    ++i;
                }
                if (sequenceScore < tmpScore) {
                    index.clear();
                    index.add(j);
                    tmplist.clear();
                    tmplist.add(mappingPartList);
                    sequenceScore = tmpScore;
                } else if (sequenceScore == tmpScore) {
                    index.add(j);
                    tmplist.add(mappingPartList);
                }
                ++j;
            }
            sequenceMapping.setMappingPartLists(tmplist);
            return sequenceMapping;
        }
        if (source.getLength() > target.getLength()) {
            ArrayList<MappingPartList> tmplist = new ArrayList<MappingPartList>();
            int j = 0;
            while (j <= source.getLength() - target.getLength()) {
                int tmpScore = 0;
                MappingPartList mappingPartList = new MappingPartList();
                int i = 0;
                while (i < target.getLength()) {
                    Element sourceElement = source.getElement(i + j);
                    Element targetElement = target.getElement(i);
                    Mapping elementMapping = this.matchElements(sourceElement, targetElement);
                    elementScore = elementMapping.getScore();
                    tmpScore += elementScore;
                    mappingPartList.addMapping(elementMapping);
                    ++i;
                }
                if (sequenceScore < tmpScore) {
                    index.clear();
                    index.add(j);
                    tmplist.clear();
                    tmplist.add(mappingPartList);
                    sequenceScore = tmpScore;
                } else if (sequenceScore == tmpScore) {
                    index.add(j);
                    tmplist.add(mappingPartList);
                }
                ++j;
            }
            sequenceMapping.setMappingPartLists(tmplist);
            return sequenceMapping;
        }
        return null;
    }

    private Sequence generateSequence(ComplexType type) {
        Sequence sequence = new Sequence(type.getElementList().size());
        ListIterator<Element> elements = type.getElementList().listIterator();
        while (elements.hasNext()) {
            Element element = elements.next();
            sequence.setElement(elements.nextIndex() - 1, element);
        }
        return sequence;
    }

    public Mapping getServiceMapping() {
        return this.serviceMapping;
    }

    public boolean isEdit() {
        return this.edit;
    }

    public void setEdit(boolean edit) {
        this.edit = edit;
    }
}

