/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.wsdlanalyzer.parser;

import de.dfki.wsdlanalyzer.matcher.NameTokens;
import de.dfki.wsdlanalyzer.matcher.StopWords;
import de.dfki.wsdlanalyzer.parser.Parser;
import de.dfki.wsdlanalyzer.parser.SimpleTypeLookupTable;
import de.dfki.wsdlanalyzer.types.Attribute;
import de.dfki.wsdlanalyzer.types.Binding;
import de.dfki.wsdlanalyzer.types.BindingOperation;
import de.dfki.wsdlanalyzer.types.ComplexType;
import de.dfki.wsdlanalyzer.types.Element;
import de.dfki.wsdlanalyzer.types.Message;
import de.dfki.wsdlanalyzer.types.MessageParameter;
import de.dfki.wsdlanalyzer.types.NodeIdentifier;
import de.dfki.wsdlanalyzer.types.Operation;
import de.dfki.wsdlanalyzer.types.Port;
import de.dfki.wsdlanalyzer.types.PortType;
import de.dfki.wsdlanalyzer.types.Service;
import de.dfki.wsdlanalyzer.types.TypeList;
import de.dfki.wsdlanalyzer.types.WsdlFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.axis.components.logger.LogFactory;
import org.apache.commons.logging.Log;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WsdlFileParser {
    private WsdlFile wsdlFile;
    private Parser parser;
    private SimpleTypeLookupTable lookupTable;
    private Document document;
    private HashMap<String, Node> elementNodes;
    private HashMap<String, Node> complexContentNodes;
    private HashMap<String, String> nameSpaceMap;
    StopWords stopWords;
    private String serviceType = "Service";
    private String portType = "Port";
    private String bindingType = "Binding";
    private String portTypeType = "PortType";
    private String operationType = "Operation";
    private String messageType = "Message";
    private String inputType = "Input";
    private String outputType = "Output";
    private String faultType = "Fault";
    private String parameterType = "Parameter";
    private String complexTypeType = "ComplexType";
    private String localTypeType = "LocalType";
    private String simpleType = "SimpleType";
    private String elementType = "Element";
    private String attributeType = "Attribute";
    protected static Log log = LogFactory.getLog((String)WsdlFileParser.class.getName());

    public WsdlFileParser(String filename, SimpleTypeLookupTable t) {
        this.wsdlFile = new WsdlFile(filename);
        this.lookupTable = t;
        this.parser = new Parser(filename);
        this.document = this.parser.getDomTree();
        this.stopWords = new StopWords();
        this.nameSpaceMap = new HashMap();
    }

    public void parseWsdl() {
        this.parseNameSpaces();
        if (this.hasTypes()) {
            this.parseTypes();
            this.computeAllLeafNumbers();
        }
        this.parseMessages();
        this.parsePortTypes();
        this.parseBindings();
        this.parseServices();
        if (log.isDebugEnabled()) {
            log.debug((Object)this.wsdlFile.log());
        }
    }

    private void parseNameSpaces() {
        NodeList definitionList = this.document.getElementsByTagName("wsdl:definitions");
        if (definitionList.getLength() == 0) {
            definitionList = this.document.getElementsByTagName("definitions");
        }
        Node definitionsNode = definitionList.item(0);
        NamedNodeMap definitionsAttributeMap = definitionsNode.getAttributes();
        String targetNamespace = null;
        if (definitionsAttributeMap != null) {
            if (definitionsAttributeMap.getNamedItem("targetNamespace") != null) {
                targetNamespace = definitionsAttributeMap.getNamedItem("targetNamespace").getNodeValue();
            }
            this.wsdlFile.setTargetNameSpace(targetNamespace);
            int i = 0;
            while (i < definitionsAttributeMap.getLength()) {
                Node attribute = definitionsAttributeMap.item(i);
                if (attribute.getNodeName().startsWith("xmlns")) {
                    if (attribute.getNodeName().contains(":")) {
                        String prefix = this.withoutPrefix(attribute.getNodeName());
                        this.nameSpaceMap.put(prefix, attribute.getNodeValue());
                    } else {
                        this.nameSpaceMap.put("default", attribute.getNodeValue());
                    }
                }
                ++i;
            }
        }
    }

    private boolean hasTypes() {
        NodeList documentchilds = this.document.getChildNodes();
        int h = 0;
        while (h < documentchilds.getLength()) {
            NodeList grandchilds = documentchilds.item(h).getChildNodes();
            int r = 0;
            while (r < grandchilds.getLength()) {
                if (grandchilds.item(r).getNodeType() == 1 && grandchilds.item(r).getNodeName().contains("types")) {
                    return true;
                }
                ++r;
            }
            ++h;
        }
        return false;
    }

    private void parseTypes() {
        this.elementNodes = new HashMap();
        this.complexContentNodes = new HashMap();
        NodeList schemaList = this.document.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "schema");
        int i = 0;
        while (i < schemaList.getLength()) {
            NamedNodeMap schemaAttributeMap = schemaList.item(i).getAttributes();
            String targetNamespace = null;
            if (schemaAttributeMap.getNamedItem("targetNamespace") != null) {
                targetNamespace = schemaAttributeMap.getNamedItem("targetNamespace").getNodeValue();
            }
            NodeList types = schemaList.item(i).getChildNodes();
            int j = 0;
            while (j < types.getLength()) {
                if (types.item(j).getNodeType() == 1) {
                    String kindofnode = types.item(j).getLocalName();
                    if (kindofnode.equals("element")) {
                        this.parseElementNode(types.item(j), targetNamespace);
                    } else if (kindofnode.equals("complexType")) {
                        String typename = this.getAttributeValue(types.item(j), "name");
                        if (typename != null) {
                            this.parseComplexTypeNode(typename, types.item(j), targetNamespace, false, null);
                        }
                    } else if (kindofnode.equals("simpleType")) {
                        this.parseSimpleTypeNode(types.item(j));
                    }
                }
                ++j;
            }
            ++i;
        }
        if (!this.elementNodes.isEmpty()) {
            for (String name : this.elementNodes.keySet()) {
                Node elementNode = this.elementNodes.get(name);
                this.parseElementNode(elementNode, null);
            }
        }
        if (!this.complexContentNodes.isEmpty()) {
            for (String typename : this.complexContentNodes.keySet()) {
                Node complexcontentnode = this.complexContentNodes.get(typename);
                ComplexType complextype = this.wsdlFile.getTypeList().getType(typename);
                this.parseComplexContent(complexcontentnode, complextype);
            }
        }
    }

    private void parseElementNode(Node elementNode, String targetNamespace) {
        String elementName = this.getAttributeValue(elementNode, "name");
        NodeIdentifier elementIdentifier = new NodeIdentifier(elementName, this.elementType);
        if (elementNode.hasChildNodes()) {
            NodeList children = elementNode.getChildNodes();
            int h = 0;
            while (h < children.getLength()) {
                if (children.item(h).getNodeType() == 1) {
                    if (children.item(h).getLocalName().equals("complexType")) {
                        this.parseComplexTypeNode(elementName, children.item(h), targetNamespace, false, null);
                    } else if (log.isDebugEnabled()) {
                        log.debug((Object)("unknown tag: " + children.item(h).getLocalName()));
                    }
                }
                ++h;
            }
        } else {
            String typeName = this.getAttributeValue(elementNode, "type");
            String typePrefix = this.getPrefix(typeName);
            if (!elementName.equals(typeName = this.withoutPrefix(typeName))) {
                if (this.lookupTable.lookupSimpleType(typeName)) {
                    this.lookupTable.insertSimpleType(elementName, typeName);
                } else {
                    ComplexType type = this.wsdlFile.getTypeList().getType(typeName);
                    if (type != null) {
                        this.wsdlFile.getTypeList().insertComplexElement(elementName, type);
                    } else {
                        this.elementNodes.put(elementName, elementNode);
                    }
                }
                Element element = new Element(elementName);
                element.setType(typeName);
                element.setTypePrefix(typePrefix);
                element.setNodeIdentifier(elementIdentifier);
                this.wsdlFile.getElementlist().put(elementName, element);
            }
        }
    }

    private void parseComplexTypeNode(String typename, Node complextypenode, String targetnamespace, boolean localtype, NodeIdentifier parentIdentifier) {
        NodeIdentifier complexTypeIdentifier = new NodeIdentifier();
        if (localtype) {
            complexTypeIdentifier = new NodeIdentifier(parentIdentifier);
            complexTypeIdentifier.addIdentifier(typename, this.localTypeType);
        } else {
            complexTypeIdentifier.addIdentifier(typename, this.complexTypeType);
        }
        ComplexType complexType = new ComplexType(typename);
        NameTokens token = new NameTokens(typename, this.stopWords);
        complexType.setToken(token);
        complexType.setNodeIdentifier(complexTypeIdentifier);
        if (complextypenode.hasChildNodes()) {
            NodeList childs = complextypenode.getChildNodes();
            int h = 0;
            while (h < childs.getLength()) {
                if (childs.item(h).getNodeType() == 1) {
                    NodeList elements;
                    if (childs.item(h).getLocalName().equals("complexContent")) {
                        this.parseComplexContent(childs.item(h), complexType);
                    } else if (childs.item(h).getLocalName().equals("simpleContent")) {
                        this.parseSimpleContent(childs.item(h), complexType);
                    } else if (childs.item(h).getLocalName().equals("sequence")) {
                        complexType.setGrouping(1);
                        if (childs.item(h).hasChildNodes()) {
                            elements = childs.item(h).getChildNodes();
                            this.parseElementsOfComplexType(complexType, elements);
                        }
                    } else if (childs.item(h).getLocalName().equals("all")) {
                        complexType.setGrouping(2);
                        if (childs.item(h).hasChildNodes()) {
                            elements = childs.item(h).getChildNodes();
                            this.parseElementsOfComplexType(complexType, elements);
                        }
                    } else if (childs.item(h).getLocalName().equals("choice")) {
                        complexType.setGrouping(3);
                        if (childs.item(h).hasChildNodes()) {
                            elements = childs.item(h).getChildNodes();
                            this.parseElementsOfComplexType(complexType, elements);
                        }
                    } else if (childs.item(h).getLocalName().equals("attribute")) {
                        if (complexType.getGrouping() == 0) {
                            complexType.setGrouping(-1);
                        }
                        this.parseAttributeOfComplexType(complexType, childs.item(h));
                    } else if (log.isDebugEnabled()) {
                        log.debug((Object)("unknown tag: " + childs.item(h).getLocalName()));
                    }
                }
                ++h;
            }
        }
        this.wsdlFile.getTypeList().insertComplexType(complexType);
    }

    private void parseSimpleTypeNode(Node simpletypenode) {
        NodeList simpleChilds;
        NamedNodeMap attributeMap = simpletypenode.getAttributes();
        String name = null;
        if (attributeMap.getLength() > 0) {
            name = attributeMap.getNamedItem("name").getNodeValue();
        }
        if ((simpleChilds = simpletypenode.getChildNodes()).getLength() > 0) {
            int h = 0;
            while (h < simpleChilds.getLength()) {
                if (simpleChilds.item(h).getNodeType() == 1 && simpleChilds.item(h).getLocalName().equals("restriction")) {
                    NamedNodeMap restrictionattributes = simpleChilds.item(h).getAttributes();
                    String type = restrictionattributes.getNamedItem("base").getNodeValue();
                    if (type.indexOf(":") != -1) {
                        String[] prefixtype = type.split(":");
                        this.lookupTable.insertSimpleType(name, prefixtype[1]);
                    } else {
                        this.lookupTable.insertSimpleType(name, type);
                    }
                }
                ++h;
            }
        }
    }

    private void parseElementsOfComplexType(ComplexType complexType, NodeList elements) {
        int i = 0;
        while (i < elements.getLength()) {
            Node elementNode;
            if (elements.item(i).getNodeType() == 1 && (elementNode = elements.item(i)).getLocalName() != null) {
                NameTokens token;
                NodeIdentifier elementIdentifier;
                Element artificialElement;
                if (elementNode.getLocalName().equals("element")) {
                    String minOccurs;
                    Element element = new Element();
                    String elementName = this.getAttributeValue(elementNode, "name");
                    if (elementName != null) {
                        element.setName(elementName);
                        NodeIdentifier elementIdentifier2 = new NodeIdentifier(elementName, this.elementType, complexType.getNodeIdentifier());
                        NameTokens token2 = new NameTokens(elementName, this.stopWords);
                        element.setToken(token2);
                        element.setNodeIdentifier(elementIdentifier2);
                        String typehlp = this.getAttributeValue(elementNode, "type");
                        if (typehlp != null) {
                            int colon = typehlp.indexOf(":");
                            if (colon == -1) {
                                element.setType(typehlp);
                                element.setElementPrefix(null);
                                if (this.lookupTable.lookupSimpleType(typehlp)) {
                                    element.setSimple(true);
                                } else {
                                    element.setSimple(false);
                                }
                            } else {
                                String[] prefixname = typehlp.split(":");
                                element.setElementPrefix(prefixname[0]);
                                element.setType(prefixname[1]);
                                if (this.lookupTable.lookupSimpleType(prefixname[1])) {
                                    element.setSimple(true);
                                } else {
                                    element.setSimple(false);
                                }
                            }
                        } else if (elementNode.hasChildNodes()) {
                            NodeList childs = elementNode.getChildNodes();
                            int k = 0;
                            while (k < childs.getLength()) {
                                if (childs.item(k).getNodeType() == 1 && childs.item(k).getLocalName() != null) {
                                    if (childs.item(k).getLocalName().equals("complexType")) {
                                        String localtype = String.valueOf(elementName) + "LocalType";
                                        element.setType(localtype);
                                        element.setSimple(false);
                                        this.parseComplexTypeNode(localtype, childs.item(k), complexType.getNameSpace(), true, complexType.getNodeIdentifier());
                                    } else if (log.isDebugEnabled()) {
                                        log.debug((Object)("unknown tag: " + childs.item(k).getLocalName()));
                                    }
                                }
                                ++k;
                            }
                        } else {
                            element.setType("anyType");
                            element.setElementPrefix(null);
                            element.setSimple(true);
                        }
                    } else {
                        String ref = this.getAttributeValue(elementNode, "ref");
                        if (ref != null) {
                            element.setName(ref);
                            element.setType(ref);
                            NodeIdentifier elementIdentifier3 = new NodeIdentifier(ref, this.elementType, complexType.getNodeIdentifier());
                            NameTokens token3 = new NameTokens(ref, this.stopWords);
                            element.setToken(token3);
                            element.setNodeIdentifier(elementIdentifier3);
                        }
                    }
                    String nillable = this.getAttributeValue(elementNode, "nillable");
                    if (nillable != null) {
                        if (nillable.equals("true")) {
                            element.setNillable(true);
                        } else {
                            element.setNillable(false);
                        }
                    }
                    if ((minOccurs = this.getAttributeValue(elementNode, "minOccurs")) != null) {
                        Integer minoccur = new Integer(minOccurs);
                        element.setMinOccur(minoccur);
                    } else {
                        element.setMinOccur(1);
                    }
                    String maxOccurs = this.getAttributeValue(elementNode, "maxOccurs");
                    if (maxOccurs != null) {
                        if (maxOccurs.equals("unbounded")) {
                            Integer maxoccur = new Integer(Integer.MAX_VALUE);
                            element.setMaxOccur(maxoccur);
                        } else {
                            Integer maxoccur = new Integer(maxOccurs);
                            element.setMaxOccur(maxoccur);
                        }
                    } else {
                        element.setMaxOccur(1);
                    }
                    complexType.addElement(element);
                } else if (elementNode.getLocalName().equals("all")) {
                    artificialElement = new Element(String.valueOf(complexType.getName()) + "All");
                    artificialElement.setType(String.valueOf(complexType.getName()) + "All");
                    elementIdentifier = new NodeIdentifier(artificialElement.getName(), this.elementType, complexType.getNodeIdentifier());
                    artificialElement.setNodeIdentifier(elementIdentifier);
                    token = new NameTokens(artificialElement.getName(), this.stopWords);
                    artificialElement.setToken(token);
                    this.parseArtificialComplexType(complexType, artificialElement, 2, elementNode);
                } else if (elementNode.getLocalName().equals("choice")) {
                    artificialElement = new Element(String.valueOf(complexType.getName()) + "Choice");
                    artificialElement.setType(String.valueOf(complexType.getName()) + "Choice");
                    elementIdentifier = new NodeIdentifier(artificialElement.getName(), this.elementType, complexType.getNodeIdentifier());
                    artificialElement.setNodeIdentifier(elementIdentifier);
                    token = new NameTokens(artificialElement.getName(), this.stopWords);
                    artificialElement.setToken(token);
                    this.parseArtificialComplexType(complexType, artificialElement, 3, elementNode);
                } else if (elementNode.getLocalName().equals("sequence")) {
                    artificialElement = new Element(String.valueOf(complexType.getName()) + "Sequence");
                    artificialElement.setType(String.valueOf(complexType.getName()) + "Sequence");
                    elementIdentifier = new NodeIdentifier(artificialElement.getName(), this.elementType, complexType.getNodeIdentifier());
                    artificialElement.setNodeIdentifier(elementIdentifier);
                    token = new NameTokens(artificialElement.getName(), this.stopWords);
                    artificialElement.setToken(token);
                    this.parseArtificialComplexType(complexType, artificialElement, 1, elementNode);
                } else {
                    System.out.println("\n&&&&&&& unknown child of <all/choice/sequence> &&&&&&\n" + this.wsdlFile.getWsdlFileName());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("unknown child-tag of <all/choice/sequence>: " + elementNode.getLocalName()));
                    }
                }
            }
            ++i;
        }
    }

    private void parseComplexContent(Node complexContentNode, ComplexType complexType) {
        NodeList childs = complexContentNode.getChildNodes();
        int i = 0;
        while (i < childs.getLength()) {
            if (childs.item(i).getNodeType() == 1 && childs.item(i).getLocalName() != null) {
                String baseName;
                if (childs.item(i).getLocalName().equals("restriction")) {
                    String base = this.getAttributeValue(childs.item(i), "base");
                    if (base.equals("soapenc:Array")) {
                        complexType.setArray();
                        NodeList restrictionchilds = childs.item(i).getChildNodes();
                        int j = 0;
                        while (j < restrictionchilds.getLength()) {
                            if (restrictionchilds.item(j).getLocalName() != null) {
                                if (restrictionchilds.item(j).getLocalName().equals("attribute")) {
                                    String arrayType = this.getAttributeValue(restrictionchilds.item(j), "wsdl:arrayType");
                                    if (arrayType != null) {
                                        String[] prefixType = arrayType.split(":");
                                        String hlp = prefixType[1].substring(0, prefixType[1].length() - 2);
                                        complexType.setArrayPrefix(prefixType[0]);
                                        complexType.setArrayType(hlp);
                                        break;
                                    }
                                } else if (restrictionchilds.item(j).getLocalName().equals("sequence")) {
                                    NodeList sequencechilds = restrictionchilds.item(j).getChildNodes();
                                    int h = 0;
                                    while (h < sequencechilds.getLength()) {
                                        String typeName;
                                        if (sequencechilds.item(h).getNodeType() == 1 && (typeName = this.getAttributeValue(sequencechilds.item(h), "type")) != null) {
                                            String[] type = typeName.split(":");
                                            complexType.setArrayPrefix(type[0]);
                                            complexType.setArrayType(type[1]);
                                        }
                                        ++h;
                                    }
                                }
                            }
                            ++j;
                        }
                    }
                } else if (childs.item(i).getLocalName().equals("extension") && (baseName = this.getAttributeValue(childs.item(i), "base")) != null) {
                    String[] base = baseName.split(":");
                    if (this.wsdlFile.getTypeList().containsKey(base[1])) {
                        ComplexType basetype = this.wsdlFile.getTypeList().getType(base[1]);
                        complexType.addElementList(basetype.getElementList());
                        NodeList extensionchilds = childs.item(i).getChildNodes();
                        int m = 0;
                        while (m < extensionchilds.getLength()) {
                            if (extensionchilds.item(m).getNodeType() == 1) {
                                NodeList elements;
                                if (extensionchilds.item(m).getLocalName().equals("sequence")) {
                                    complexType.setGrouping(1);
                                    if (extensionchilds.item(m).hasChildNodes()) {
                                        elements = extensionchilds.item(m).getChildNodes();
                                        this.parseElementsOfComplexType(complexType, elements);
                                    }
                                } else if (extensionchilds.item(m).getLocalName().equals("all")) {
                                    complexType.setGrouping(2);
                                    if (extensionchilds.item(m).hasChildNodes()) {
                                        elements = extensionchilds.item(m).getChildNodes();
                                        this.parseElementsOfComplexType(complexType, elements);
                                    }
                                } else if (extensionchilds.item(m).getLocalName().equals("choice")) {
                                    complexType.setGrouping(3);
                                    if (extensionchilds.item(m).hasChildNodes()) {
                                        elements = extensionchilds.item(m).getChildNodes();
                                        this.parseElementsOfComplexType(complexType, elements);
                                    }
                                } else if (extensionchilds.item(m).getLocalName().equals("attribute")) {
                                    complexType.setGrouping(basetype.getGrouping());
                                    this.parseAttributeOfComplexType(complexType, extensionchilds.item(m));
                                } else if (log.isDebugEnabled()) {
                                    log.debug((Object)("unknown tag: " + extensionchilds.item(m).getLocalName()));
                                }
                            }
                            ++m;
                        }
                    } else {
                        this.complexContentNodes.put(complexType.getName(), complexContentNode);
                    }
                }
            }
            ++i;
        }
    }

    private void parseSimpleContent(Node simpleContentNode, ComplexType complexType) {
        NodeList simpleContentChilds = simpleContentNode.getChildNodes();
        int i = 0;
        while (i < simpleContentChilds.getLength()) {
            if (simpleContentChilds.item(i).getNodeType() == 1) {
                if (simpleContentChilds.item(i).getLocalName().equals("extension")) {
                    String baseType = this.getAttributeValue(simpleContentChilds.item(i), "base");
                    if (baseType != null) {
                        Element artificialElement = new Element(complexType.getName());
                        artificialElement.setType(this.withoutPrefix(baseType));
                        NodeIdentifier artificialIdentifier = new NodeIdentifier(complexType.getName(), this.elementType, complexType.getNodeIdentifier());
                        artificialElement.setNodeIdentifier(artificialIdentifier);
                        NameTokens token = new NameTokens(complexType.getName(), this.stopWords);
                        artificialElement.setToken(token);
                        complexType.getElementList().add(artificialElement);
                    }
                    if (simpleContentChilds.item(i).hasChildNodes()) {
                        this.parseExtensionNode(simpleContentChilds.item(i), complexType);
                    }
                } else if (!simpleContentChilds.item(i).getLocalName().equals("restriction") && log.isDebugEnabled()) {
                    log.debug((Object)("unknown tag: " + simpleContentChilds.item(i).getLocalName()));
                }
            }
            ++i;
        }
    }

    private void parseAttributeOfComplexType(ComplexType complexType, Node attribute) {
        String attributeName = this.getAttributeValue(attribute, "name");
        String attributesType = null;
        String attributeUse = null;
        if (this.getAttributeValue(attribute, "type") != null) {
            attributesType = this.withoutPrefix(this.getAttributeValue(attribute, "type"));
        }
        if (this.getAttributeValue(attribute, "use") != null) {
            attributeUse = this.getAttributeValue(attribute, "use");
        }
        Attribute complexTypeAttribute = new Attribute(attributeName, attributesType, attributeUse);
        NodeIdentifier attributeIdentifier = new NodeIdentifier(attributeName, this.attributeType, complexType.getNodeIdentifier());
        complexTypeAttribute.setId(attributeIdentifier);
        NameTokens attributeToken = new NameTokens(attributeName, this.stopWords);
        complexTypeAttribute.setToken(attributeToken);
        if (attribute.hasChildNodes()) {
            NodeList attributeChilds = attribute.getChildNodes();
            int i = 0;
            while (i < attributeChilds.getLength()) {
                Node attributeChild = attributeChilds.item(i);
                if (attributeChild.getNodeType() == 1 && attributeChild.getLocalName().equals("simpleType")) {
                    NodeList simpleTypeChilds = attributeChild.getChildNodes();
                    int j = 0;
                    while (j < simpleTypeChilds.getLength()) {
                        Node simpleTypeChild = simpleTypeChilds.item(j);
                        if (simpleTypeChild.getNodeType() == 1 && simpleTypeChild.getLocalName().equals("restriction")) {
                            String baseType = this.withoutPrefix(this.getAttributeValue(simpleTypeChild, "base"));
                            complexTypeAttribute.setType(baseType);
                            simpleTypeChild.hasChildNodes();
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        complexType.addAttribute(attributeName, complexTypeAttribute);
    }

    private void parseExtensionNode(Node extensionNode, ComplexType complexType) {
        NodeList extensionChildren = extensionNode.getChildNodes();
        int i = 0;
        while (i < extensionChildren.getLength()) {
            Node extensionChild = extensionChildren.item(i);
            if (extensionChild.getNodeType() == 1) {
                if (extensionChild.getLocalName().equals("attribute")) {
                    this.parseAttributeOfComplexType(complexType, extensionChild);
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)("unknown tag: " + extensionChild.getLocalName()));
                }
            }
            ++i;
        }
    }

    private void parseMessages() {
        NodeList messagelist = this.document.getElementsByTagName("wsdl:message");
        if (messagelist.getLength() == 0) {
            messagelist = this.document.getElementsByTagName("message");
        }
        int i = 0;
        while (i < messagelist.getLength()) {
            String messageName = this.getAttributeValue(messagelist.item(i), "name");
            NodeIdentifier messageIdentifier = new NodeIdentifier(messageName, this.messageType);
            Message message = new Message(messageName);
            NameTokens token = new NameTokens(messageName, this.stopWords);
            message.setToken(token);
            message.setNodeIdentifier(messageIdentifier);
            NodeList parameters = messagelist.item(i).getChildNodes();
            int j = 0;
            while (j < parameters.getLength()) {
                if (parameters.item(j).getNodeType() == 1 && parameters.item(j).getLocalName().contains("part")) {
                    Object type;
                    String parameterName = this.getAttributeValue(parameters.item(j), "name");
                    NameTokens parameterToken = new NameTokens(parameterName, this.stopWords);
                    NodeIdentifier parameterIdentifier = new NodeIdentifier(messageIdentifier);
                    parameterIdentifier.addIdentifier(parameterName, this.parameterType);
                    Object parametertype = "";
                    String element = this.getAttributeValue(parameters.item(j), "element");
                    if (element != null) {
                        parametertype = element;
                    } else {
                        type = this.getAttributeValue(parameters.item(j), "type");
                        if (type != null) {
                            parametertype = type;
                        }
                    }
                    type = parametertype.split(":");
                    if (this.lookupTable.lookupSimpleType(type[1])) {
                        parameterIdentifier.addIdentifier(type[1], this.simpleType);
                    } else {
                        parameterIdentifier.addIdentifier(type[1], this.complexTypeType);
                    }
                    MessageParameter messageParameter = new MessageParameter(parameterName, type[0], type[1]);
                    messageParameter.setToken(parameterToken);
                    messageParameter.setNodeIdentifier(parameterIdentifier);
                    message.insertParameter(messageParameter);
                }
                ++j;
            }
            this.wsdlFile.getMessageList().insertMessage(message);
            ++i;
        }
    }

    private void parseArtificialComplexType(ComplexType complexType, Element artificialElement, int grouping, Node elementNode) {
        complexType.addElement(artificialElement);
        ComplexType artificialComplexType = new ComplexType(artificialElement.getName());
        artificialComplexType.setGrouping(grouping);
        artificialComplexType.setNodeIdentifier(complexType.getNodeIdentifier());
        NameTokens artificialToken = new NameTokens(artificialComplexType.getName(), this.stopWords);
        artificialComplexType.setToken(artificialToken);
        NodeList nestedElements = elementNode.getChildNodes();
        this.parseElementsOfComplexType(artificialComplexType, nestedElements);
        this.wsdlFile.getTypeList().insertComplexType(artificialComplexType);
    }

    private void parsePortTypes() {
        NodeList porttypelist = this.document.getElementsByTagName("wsdl:portType");
        if (porttypelist.getLength() == 0) {
            porttypelist = this.document.getElementsByTagName("portType");
        }
        int i = 0;
        while (i < porttypelist.getLength()) {
            String portTypeName = this.getAttributeValue(porttypelist.item(i), "name");
            NodeIdentifier portTypeIdentifier = new NodeIdentifier(portTypeName, this.portTypeType);
            PortType portType = new PortType(portTypeName);
            NameTokens token = new NameTokens(portTypeName, this.stopWords);
            portType.setToken(token);
            portType.setNodeIdentifier(portTypeIdentifier);
            this.parseOperations(porttypelist.item(i), portType);
            this.wsdlFile.getPorttypelist().put(portTypeName, portType);
            ++i;
        }
    }

    private void parseOperations(Node porttypenode, PortType porttype) {
        if (porttypenode.hasChildNodes()) {
            NodeList portTypeChilds = porttypenode.getChildNodes();
            int j = 0;
            while (j < portTypeChilds.getLength()) {
                Node operationNode = portTypeChilds.item(j);
                if (operationNode.getNodeType() == 1 && operationNode.getNodeName().contains("operation")) {
                    String operationName = this.getAttributeValue(operationNode, "name");
                    NodeIdentifier operationIdentifier = new NodeIdentifier(porttype.getNodeIdentifier());
                    operationIdentifier.addIdentifier(operationName, this.operationType);
                    Operation operation = new Operation(operationName);
                    operation.setNodeIdentifier(operationIdentifier);
                    NameTokens token = new NameTokens(operationName, this.stopWords);
                    operation.setToken(token);
                    String parameterOrder = this.getAttributeValue(operationNode, "parameterOrder");
                    if (parameterOrder != null) {
                        operation.setParameterorder(parameterOrder.split(" "));
                    }
                    this.parseMessages(operationNode, operation);
                    porttype.insertOperation(operation);
                    this.wsdlFile.getOperationlist().insertOperation(operation);
                }
                ++j;
            }
        }
    }

    private void parseMessages(Node operationnode, Operation operation) {
        if (operationnode.hasChildNodes()) {
            NodeList operationchilds = operationnode.getChildNodes();
            int j = 0;
            while (j < operationchilds.getLength()) {
                Node messagenode = operationchilds.item(j);
                if (messagenode.getNodeType() == 1) {
                    NamedNodeMap attributes = messagenode.getAttributes();
                    if (messagenode.getNodeName().contains("input")) {
                        String inputName = attributes.getNamedItem("message").getNodeValue();
                        inputName = this.withoutPrefix(inputName);
                        NodeIdentifier inputIdentifier = new NodeIdentifier(operation.getNodeIdentifier());
                        inputIdentifier.addIdentifier(inputName, this.inputType);
                        operation.setInput(inputName);
                        operation.setInputId(inputIdentifier);
                    } else if (messagenode.getNodeName().contains("output")) {
                        String outputName = attributes.getNamedItem("message").getNodeValue();
                        outputName = this.withoutPrefix(outputName);
                        NodeIdentifier outputIdentifier = new NodeIdentifier(operation.getNodeIdentifier());
                        outputIdentifier.addIdentifier(outputName, this.outputType);
                        operation.setOutput(outputName);
                        operation.setOutputId(outputIdentifier);
                    } else if (messagenode.getNodeName().contains("fault")) {
                        String faultName = attributes.getNamedItem("message").getNodeValue();
                        faultName = this.withoutPrefix(faultName);
                        NodeIdentifier faultIdentifier = new NodeIdentifier(operation.getNodeIdentifier());
                        faultIdentifier.addIdentifier(faultName, this.faultType);
                        operation.setFault(faultName);
                        operation.setFaultId(faultIdentifier);
                    }
                }
                ++j;
            }
        }
    }

    private void parseBindings() {
        NodeList bindinglist = this.document.getElementsByTagName("wsdl:binding");
        if (bindinglist.getLength() == 0) {
            bindinglist = this.document.getElementsByTagName("binding");
        }
        int i = 0;
        while (i < bindinglist.getLength()) {
            NamedNodeMap attributemap = bindinglist.item(i).getAttributes();
            String bindingName = attributemap.getNamedItem("name").getNodeValue();
            Binding binding = new Binding(bindingName);
            String porttype = attributemap.getNamedItem("type").getNodeValue();
            porttype = this.withoutPrefix(porttype);
            binding.setPortType(porttype);
            NameTokens token = new NameTokens(bindingName, this.stopWords);
            binding.setToken(token);
            NodeIdentifier bindingId = new NodeIdentifier(bindingName, this.bindingType);
            binding.setNodeIdentifier(bindingId);
            NodeList children = bindinglist.item(i).getChildNodes();
            int j = 0;
            while (j < children.getLength()) {
                Node child = children.item(j);
                if (child.getNodeType() == 1) {
                    if (child.getNodeName().contains("soap:binding")) {
                        binding.setBindingType("SOAP");
                        NamedNodeMap soapBindingAttributes = child.getAttributes();
                        if (soapBindingAttributes.getNamedItem("style") != null) {
                            String style = soapBindingAttributes.getNamedItem("style").getNodeValue();
                            if (style.equals("rpc")) {
                                binding.setRPCStyle(true);
                            } else {
                                binding.setRPCStyle(false);
                            }
                        } else {
                            binding.setRPCStyle(false);
                        }
                        String transport = soapBindingAttributes.getNamedItem("transport").getNodeValue();
                        binding.setTransport(transport);
                    } else if (child.getNodeName().contains("operation")) {
                        BindingOperation bindingOperation = this.parseBindingOperation(child, binding.isRPCStyle());
                        binding.addBindingOperation(bindingOperation.getName(), bindingOperation);
                    }
                }
                ++j;
            }
            this.wsdlFile.getBindings().put(bindingName, binding);
            ++i;
        }
    }

    private BindingOperation parseBindingOperation(Node node, boolean style) {
        NamedNodeMap operationAttributes = node.getAttributes();
        BindingOperation bindingOperation = new BindingOperation(operationAttributes.getNamedItem("name").getNodeValue());
        NodeList operationChildren = node.getChildNodes();
        int i = 0;
        while (i < operationChildren.getLength()) {
            Node child = operationChildren.item(i);
            if (child.getNodeType() == 1) {
                String use;
                if (child.getNodeName().contains("soap:operation")) {
                    NamedNodeMap soapAttributes = child.getAttributes();
                    if (soapAttributes.getNamedItem("soapAction") != null) {
                        bindingOperation.setSoapAction(soapAttributes.getNamedItem("soapAction").getNodeValue());
                    }
                    if (soapAttributes.getNamedItem("style") != null) {
                        String type = soapAttributes.getNamedItem("style").getNodeValue();
                        if (type.equals("rpc")) {
                            bindingOperation.setRPC(true);
                        } else {
                            bindingOperation.setRPC(false);
                        }
                    } else {
                        bindingOperation.setRPC(style);
                    }
                } else if (child.getNodeName().contains("input")) {
                    NodeList inputChildren = child.getChildNodes();
                    int j = 0;
                    while (j < inputChildren.getLength()) {
                        Node inputChild = inputChildren.item(j);
                        if (inputChild.getNodeType() == 1 && inputChild.getNodeName().contains("soap:body")) {
                            NamedNodeMap inputAttributes = inputChild.getAttributes();
                            use = inputAttributes.getNamedItem("use").getNodeValue();
                            if (use.equals("literal")) {
                                bindingOperation.setInputLiteral(true);
                                bindingOperation.setInputEncoding(null);
                            } else {
                                bindingOperation.setInputLiteral(false);
                                bindingOperation.setInputEncoding(inputAttributes.getNamedItem("encodingStyle").getNodeValue());
                            }
                            if (inputAttributes.getNamedItem("namespace") != null) {
                                bindingOperation.setInputNameSpace(inputAttributes.getNamedItem("namespace").getNodeValue());
                            }
                        }
                        ++j;
                    }
                } else if (child.getNodeName().contains("output")) {
                    NodeList outputChildren = child.getChildNodes();
                    int j = 0;
                    while (j < outputChildren.getLength()) {
                        Node outputChild = outputChildren.item(j);
                        if (outputChild.getNodeType() == 1 && outputChild.getNodeName().contains("soap:body")) {
                            NamedNodeMap outputAttributes = outputChild.getAttributes();
                            use = outputAttributes.getNamedItem("use").getNodeValue();
                            if (use.equals("literal")) {
                                bindingOperation.setOutputLiteral(true);
                                bindingOperation.setOutputEncoding(null);
                            } else {
                                bindingOperation.setOutputLiteral(false);
                                bindingOperation.setOutputEncoding(outputAttributes.getNamedItem("encodingStyle").getNodeValue());
                            }
                            if (outputAttributes.getNamedItem("namespace") != null) {
                                bindingOperation.setOutputNameSpace(outputAttributes.getNamedItem("namespace").getNodeValue());
                            }
                        }
                        ++j;
                    }
                } else {
                    child.getNodeName().contains("fault");
                }
            }
            ++i;
        }
        return bindingOperation;
    }

    private void parseServices() {
        NodeList servicelist = this.document.getElementsByTagName("wsdl:service");
        if (servicelist.getLength() == 0) {
            servicelist = this.document.getElementsByTagName("service");
        }
        int i = 0;
        while (i < servicelist.getLength()) {
            NamedNodeMap attributemap = servicelist.item(i).getAttributes();
            String serviceName = attributemap.getNamedItem("name").getNodeValue();
            NameTokens token = new NameTokens(serviceName, this.stopWords);
            NodeIdentifier serviceIdentifier = new NodeIdentifier(serviceName, this.serviceType);
            Service service = new Service(serviceName);
            service.setToken(token);
            service.setNodeIdentifier(serviceIdentifier);
            NodeList servicechilds = servicelist.item(i).getChildNodes();
            int j = 0;
            while (j < servicechilds.getLength()) {
                Node portNode = servicechilds.item(j);
                if (portNode.getNodeType() == 1 && portNode.getNodeName().contains("port")) {
                    NamedNodeMap portattributemap = portNode.getAttributes();
                    String portName = portattributemap.getNamedItem("name").getNodeValue();
                    Port port = new Port(portName);
                    NameTokens portToken = new NameTokens(portName, this.stopWords);
                    NodeIdentifier portId = new NodeIdentifier(serviceIdentifier);
                    portId.addIdentifier(portName, this.portType);
                    String bindingName = portattributemap.getNamedItem("binding").getNodeValue();
                    bindingName = this.withoutPrefix(bindingName);
                    port.setBinding(bindingName);
                    port.setToken(portToken);
                    port.setNodeIdentifier(portId);
                    NodeList portChildren = portNode.getChildNodes();
                    int h = 0;
                    while (h < portChildren.getLength()) {
                        Node addressNode = portChildren.item(h);
                        if (addressNode.getNodeType() == 1 && addressNode.getNodeName().contains("address")) {
                            NamedNodeMap addressattributemap = addressNode.getAttributes();
                            String address = addressattributemap.getNamedItem("location").getNodeValue();
                            try {
                                port.setAddress(new URL(address));
                            }
                            catch (MalformedURLException ex) {
                                ex.printStackTrace();
                            }
                        }
                        ++h;
                    }
                    service.put(portName, port);
                }
                ++j;
            }
            this.wsdlFile.getServicelist().put(serviceName, service);
            ++i;
        }
    }

    private String withoutPrefix(String s) {
        if (s.contains(":")) {
            String[] split = s.split(":");
            return split[1];
        }
        return s;
    }

    private String getPrefix(String s) {
        if (s.contains(":")) {
            String[] split = s.split(":");
            return split[0];
        }
        return null;
    }

    private NodeIdentifier getNodeIdentifier(Node node, String name) {
        Node help = node;
        String nodeName = name;
        NodeIdentifier identifier = new NodeIdentifier(nodeName, this.complexTypeType);
        while (help.getParentNode() != null) {
            String parentName;
            String parentType = this.getNodeType(help = help.getParentNode());
            if (parentType == null || (parentName = this.getAttributeValue(help, "name")) == null || name.equals(parentName)) continue;
            nodeName = parentName;
            identifier.addParentIdentifier(nodeName, parentType);
        }
        return identifier;
    }

    private String getAttributeValue(Node node, String attributeName) {
        NamedNodeMap attributeMap = node.getAttributes();
        if (attributeMap != null) {
            Node attributeNode = attributeMap.getNamedItem(attributeName);
            if (attributeNode != null) {
                return attributeNode.getNodeValue();
            }
            return null;
        }
        return null;
    }

    private String getNodeType(Node node) {
        String type = node.getLocalName();
        if (type.equals("element")) {
            return type;
        }
        if (type.equals("complexType")) {
            return type;
        }
        return null;
    }

    private void computeAllLeafNumbers() {
        TypeList typeList = this.wsdlFile.getTypeList();
        Iterator<String> it = typeList.nameIterator();
        while (it.hasNext()) {
            ComplexType type;
            String name = it.next();
            if (!name.equals((type = typeList.getType(name)).getName())) continue;
            this.computeLeafNumbers(type);
        }
    }

    private void computeLeafNumbers(ComplexType type) {
        for (Element element : type.getElementList()) {
            if (element.getType().equals("anyType")) continue;
            if (element.getElementPrefix() == null) {
                if (this.lookupTable.lookupSimpleType(element.getType())) {
                    type.increaseNumberOfLeafElements();
                    continue;
                }
                if (this.wsdlFile.getTypeList().getType(element.getType()) == null) continue;
                type.increaseNumberOfNonLeafElements();
                continue;
            }
            if (element.getElementPrefix().startsWith("xs")) {
                if (this.lookupTable.lookupSimpleType(element.getType())) {
                    type.increaseNumberOfLeafElements();
                    continue;
                }
                if (this.wsdlFile.getTypeList().getType(element.getType()) == null) continue;
                type.increaseNumberOfNonLeafElements();
                continue;
            }
            if (this.wsdlFile.getTypeList().getType(element.getType()) != null) {
                type.increaseNumberOfNonLeafElements();
                continue;
            }
            if (!this.lookupTable.lookupSimpleType(element.getType())) continue;
            type.increaseNumberOfLeafElements();
        }
    }

    public WsdlFile getWsdlfile() {
        return this.wsdlFile;
    }

    public SimpleTypeLookupTable getLookuptable() {
        return this.lookupTable;
    }
}

