/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.wsdlanalyzer.types;

import de.dfki.wsdlanalyzer.matcher.NameTokens;
import de.dfki.wsdlanalyzer.types.NodeIdentifier;
import de.dfki.wsdlanalyzer.types.Port;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class Service {
    private String name;
    private HashMap<String, Port> ports;
    private NameTokens token;
    NodeIdentifier nodeIdentifier;

    public Service(String s) {
        this.name = s;
        this.ports = new HashMap();
        this.nodeIdentifier = new NodeIdentifier();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public HashMap<String, Port> getPorts() {
        return this.ports;
    }

    public void setPorts(HashMap<String, Port> ports) {
        this.ports = ports;
    }

    public void clear() {
        this.ports.clear();
    }

    public Object clone() {
        return this.ports.clone();
    }

    public boolean containsKey(Object arg0) {
        return this.ports.containsKey(arg0);
    }

    public boolean containsValue(Object arg0) {
        return this.ports.containsValue(arg0);
    }

    public Set<Map.Entry<String, Port>> entrySet() {
        return this.ports.entrySet();
    }

    public Port get(Object arg0) {
        return this.ports.get(arg0);
    }

    public boolean isEmpty() {
        return this.ports.isEmpty();
    }

    public Set<String> keySet() {
        return this.ports.keySet();
    }

    public Port put(String arg0, Port arg1) {
        return this.ports.put(arg0, arg1);
    }

    public Port remove(Object arg0) {
        return this.ports.remove(arg0);
    }

    public int size() {
        return this.ports.size();
    }

    public Collection<Port> values() {
        return this.ports.values();
    }

    public NameTokens getToken() {
        return this.token;
    }

    public void setToken(NameTokens token) {
        this.token = token;
    }

    public NodeIdentifier getNodeIdentifier() {
        return this.nodeIdentifier;
    }

    public void setNodeIdentifier(NodeIdentifier nodeIdentifier) {
        this.nodeIdentifier = nodeIdentifier;
    }

    public void print() {
        Iterator<String> iterator = this.ports.keySet().iterator();
        while (iterator.hasNext()) {
            Port port = this.ports.get(iterator.next());
            System.out.println("port: " + port.getName());
            System.out.println("binding: " + port.getBinding());
            System.out.println("endpoint: " + port.getAddress().toString());
        }
    }

    public String log() {
        String serviceLog = "Service: " + this.name + "\n";
        Iterator<String> iterator = this.ports.keySet().iterator();
        while (iterator.hasNext()) {
            Port port = this.ports.get(iterator.next());
            serviceLog = String.valueOf(serviceLog) + "port: " + port.getName() + "\n";
            serviceLog = String.valueOf(serviceLog) + "binding: " + port.getBinding() + "\n";
            serviceLog = String.valueOf(serviceLog) + "endpoint: " + port.getAddress().toString() + "\n";
        }
        return serviceLog;
    }
}

