/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.query.core.DataSourceImpl;
import com.hp.hpl.jena.query.engine.QueryEngineFactory;
import com.hp.hpl.jena.query.engine.QueryEngineRegistry;
import com.hp.hpl.jena.query.engineHTTP.QueryEngineHTTP;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.util.FileManager;
import java.util.List;
import org.apache.commons.logging.LogFactory;

public class QueryExecutionFactory {
    private QueryExecutionFactory() {
    }

    public static QueryExecution create(Query query) {
        QueryExecutionFactory.checkArg(query);
        return QueryExecutionFactory.make(query);
    }

    public static QueryExecution create(String queryStr) {
        QueryExecutionFactory.checkArg(queryStr);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr));
    }

    public static QueryExecution create(String queryStr, Syntax syntax) {
        QueryExecutionFactory.checkArg(queryStr);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr, syntax));
    }

    public static QueryExecution create(Query query, Dataset dataset) {
        return QueryExecutionFactory.make(query, dataset);
    }

    public static QueryExecution create(String queryStr, Dataset dataset) {
        QueryExecutionFactory.checkArg(queryStr);
        return QueryExecutionFactory.make(QueryExecutionFactory.makeQuery(queryStr), dataset);
    }

    public static QueryExecution create(String queryStr, Syntax syntax, Dataset dataset) {
        QueryExecutionFactory.checkArg(queryStr);
        return QueryExecutionFactory.make(QueryExecutionFactory.makeQuery(queryStr, syntax), dataset);
    }

    public static QueryExecution create(Query query, FileManager fm) {
        QueryExecutionFactory.checkArg(query);
        QueryExecution qe = QueryExecutionFactory.make(query);
        if (fm != null) {
            qe.setFileManager(fm);
        }
        return qe;
    }

    public static QueryExecution create(String queryStr, FileManager fm) {
        QueryExecutionFactory.checkArg(queryStr);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr), fm);
    }

    public static QueryExecution create(String queryStr, Syntax syntax, FileManager fm) {
        QueryExecutionFactory.checkArg(queryStr);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr, syntax), fm);
    }

    public static QueryExecution create(Query query, Model model) {
        QueryExecutionFactory.checkArg(query);
        QueryExecutionFactory.checkArg(model);
        return QueryExecutionFactory.make(query, new DataSourceImpl(model));
    }

    public static QueryExecution create(String queryStr, Model model) {
        QueryExecutionFactory.checkArg(queryStr);
        QueryExecutionFactory.checkArg(model);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr), model);
    }

    public static QueryExecution create(String queryStr, Syntax lang, Model model) {
        QueryExecutionFactory.checkArg(queryStr);
        QueryExecutionFactory.checkArg(model);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr, lang), model);
    }

    public static QueryExecution create(Query query, QuerySolution initialBinding) {
        QueryExecutionFactory.checkArg(query);
        QueryExecution qe = QueryExecutionFactory.make(query);
        if (initialBinding != null) {
            qe.setInitialBinding(initialBinding);
        }
        return qe;
    }

    public static QueryExecution create(String queryStr, QuerySolution initialBinding) {
        QueryExecutionFactory.checkArg(queryStr);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr), initialBinding);
    }

    public static QueryExecution create(String queryStr, Syntax syntax, QuerySolution initialBinding) {
        QueryExecutionFactory.checkArg(queryStr);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr, syntax), initialBinding);
    }

    public static QueryExecution create(Query query, Model model, QuerySolution initialBinding) {
        QueryExecutionFactory.checkArg(model);
        return QueryExecutionFactory.create(query, (Dataset)new DataSourceImpl(model), initialBinding);
    }

    public static QueryExecution create(String queryStr, Model model, QuerySolution initialBinding) {
        QueryExecutionFactory.checkArg(queryStr);
        QueryExecutionFactory.checkArg(model);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr), model, initialBinding);
    }

    public static QueryExecution create(String queryStr, Syntax syntax, Model model, QuerySolution initialBinding) {
        QueryExecutionFactory.checkArg(queryStr);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr, syntax), model, initialBinding);
    }

    public static QueryExecution create(Query query, Dataset dataset, QuerySolution initialBinding) {
        QueryExecutionFactory.checkArg(query);
        QueryExecution qe = QueryExecutionFactory.make(query, dataset);
        if (initialBinding != null) {
            qe.setInitialBinding(initialBinding);
        }
        return qe;
    }

    public static QueryExecution create(String queryStr, Dataset dataset, QuerySolution initialBinding) {
        QueryExecutionFactory.checkArg(queryStr);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr), dataset, initialBinding);
    }

    public static QueryExecution create(String queryStr, Syntax syntax, Dataset dataset, QuerySolution initialBinding) {
        QueryExecutionFactory.checkArg(queryStr);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr, syntax), dataset, initialBinding);
    }

    public static QueryExecution sparqlService(String service, Query query) {
        QueryExecutionFactory.checkNotNull(service, "URL for service is null");
        QueryExecutionFactory.checkArg(query);
        return QueryExecutionFactory.makeServiceRequest(service, query);
    }

    public static QueryExecution create(String service, Query query) {
        return QueryExecutionFactory.sparqlService(service, query);
    }

    public static QueryExecution sparqlService(String service, Query query, String defaultGraph) {
        QueryExecutionFactory.checkNotNull(service, "URL for service is null");
        QueryExecutionFactory.checkArg(query);
        QueryEngineHTTP qe = QueryExecutionFactory.makeServiceRequest(service, query);
        qe.addDefaultGraph(defaultGraph);
        return qe;
    }

    public static QueryExecution create(String service, Query query, String defaultGraph) {
        return QueryExecutionFactory.sparqlService(service, query, defaultGraph);
    }

    public static QueryExecution sparqlService(String service, Query query, List defaultGraphURIs, List namedGraphURIs) {
        QueryExecutionFactory.checkNotNull(service, "URL for service is null");
        QueryExecutionFactory.checkArg(query);
        QueryEngineHTTP qe = QueryExecutionFactory.makeServiceRequest(service, query);
        if (defaultGraphURIs != null) {
            qe.setDefaultGraphURIs(defaultGraphURIs);
        }
        if (namedGraphURIs != null) {
            qe.setNamedGraphURIs(namedGraphURIs);
        }
        return qe;
    }

    public static QueryExecution create(String service, Query query, List defaultGraphURIs, List namedGraphURIs) {
        return QueryExecutionFactory.sparqlService(service, query, defaultGraphURIs, namedGraphURIs);
    }

    private static Query makeQuery(String queryStr) {
        return QueryFactory.create(queryStr);
    }

    private static Query makeQuery(String queryStr, Syntax syntax) {
        return QueryFactory.create(queryStr, syntax);
    }

    private static QueryExecution make(Query query) {
        return QueryExecutionFactory.make(query, null);
    }

    private static QueryExecution make(Query query, Dataset dataset) {
        QueryEngineFactory f = QueryEngineRegistry.get().find(query, dataset);
        if (f == null) {
            LogFactory.getLog((Class)QueryExecutionFactory.class).warn((Object)("Failed to find a QueryEngineFactory for query: " + query));
            return null;
        }
        return f.create(query, dataset);
    }

    private static QueryEngineHTTP makeServiceRequest(String service, Query query) {
        return new QueryEngineHTTP(service, query);
    }

    private static void checkNotNull(Object obj, String msg) {
        if (obj == null) {
            throw new IllegalArgumentException(msg);
        }
    }

    private static void checkArg(Model model) {
        QueryExecutionFactory.checkNotNull(model, "Model is a null pointer");
    }

    private static void checkArg(String queryStr) {
        QueryExecutionFactory.checkNotNull(queryStr, "Query string is null");
    }

    private static void checkArg(Query query) {
        QueryExecutionFactory.checkNotNull(query, "Query is null");
    }
}

