/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.core;

import com.hp.hpl.jena.query.core.Element;
import com.hp.hpl.jena.query.core.ElementBasicGraphPattern;
import com.hp.hpl.jena.query.core.ElementFilter;
import com.hp.hpl.jena.query.core.ElementOptional;
import com.hp.hpl.jena.query.core.ElementTriplePattern;
import com.hp.hpl.jena.query.core.ElementVisitor;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ElementGroup
extends Element {
    private static Log log = LogFactory.getLog((Class)ElementGroup.class);
    List elements = new ArrayList();

    public void addElement(Element el) {
        ElementOptional elOpt;
        if (el instanceof ElementTriplePattern) {
            log.warn((Object)"Adding ElementTriplePattern to group directly (see addaddElementTriplePattern)");
        }
        if (el instanceof ElementFilter) {
            log.warn((Object)"Adding ElementTriplePattern to group directly (see addaddElementFilter)");
        }
        if (el instanceof ElementOptional && (elOpt = (ElementOptional)el).getFixedElement() == null) {
            if (this.elements.size() > 0) {
                elOpt.fixedPart = this.top();
                this.setTop(elOpt);
                return;
            }
            this.elements.add(new ElementBasicGraphPattern());
            elOpt.fixedPart = this.top();
        }
        this.elements.add(el);
    }

    public void addElementTriplePattern(ElementTriplePattern el) {
        this.ensureBGP().addElement(el);
    }

    public void addElementFilter(ElementFilter el) {
        this.ensureBGP().addElement(el);
    }

    private ElementBasicGraphPattern ensureBGP() {
        if (this.elements.size() == 0) {
            return this.pushBGP();
        }
        Element top = this.top();
        Object bgp = null;
        if (top instanceof ElementBasicGraphPattern) {
            return (ElementBasicGraphPattern)top;
        }
        return this.pushBGP();
    }

    private ElementBasicGraphPattern pushBGP() {
        ElementBasicGraphPattern bgp = new ElementBasicGraphPattern();
        this.elements.add(bgp);
        return bgp;
    }

    private void setTop(Element el) {
        this.elements.set(this.elements.size() - 1, el);
    }

    private Element top() {
        return (Element)this.elements.get(this.elements.size() - 1);
    }

    public int mark() {
        return this.elements.size();
    }

    public List getElements() {
        return this.elements;
    }

    public int hashCode() {
        int calcHashCode = 161;
        return calcHashCode ^= ((Object)this.getElements()).hashCode();
    }

    public boolean equals(Object el2) {
        if (el2 == null) {
            return false;
        }
        if (!(el2 instanceof ElementGroup)) {
            return false;
        }
        ElementGroup eg2 = (ElementGroup)el2;
        if (this.getElements().size() != eg2.getElements().size()) {
            return false;
        }
        for (int i = 0; i < this.getElements().size(); ++i) {
            Element e2;
            Element e1 = (Element)this.getElements().get(i);
            if (e1.equals(e2 = (Element)eg2.getElements().get(i))) continue;
            return false;
        }
        return true;
    }

    public void visit(ElementVisitor v) {
        v.visit(this);
    }
}

