/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.core;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.core.ARQConstants;
import com.hp.hpl.jena.query.core.ARQInternalErrorException;
import com.hp.hpl.jena.query.expr.NodeVar;

public class Var {
    Node node;

    public Var(Node v) {
        if (!v.isVariable()) {
            throw new NotAVariableException(v.toString());
        }
        this.node = v;
    }

    public Var(NodeVar v) {
        this(v.getAsNode());
    }

    public Var(String varName) {
        this.node = Node.createVariable((String)varName);
    }

    public Node asNode() {
        return this.node;
    }

    public String getName() {
        return this.node.getName();
    }

    public int hashCode() {
        return this.node.hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof Var)) {
            return false;
        }
        return this.asNode().equals((Object)((Var)other).asNode());
    }

    public String toString() {
        return this.node.toString();
    }

    public boolean isNamedVar() {
        return Var.isNamedVar(this.node.getName());
    }

    public boolean isSystemVar() {
        return Var.isSystemVarName(this.node.getName());
    }

    public boolean isBlankNodeVar() {
        return Var.isBlankNodeVarName(this.node.getName());
    }

    public static String canonical(String x) {
        if (x.startsWith("?")) {
            return x.substring(1);
        }
        if (x.startsWith("$")) {
            return x.substring(1);
        }
        return x;
    }

    public static boolean isNamedVar(String x) {
        return !Var.isSystemVarName(x) && !Var.isBlankNodeVarName(x);
    }

    public static boolean isBlankNodeVar(Node node) {
        return node.isVariable() && Var.isBlankNodeVarName(node.getName());
    }

    public static boolean isSystemVar(Node node) {
        return node.isVariable() && Var.isSystemVarName(node.getName());
    }

    public static boolean isSystemVarName(String x) {
        return x.startsWith("#");
    }

    public static boolean isBlankNodeVarName(String x) {
        return x.startsWith(ARQConstants.anonVarMarker);
    }

    static class NotAVariableException
    extends ARQInternalErrorException {
        NotAVariableException(String msg) {
            super(msg);
        }
    }
}

