/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.core;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.core.Element;
import com.hp.hpl.jena.query.core.ElementBasicGraphPattern;
import com.hp.hpl.jena.query.core.ElementExtension;
import com.hp.hpl.jena.query.core.ElementFilter;
import com.hp.hpl.jena.query.core.ElementNamedGraph;
import com.hp.hpl.jena.query.core.ElementTriplePattern;
import com.hp.hpl.jena.query.core.ElementVisitor;
import com.hp.hpl.jena.query.core.ElementVisitorBase;
import com.hp.hpl.jena.query.expr.Expr;
import java.util.Iterator;
import java.util.Set;

public class VarNamesMentionedVisitor
extends ElementVisitorBase
implements ElementVisitor {
    Set acc;

    public VarNamesMentionedVisitor(Set s) {
        this.acc = s;
    }

    public void visit(ElementTriplePattern el) {
        Triple t = el.getTriple();
        VarNamesMentionedVisitor.addVarsFromTriple(this.acc, t);
    }

    public void visit(ElementBasicGraphPattern el) {
        Iterator iter = el.getElements().iterator();
        while (iter.hasNext()) {
            Element el2 = (Element)iter.next();
            el2.visit(this);
        }
    }

    public void visit(ElementFilter el) {
        el.getExpr().varNamesMentioned(this.acc);
    }

    public void visit(ElementNamedGraph el) {
        VarNamesMentionedVisitor.addVar(this.acc, el.getGraphNameNode());
    }

    public void visit(ElementExtension el) {
        Iterator iter = el.getArgs().iterator();
        while (iter.hasNext()) {
            Expr e2 = (Expr)iter.next();
            e2.varNamesMentioned(this.acc);
        }
    }

    private static void addVarsFromTriple(Set acc, Triple t) {
        VarNamesMentionedVisitor.addVar(acc, t.getSubject());
        VarNamesMentionedVisitor.addVar(acc, t.getPredicate());
        VarNamesMentionedVisitor.addVar(acc, t.getObject());
    }

    private static void addVar(Set acc, Node n) {
        if (n == null) {
            return;
        }
        if (n.isVariable()) {
            acc.add(n.getName());
        }
    }
}

