/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine1;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.core.DatasetGraph;
import com.hp.hpl.jena.query.engine.QueryIterator;
import com.hp.hpl.jena.query.util.Context;
import com.hp.hpl.jena.query.util.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.logging.LogFactory;

public class ExecutionContext {
    private Context context = null;
    private DatasetGraph dataset = null;
    private Graph activeGraph = null;
    private Query query = null;
    Collection openIterators = null;
    Collection allIterators = null;

    public ExecutionContext(Context context) {
        this.context = context;
    }

    public ExecutionContext(ExecutionContext other, Graph activeGraph) {
        this.context = other.context;
        this.dataset = other.dataset;
        this.activeGraph = activeGraph;
        this.query = other.query;
        this.openIterators = other.openIterators;
        this.allIterators = other.allIterators;
    }

    public ExecutionContext(Context params, Query query, Graph activeGraph, DatasetGraph dataset) {
        this.context = params;
        this.dataset = dataset;
        this.activeGraph = activeGraph;
        this.query = query;
        this.openIterators = new ArrayList();
        this.allIterators = new ArrayList();
    }

    public Context getContext() {
        return this.context;
    }

    public DatasetGraph getDataset() {
        return this.dataset;
    }

    public Graph getActiveGraph() {
        return this.activeGraph;
    }

    public Query getQuery() {
        return this.query;
    }

    public void openIterator(QueryIterator qIter) {
        this.openIterators.add(qIter);
        this.allIterators.add(qIter);
    }

    public void closedIterator(QueryIterator qIter) {
        this.openIterators.remove(qIter);
    }

    public Iterator listOpenIterators() {
        return this.openIterators.iterator();
    }

    public Iterator listAllIterators() {
        return this.allIterators.iterator();
    }

    public void dump() {
        this.dump(false);
    }

    public void dump(boolean includeAll) {
        if (includeAll) {
            Iterator iterAll = this.listAllIterators();
            while (iterAll.hasNext()) {
                QueryIterator qIter = (QueryIterator)iterAll.next();
                this.warn(qIter, "Iterator: ");
            }
        }
        Iterator iterOpen = this.listOpenIterators();
        while (iterOpen.hasNext()) {
            QueryIterator qIterOpen = (QueryIterator)iterOpen.next();
            this.warn(qIterOpen, "Open iterator: ");
        }
    }

    private void warn(QueryIterator qIter, String str) {
        LogFactory.getLog((Class)ExecutionContext.class).warn((Object)(str + Utils.className(qIter)));
    }

    public void switchDataset(DatasetGraph altDataset) {
        this.switchDataset(altDataset, null);
    }

    public void switchDataset(DatasetGraph altDataset, Graph altActiveGraph) {
        this.dataset = altDataset;
        this.activeGraph = altActiveGraph;
        if (this.activeGraph == null) {
            this.activeGraph = this.dataset.getDefaultGraph();
        }
    }
}

