/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine1;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecException;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.core.ARQInternalErrorException;
import com.hp.hpl.jena.query.core.Binding;
import com.hp.hpl.jena.query.core.BindingBase;
import com.hp.hpl.jena.query.core.BindingRoot;
import com.hp.hpl.jena.query.core.DataSourceGraphImpl;
import com.hp.hpl.jena.query.core.DatasetGraph;
import com.hp.hpl.jena.query.core.Element;
import com.hp.hpl.jena.query.core.ResultBinding;
import com.hp.hpl.jena.query.core.Template;
import com.hp.hpl.jena.query.describe.DescribeHandler;
import com.hp.hpl.jena.query.describe.DescribeHandlerRegistry;
import com.hp.hpl.jena.query.engine.QueryIterator;
import com.hp.hpl.jena.query.engine.ResultSetStream;
import com.hp.hpl.jena.query.engine1.EngineConfig;
import com.hp.hpl.jena.query.engine1.ExecutionContext;
import com.hp.hpl.jena.query.engine1.PlanElement;
import com.hp.hpl.jena.query.engine1.QueryEngineUtils;
import com.hp.hpl.jena.query.engine1.compiler.QueryPatternCompiler;
import com.hp.hpl.jena.query.engine1.iterator.QueryIter;
import com.hp.hpl.jena.query.engine1.iterator.QueryIterNullIterator;
import com.hp.hpl.jena.query.engine1.iterator.QueryIterSingleton;
import com.hp.hpl.jena.query.engine1.plan.PlanDistinct;
import com.hp.hpl.jena.query.engine1.plan.PlanLimitOffset;
import com.hp.hpl.jena.query.engine1.plan.PlanOrderBy;
import com.hp.hpl.jena.query.engine1.plan.PlanProject;
import com.hp.hpl.jena.query.util.Context;
import com.hp.hpl.jena.query.util.DatasetUtils;
import com.hp.hpl.jena.query.util.GraphUtils;
import com.hp.hpl.jena.query.util.NodeUtils;
import com.hp.hpl.jena.query.util.RelURI;
import com.hp.hpl.jena.query.util.Utils;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.util.FileManager;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueryEngine
implements QueryExecution {
    private static Log log = LogFactory.getLog((Class)QueryEngine.class);
    protected Query query;
    static int queryCount = 0;
    protected boolean queryExecutionInitialised = false;
    protected int idQueryExecution;
    protected QueryIterator resultsIter;
    protected Context context;
    protected ExecutionContext execContext = null;
    protected PlanElement plan = null;
    protected PlanElement planPattern = null;
    protected QuerySolution startBinding = null;
    protected FileManager fileManager = null;
    protected Dataset dataset = null;
    protected DatasetGraph datasetGraph = null;

    public QueryEngine(Query q) {
        this(q, null);
    }

    public QueryEngine(Query q, Context context) {
        if (context == null) {
            context = new Context(EngineConfig.getContext());
        }
        this.query = q;
        this.idQueryExecution = ++queryCount;
        this.context = context;
    }

    public Query getQuery() {
        return this.query;
    }

    protected void init() {
        if (this.queryExecutionInitialised) {
            return;
        }
        this.startInitializing();
        this.query.setResultVars();
        DatasetGraph dsg = null;
        if (this.getDataset() == null) {
            dsg = this.buildDatasetForQuery();
        } else {
            if (this.getDataset().getDefaultModel() == null) {
                log.warn((Object)"Default model is null in the dataset");
            }
            dsg = new DataSourceGraphImpl(this.getDataset());
        }
        this.datasetGraph = dsg;
        this.execContext = new ExecutionContext(this.context, this.getQuery(), dsg.getDefaultGraph(), dsg);
        this.queryExecutionInitialised = true;
        this.finishInitializing();
    }

    protected void startInitializing() {
    }

    protected void finishInitializing() {
    }

    protected DatasetGraph buildDatasetForQuery() {
        if (!(this.query.getGraphURIs() != null && this.query.getGraphURIs().size() != 0 || this.query.getNamedGraphURIs() != null && this.query.getNamedGraphURIs().size() != 0)) {
            throw new QueryExecException("No model for query");
        }
        String baseURI = this.query.getBaseURI();
        if (baseURI == null) {
            baseURI = RelURI.chooseBaseURI();
        }
        log.debug((Object)("init: baseURI for query is: " + baseURI));
        DatasetGraph dsg = DatasetUtils.createDatasetGraph(this.query.getGraphURIs(), this.query.getNamedGraphURIs(), this.fileManager, baseURI);
        return dsg;
    }

    public void setInitialBinding(QuerySolution rb) {
        this.startBinding = rb;
    }

    public void setFileManager(FileManager fm) {
        this.fileManager = fm;
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    public void setDataset(Dataset dataset) {
        this.dataset = dataset;
    }

    public PlanElement getPlan() {
        if (this.plan == null) {
            this.plan = this.buildPlan();
        }
        return this.plan;
    }

    public PlanElement getPlanPattern() {
        if (this.plan == null) {
            this.getPlan();
        }
        return this.planPattern;
    }

    public Context getContext() {
        return this.context;
    }

    public Model execConstruct() {
        return this.execConstruct(GraphUtils.makeJenaDefaultModel());
    }

    public Model execConstruct(Model model) {
        if (!this.query.isConstructType()) {
            throw new QueryExecException("Attempt to get a CONSTRUCT model from a " + QueryEngine.labelForQuery(this.query) + " query");
        }
        this.query.setQueryResultStar(true);
        this.init();
        this.buildPlan(true);
        this.insertPrefixesInto(model);
        ResultSet qRes = this.execInternal();
        HashSet set = new HashSet();
        Template template = this.query.getConstructTemplate();
        while (qRes.hasNext()) {
            HashMap bNodeMap = new HashMap();
            QuerySolution qs = qRes.nextSolution();
            ResultBinding rb = (ResultBinding)qs;
            template.subst(set, bNodeMap, rb.getBinding());
        }
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            Triple t = (Triple)iter.next();
            Statement stmt = QueryEngineUtils.tripleToStatement(model, t);
            if (stmt == null) continue;
            model.add(stmt);
        }
        this.close();
        return model;
    }

    public Model execDescribe() {
        return this.execDescribe(GraphUtils.makeJenaDefaultModel());
    }

    public Model execDescribe(Model model) {
        DescribeHandler dh;
        if (!this.query.isDescribeType()) {
            throw new QueryExecException("Attempt to get a DESCRIBE result from a " + QueryEngine.labelForQuery(this.query) + " query");
        }
        this.query.setQueryResultStar(true);
        this.init();
        this.buildPlan();
        this.insertPrefixesInto(model);
        HashSet<RDFNode> set = new HashSet<RDFNode>();
        if (this.plan != null) {
            ResultSet qRes = this.execInternal();
            while (qRes.hasNext()) {
                QuerySolution rb = qRes.nextSolution();
                Iterator iter = this.query.getResultVars().iterator();
                while (iter.hasNext()) {
                    String varName = (String)iter.next();
                    RDFNode n = rb.get(varName);
                    set.add(n);
                }
            }
        }
        if (this.query.getResultURIs() != null) {
            Iterator iter = this.query.getResultURIs().iterator();
            while (iter.hasNext()) {
                Node n = (Node)iter.next();
                RDFNode rNode = NodeUtils.convertGraphNodeToRDFNode(n, this.dataset.getDefaultModel());
                set.add(rNode);
            }
        }
        DescribeHandlerRegistry dhReg = DescribeHandlerRegistry.get();
        Iterator handlers = dhReg.handlers();
        while (handlers.hasNext()) {
            dh = (DescribeHandler)handlers.next();
            dh.start(model, this.execContext);
        }
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            RDFNode n = (RDFNode)iter.next();
            if (!(n instanceof Resource)) continue;
            Iterator handlers2 = dhReg.handlers();
            while (handlers2.hasNext()) {
                DescribeHandler dh2 = (DescribeHandler)handlers2.next();
                dh2.describe((Resource)n);
            }
        }
        handlers = dhReg.handlers();
        while (handlers.hasNext()) {
            dh = (DescribeHandler)handlers.next();
            dh.finish();
        }
        this.close();
        return model;
    }

    public ResultSet execSelect() {
        this.init();
        this.buildPlan();
        if (!this.query.isSelectType()) {
            throw new QueryExecException("Attempt to have ResultSet from a " + QueryEngine.labelForQuery(this.query) + " query");
        }
        return this.execInternal();
    }

    public boolean execAsk() {
        if (!this.query.isAskType()) {
            throw new QueryExecException("Attempt to have boolean from a " + QueryEngine.labelForQuery(this.query) + " query");
        }
        this.init();
        this.buildPlan();
        ResultSet results = this.execInternal();
        boolean r = results.hasNext();
        this.close();
        return r;
    }

    private ResultSet execInternal() {
        this.resultsIter = this.planToIterator();
        Object model = null;
        if (this.dataset != null) {
            model = this.dataset.getDefaultModel();
        }
        if (model == null) {
            Graph g = this.datasetGraph.getDefaultGraph();
            model = g != null ? ModelFactory.createModelForGraph((Graph)g) : null;
        }
        ResultSetStream rStream = new ResultSetStream(this.query.getResultVars(), (Model)model, this.resultsIter);
        if (this.query.hasOrderBy()) {
            rStream.setOrdered(true);
        }
        if (this.query.isDistinct()) {
            rStream.setDistinct(true);
        }
        return rStream;
    }

    protected PlanElement makePlanForQueryPattern(Context context, Element queryPatternElement) {
        if (queryPatternElement == null) {
            return null;
        }
        return QueryPatternCompiler.makePlan(context, queryPatternElement);
    }

    protected PlanElement queryPlanPatternHook(Context context, PlanElement planElt) {
        return planElt;
    }

    protected PlanElement queryPlanHook(Context context, PlanElement planElt) {
        return planElt;
    }

    private QueryIterator planToIterator() {
        QueryIterator qIter = null;
        try {
            if (!this.queryExecutionInitialised) {
                throw new ARQInternalErrorException("Query executiuon not initialized");
            }
            Binding rootBinding = QueryEngine.makeRootBinding();
            if (this.startBinding != null) {
                Iterator iter = this.startBinding.varNames();
                while (iter.hasNext()) {
                    String n = (String)iter.next();
                    RDFNode x = this.startBinding.get(n);
                    rootBinding.add(n, x.asNode());
                }
            }
            QueryIterSingleton initialIter = new QueryIterSingleton(rootBinding, this.execContext);
            if (this.datasetGraph == null) {
                throw new ARQInternalErrorException("No DatsetGraph for query");
            }
            PlanElement pElt = this.getPlan();
            if (pElt == null) {
                if (this.startBinding != null) {
                    return initialIter;
                }
                return new QueryIterNullIterator(this.execContext);
            }
            qIter = pElt.build(initialIter, this.execContext);
            return qIter;
        }
        catch (RuntimeException ex) {
            if (qIter != null) {
                qIter.close();
            }
            throw ex;
        }
    }

    private static Binding makeRootBinding() {
        BindingRoot rootBinding = BindingBase.createRootBinding();
        GregorianCalendar cal = new GregorianCalendar();
        String lex = Utils.calendarToXSDDateTimeString(cal);
        Node n = Node.createLiteral((String)lex, null, (RDFDatatype)XSDDatatype.XSDdateTime);
        rootBinding.add("#now", n);
        return rootBinding;
    }

    private PlanElement buildPlan() {
        return this.buildPlan(false);
    }

    private PlanElement buildPlan(boolean surpressProject) {
        if (this.plan != null) {
            return this.plan;
        }
        this.planPattern = this.makePlanForQueryPattern(this.context, this.query.getQueryPattern());
        PlanElement planElt = this.planPattern = this.queryPlanPatternHook(this.context, this.planPattern);
        if (this.query.hasOrderBy()) {
            planElt = PlanOrderBy.make(this.context, planElt, this.query.getOrderBy());
        }
        if (this.query.isQueryResultStar()) {
            surpressProject = true;
        }
        if (!surpressProject) {
            if (this.query.getResultVars().size() == 0 && this.query.isSelectType()) {
                log.warn((Object)"No project variables");
            }
            planElt = PlanProject.make(this.context, planElt, this.query.getResultVars());
        }
        if (this.query.isDistinct() || this.getContext().isTrue(EngineConfig.autoDistinct)) {
            planElt = PlanDistinct.make(this.context, planElt, this.query.getResultVars());
        }
        if (this.query.hasLimit() || this.query.hasOffset()) {
            planElt = PlanLimitOffset.make(this.context, planElt, this.query.getLimit(), this.query.getOffset());
        }
        this.plan = planElt;
        this.plan = this.queryPlanHook(this.context, this.plan);
        return this.plan;
    }

    public void abort() {
        this.close(true);
    }

    public void close() {
        this.close(true);
    }

    private void close(boolean forceClose) {
        if (!this.queryExecutionInitialised) {
            log.warn((Object)"Closing a query that has not been run");
            return;
        }
        if (forceClose) {
            if (this.resultsIter != null) {
                this.resultsIter.close();
            }
            this.resultsIter = null;
        }
        Iterator iter = this.execContext.listOpenIterators();
        while (iter.hasNext()) {
            QueryIterator qIterOpen = (QueryIterator)iter.next();
            if (qIterOpen instanceof QueryIter) {
                QueryIter qIterBase = (QueryIter)qIterOpen;
                log.warn((Object)("Open iterator: " + qIterBase.getCounter() + " " + qIterOpen));
                continue;
            }
            log.warn((Object)("Open iterator: " + qIterOpen));
        }
        if (this.resultsIter != null) {
            this.resultsIter.close();
        }
        this.resultsIter = null;
    }

    private void insertPrefixesInto(Model model) {
        try {
            PrefixMapping m = this.datasetGraph.getDefaultGraph().getPrefixMapping();
            model.setNsPrefixes(m);
            model.setNsPrefixes(this.query.getPrefixMapping());
        }
        catch (Exception ex) {
            log.warn((Object)("Exception in insertPrefixes: " + ex.getMessage()));
        }
    }

    private static String labelForQuery(Query q) {
        if (q.isSelectType()) {
            return "SELECT";
        }
        if (q.isConstructType()) {
            return "CONSTRUCT";
        }
        if (q.isDescribeType()) {
            return "DESCRIBE";
        }
        if (q.isAskType()) {
            return "ASK";
        }
        return "<<unknown>>";
    }
}

