/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine1.analyse;

import com.hp.hpl.jena.query.engine1.PlanElement;
import com.hp.hpl.jena.query.engine1.PlanFormatter;
import com.hp.hpl.jena.query.engine1.analyse.PlanVarsMentioned;
import com.hp.hpl.jena.query.engine1.analyse.VarUsageVisitor;
import com.hp.hpl.jena.query.engine1.plan.PlanBlockTriples;
import com.hp.hpl.jena.query.engine1.plan.PlanFilter;
import com.hp.hpl.jena.query.engine1.plan.PlanGroup;
import com.hp.hpl.jena.query.engine1.plan.PlanTriplePattern;
import com.hp.hpl.jena.shared.PrefixMapping;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AnalyseFilters {
    static Log log = LogFactory.getLog((Class)AnalyseFilters.class);
    PlanGroup planGroup;
    List basePlanElements = new ArrayList();
    List filterPlanElements = new ArrayList();
    List unknownFilterPlanElements = new ArrayList();
    List otherPlanElements = new ArrayList();
    List ordered = new ArrayList();

    public AnalyseFilters(PlanGroup cElt) {
        this.planGroup = cElt;
        this.buildStructures();
        this.analyse();
    }

    private void buildStructures() {
        Iterator iter = this.planGroup.iterator();
        while (iter.hasNext()) {
            PlanElement e2 = (PlanElement)iter.next();
            if (e2 instanceof PlanTriplePattern) {
                PlanTriplePattern tp = (PlanTriplePattern)e2;
                this.basePlanElements.add(tp);
                continue;
            }
            if (e2 instanceof PlanBlockTriples) {
                PlanBlockTriples bp = (PlanBlockTriples)e2;
                this.basePlanElements.add(bp);
                continue;
            }
            if (e2 instanceof PlanFilter) {
                PlanFilter pc = (PlanFilter)e2;
                this.filterPlanElements.add(pc);
                continue;
            }
            this.otherPlanElements.add(e2);
        }
    }

    private void analyse() {
        HashSet varsFixed = new HashSet();
        this.insertFilters(varsFixed);
        Iterator iter = this.basePlanElements.iterator();
        while (iter.hasNext()) {
            PlanBlockTriples p = (PlanBlockTriples)iter.next();
            VarUsageVisitor v = new VarUsageVisitor();
            p.visit(v);
            varsFixed.addAll(v.getFixedUsageVars());
            this.ordered.add(p);
            this.insertFilters(varsFixed);
        }
        this.unknownFilterPlanElements.addAll(this.filterPlanElements);
    }

    private void insertFilters(Set varsFixed) {
        Iterator iter2 = this.filterPlanElements.iterator();
        while (iter2.hasNext()) {
            PlanFilter pc = (PlanFilter)iter2.next();
            Set z = PlanVarsMentioned.varMentioned(pc);
            if (!varsFixed.containsAll(z)) continue;
            this.ordered.add(pc);
            iter2.remove();
        }
    }

    public void report(PrefixMapping pmap) {
        List x = this.reorder();
        Iterator iter = x.iterator();
        while (iter.hasNext()) {
            PlanElement p = (PlanElement)iter.next();
            PlanFormatter.out((OutputStream)System.out, pmap, p);
        }
    }

    public List reorder() {
        ArrayList x = new ArrayList();
        x.addAll(this.ordered);
        x.addAll(this.otherPlanElements);
        x.addAll(this.unknownFilterPlanElements);
        return x;
    }
}

