/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine1.analyse;

import com.hp.hpl.jena.query.engine1.PlanElement;
import com.hp.hpl.jena.query.engine1.PlanFormatter;
import com.hp.hpl.jena.query.engine1.analyse.PlanEltTypeVisitor;
import com.hp.hpl.jena.query.engine1.analyse.VarUsageVisitor;
import com.hp.hpl.jena.query.engine1.plan.PlanGroup;
import com.hp.hpl.jena.query.engine1.plan.PlanOuterJoin;
import com.hp.hpl.jena.shared.PrefixMapping;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AnalyseOrderSets {
    static Log log = LogFactory.getLog((Class)AnalyseOrderSets.class);
    PlanEltTypeVisitor eltTypes;
    Map elsFixedVars = new HashMap();
    Map elsOptVars = new HashMap();
    Map fixedVars = new HashMap();
    Map varOpts = new HashMap();
    Set equivSets = new HashSet();
    PlanGroup planGroup;

    public AnalyseOrderSets(PlanGroup cElt) {
        this.planGroup = cElt;
        this.buildInitialStructures();
        this.analyse();
    }

    public Set getEquivalenceSets() {
        return this.equivSets;
    }

    private void buildInitialStructures() {
        if (this.planGroup.getSubElements().size() == 1) {
            return;
        }
        this.eltTypes = new PlanEltTypeVisitor();
        Iterator iter = this.planGroup.iterator();
        while (iter.hasNext()) {
            PlanElement e2 = (PlanElement)iter.next();
            e2.visit(this.eltTypes);
        }
        HashSet allFixedVars = new HashSet();
        Iterator iter2 = this.planGroup.iterator();
        while (iter2.hasNext()) {
            String vn;
            PlanElement e3 = (PlanElement)iter2.next();
            VarUsageVisitor v = new VarUsageVisitor();
            e3.visit(v);
            this.elsFixedVars.put(e3, v.getFixedUsageVars());
            this.elsOptVars.put(e3, v.getOptionalUsageVars());
            allFixedVars.addAll(v.getFixedUsageVars());
            Iterator iterFixedVar = v.getFixedUsageVars().iterator();
            while (iterFixedVar.hasNext()) {
                vn = (String)iterFixedVar.next();
                this.insert(this.fixedVars, vn, e3);
            }
            Iterator iterOptVar = v.getOptionalUsageVars().iterator();
            while (iterOptVar.hasNext()) {
                vn = (String)iterOptVar.next();
                this.insert(this.varOpts, vn, e3);
            }
        }
        iter2 = allFixedVars.iterator();
        while (iter2.hasNext()) {
            String vn = (String)iter2.next();
            this.varOpts.remove(vn);
        }
    }

    private void analyse() {
        if (this.planGroup.numSubElements() == 1) {
            return;
        }
        HashSet seenVar = new HashSet();
        Iterator iter = this.varOpts.keySet().iterator();
        while (iter.hasNext()) {
            String var = (String)iter.next();
            if (seenVar.contains(var)) continue;
            HashSet equiv = new HashSet();
            AnalyseOrderSets.combine(equiv, var, seenVar, this.varOpts, this.elsOptVars);
            if (equiv.size() > 0) {
                this.equivSets.add(equiv);
                continue;
            }
            log.warn((Object)("Found a zero sized reachabliltiy set for var ?" + var));
        }
    }

    private static void combine(Set acc, String varName, Set seenVar, Map varOpts, Map elsOptVars) {
        if (seenVar.contains(varName)) {
            return;
        }
        seenVar.add(varName);
        Set els = (Set)varOpts.get(varName);
        if (els == null) {
            return;
        }
        Iterator iter = els.iterator();
        while (iter.hasNext()) {
            PlanElement e2 = (PlanElement)iter.next();
            if (acc.contains(e2)) continue;
            acc.add(e2);
            Iterator iter2 = ((Set)elsOptVars.get(e2)).iterator();
            while (iter2.hasNext()) {
                String vn = (String)iter2.next();
                AnalyseOrderSets.combine(acc, vn, seenVar, varOpts, elsOptVars);
            }
        }
    }

    public List reorder() {
        PlanElement p;
        Set equiv;
        if (this.planGroup.numSubElements() == 1) {
            return this.planGroup.getSubElements();
        }
        ArrayList<PlanElement> elements = new ArrayList<PlanElement>();
        elements.addAll(this.eltTypes.fixedPlanElt);
        elements.addAll(this.eltTypes.groupPlanElt);
        elements.addAll(this.eltTypes.filterPlanElt);
        elements.addAll(this.eltTypes.otherPlanElt);
        Iterator iter = this.equivSets.iterator();
        while (iter.hasNext()) {
            equiv = (Set)iter.next();
            if (equiv.size() == 1 && !elements.contains(p = (PlanElement)equiv.iterator().next())) {
                elements.add(p);
            }
            if (equiv.size() != 0) continue;
            log.warn((Object)"Optional reachability set of size zero");
        }
        iter = this.equivSets.iterator();
        while (iter.hasNext()) {
            equiv = (Set)iter.next();
            if (equiv.size() <= 1) continue;
            p = PlanOuterJoin.make(this.planGroup.getContext(), equiv);
            elements.add(p);
        }
        return elements;
    }

    public void report(PrefixMapping pmap) {
        if (this.planGroup.numSubElements() == 1) {
            return;
        }
        Iterator iter = this.equivSets.iterator();
        while (iter.hasNext()) {
            Set equiv = (Set)iter.next();
            if (equiv.size() == 1) continue;
            System.out.println("Equivalence: ");
            Iterator elIter = equiv.iterator();
            while (elIter.hasNext()) {
                PlanElement e2 = (PlanElement)elIter.next();
                PlanFormatter.out((OutputStream)System.out, pmap, e2);
            }
        }
        System.out.println();
        iter = this.planGroup.iterator();
        while (iter.hasNext()) {
            PlanElement p = (PlanElement)iter.next();
            int count = 0;
            Iterator iter2 = this.equivSets.iterator();
            while (iter2.hasNext()) {
                Set equiv = (Set)iter2.next();
                if (!equiv.contains(p)) continue;
                ++count;
            }
            if (count <= true) continue;
            System.out.println("Count = " + count);
            PlanFormatter.out((OutputStream)System.out, pmap, p);
        }
        System.out.println();
        List x = this.reorder();
        System.out.println();
        System.out.println("Group plan:");
        Iterator iter2 = x.iterator();
        while (iter2.hasNext()) {
            PlanElement p = (PlanElement)iter2.next();
            PlanFormatter.out((OutputStream)System.out, pmap, p);
        }
    }

    private void insert(Map map, Object key, Object value) {
        if (map.get(key) == null) {
            map.put(key, new HashSet());
        }
        ((Set)map.get(key)).add(value);
    }
}

