/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine1.analyse;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.engine1.PlanElement;
import com.hp.hpl.jena.query.engine1.PlanVisitorBase;
import com.hp.hpl.jena.query.engine1.PlanWalker;
import com.hp.hpl.jena.query.engine1.plan.PlanBlockTriples;
import com.hp.hpl.jena.query.engine1.plan.PlanDistinct;
import com.hp.hpl.jena.query.engine1.plan.PlanFilter;
import com.hp.hpl.jena.query.engine1.plan.PlanGroup;
import com.hp.hpl.jena.query.engine1.plan.PlanNamedGraph;
import com.hp.hpl.jena.query.engine1.plan.PlanTriplePattern;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Set;

public class PlanVarsMentioned
extends PlanVisitorBase {
    Set acc;

    public static Set varMentioned(PlanElement planElt) {
        HashSet acc = new HashSet();
        PlanVarsMentioned v = new PlanVarsMentioned(acc);
        PlanWalker.walk(planElt, v);
        return acc;
    }

    public PlanVarsMentioned(Set s) {
        this.acc = s;
    }

    public void visit(PlanBlockTriples planElt) {
        ListIterator iter = planElt.triples();
        while (iter.hasNext()) {
            Triple t = (Triple)iter.next();
            PlanVarsMentioned.addVarsFromTriple(this.acc, t);
        }
    }

    public void visit(PlanTriplePattern planElt) {
        Triple t = planElt.getTriple();
        PlanVarsMentioned.addVarsFromTriple(this.acc, t);
    }

    public void visit(PlanGroup planElt) {
    }

    public void visit(PlanFilter planElt) {
        planElt.getExpr().varNamesMentioned(this.acc);
    }

    public void visit(PlanNamedGraph planElt) {
        PlanVarsMentioned.addVar(this.acc, planElt.getElement().getGraphNameNode());
    }

    public void visit(PlanDistinct planElt) {
    }

    private static void addVarsFromTriple(Set acc, Triple t) {
        PlanVarsMentioned.addVar(acc, t.getSubject());
        PlanVarsMentioned.addVar(acc, t.getPredicate());
        PlanVarsMentioned.addVar(acc, t.getObject());
    }

    private static void addVar(Set acc, Node n) {
        if (n == null) {
            return;
        }
        if (n.isVariable()) {
            acc.add(n.getName());
        }
    }
}

