/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine1.analyse;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.core.ARQInternalErrorException;
import com.hp.hpl.jena.query.engine1.PlanElement;
import com.hp.hpl.jena.query.engine1.PlanVisitor;
import com.hp.hpl.jena.query.engine1.plan.PlanBasicGraphPattern;
import com.hp.hpl.jena.query.engine1.plan.PlanBlockTriples;
import com.hp.hpl.jena.query.engine1.plan.PlanDataset;
import com.hp.hpl.jena.query.engine1.plan.PlanDistinct;
import com.hp.hpl.jena.query.engine1.plan.PlanElementExternal;
import com.hp.hpl.jena.query.engine1.plan.PlanExtension;
import com.hp.hpl.jena.query.engine1.plan.PlanFilter;
import com.hp.hpl.jena.query.engine1.plan.PlanGroup;
import com.hp.hpl.jena.query.engine1.plan.PlanLimitOffset;
import com.hp.hpl.jena.query.engine1.plan.PlanNamedGraph;
import com.hp.hpl.jena.query.engine1.plan.PlanOptional;
import com.hp.hpl.jena.query.engine1.plan.PlanOrderBy;
import com.hp.hpl.jena.query.engine1.plan.PlanOuterJoin;
import com.hp.hpl.jena.query.engine1.plan.PlanProject;
import com.hp.hpl.jena.query.engine1.plan.PlanPropertyFunction;
import com.hp.hpl.jena.query.engine1.plan.PlanTriplePattern;
import com.hp.hpl.jena.query.engine1.plan.PlanUnion;
import com.hp.hpl.jena.query.engine1.plan.PlanUnsaid;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Set;
import org.apache.commons.logging.LogFactory;

class VarUsageVisitor
implements PlanVisitor {
    private Set fixedUsageVars;
    private Set optionalUsageVars;
    private Set constraintUsageVars;

    public VarUsageVisitor() {
        this(new HashSet(), new HashSet(), new HashSet());
    }

    public VarUsageVisitor(Set basicPatternVars, Set optionalPatternVars, Set constraintPatternVars) {
        this.fixedUsageVars = basicPatternVars;
        this.optionalUsageVars = optionalPatternVars;
        this.constraintUsageVars = constraintPatternVars;
    }

    public void visit(PlanBlockTriples planElt) {
        ListIterator iter = planElt.triples();
        while (iter.hasNext()) {
            Triple t = (Triple)iter.next();
            VarUsageVisitor.addVarsFromTriple(this.fixedUsageVars, t);
            this.delVarsFromTriple(this.optionalUsageVars, t);
        }
    }

    public void visit(PlanBasicGraphPattern planElt) {
        Iterator iter = planElt.iterator();
        while (iter.hasNext()) {
            PlanElement e2 = (PlanElement)iter.next();
            e2.visit(this);
        }
    }

    public void visit(PlanTriplePattern planElt) {
        Triple t = planElt.getTriple();
        VarUsageVisitor.addVarsFromTriple(this.fixedUsageVars, t);
        this.delVarsFromTriple(this.optionalUsageVars, t);
    }

    public void visit(PlanGroup planElt) {
        Iterator iter = planElt.iterator();
        while (iter.hasNext()) {
            PlanElement e2 = (PlanElement)iter.next();
            e2.visit(this);
        }
    }

    public void visit(PlanUnion planElt) {
        Iterator iter = planElt.getSubElements().iterator();
        while (iter.hasNext()) {
            PlanElement e2 = (PlanElement)iter.next();
            e2.visit(this);
        }
    }

    public void visit(PlanOptional planElt) {
        planElt.getFixed().visit(this);
        VarUsageVisitor v = new VarUsageVisitor();
        planElt.getOptional().visit(v);
        v.getOptionalUsageVars().addAll(v.getFixedUsageVars());
        v.getOptionalUsageVars().removeAll(this.getFixedUsageVars());
        this.optionalUsageVars.addAll(v.getOptionalUsageVars());
    }

    public void visit(PlanUnsaid planElt) {
        VarUsageVisitor v = new VarUsageVisitor(this.constraintUsageVars, this.constraintUsageVars, this.constraintUsageVars);
        planElt.getSubElement().visit(v);
    }

    public void visit(PlanFilter planElt) {
        planElt.getExpr().varNamesMentioned(this.constraintUsageVars);
    }

    public void visit(PlanNamedGraph planElt) {
        Node n = planElt.getElement().getGraphNameNode();
        VarUsageVisitor.addVar(this.fixedUsageVars, n);
        planElt.getSubElement().visit(this);
    }

    public void visit(PlanOuterJoin planElt) {
        LogFactory.getLog((Class)VarUsageVisitor.class).warn((Object)"PlanOuterJoin - VarUsage - Should not be called");
        Iterator iter = planElt.getPlanElements().iterator();
        while (iter.hasNext()) {
            PlanElement e2 = (PlanElement)iter.next();
            e2.visit(this);
        }
    }

    public void visit(PlanPropertyFunction planElt) {
    }

    public void visit(PlanExtension planElt) {
    }

    public void visit(PlanDataset planElt) {
    }

    public void visit(PlanElementExternal planElt) {
        throw new ARQInternalErrorException("PlanExternal encountered");
    }

    public void visit(PlanDistinct planElt) {
    }

    public void visit(PlanProject planElt) {
    }

    public void visit(PlanOrderBy planElt) {
    }

    public void visit(PlanLimitOffset planElt) {
    }

    private static void addVarsFromTriple(Set acc, Triple t) {
        VarUsageVisitor.addVar(acc, t.getSubject());
        VarUsageVisitor.addVar(acc, t.getPredicate());
        VarUsageVisitor.addVar(acc, t.getObject());
    }

    private static void addVar(Set acc, Node n) {
        if (n == null) {
            return;
        }
        if (n.isVariable()) {
            acc.add(n.getName());
        }
    }

    private void delVarsFromTriple(Set acc, Triple t) {
        this.delVar(acc, t.getSubject());
        this.delVar(acc, t.getPredicate());
        this.delVar(acc, t.getObject());
    }

    private void delVar(Set acc, Node n) {
        if (n == null) {
            return;
        }
        if (n.isVariable()) {
            acc.remove(n.getName());
        }
    }

    public Set getFixedUsageVars() {
        return this.fixedUsageVars;
    }

    public Set getConstraintUsageVars() {
        return this.constraintUsageVars;
    }

    public Set getOptionalUsageVars() {
        return this.optionalUsageVars;
    }
}

