/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine1.compiler;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.core.ARQInternalErrorException;
import com.hp.hpl.jena.query.core.Var;
import com.hp.hpl.jena.query.engine1.EngineConfig;
import com.hp.hpl.jena.query.engine1.PlanElement;
import com.hp.hpl.jena.query.engine1.plan.PlanPropertyFunction;
import com.hp.hpl.jena.query.pfunction.PropFuncAdapter;
import com.hp.hpl.jena.query.pfunction.PropFuncArg;
import com.hp.hpl.jena.query.pfunction.PropertyFunctionRegistry;
import com.hp.hpl.jena.query.util.Context;
import com.hp.hpl.jena.query.util.GraphListUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PFuncOps {
    public static boolean isMagicProperty(PropertyFunctionRegistry registry, Triple pfTriple) {
        if (!pfTriple.getPredicate().isURI()) {
            return false;
        }
        if (registry.manages(pfTriple.getPredicate().getURI())) {
            return true;
        }
        return PropFuncAdapter.isMagicProperty(pfTriple);
    }

    public static PlanElement magicProperty(Context context, PropertyFunctionRegistry registry, Triple pfTriple, List triples) {
        if (!PFuncOps.isMagicProperty(registry, pfTriple)) {
            throw new ARQInternalErrorException("Not a property function: " + pfTriple.getMatchPredicate());
        }
        List sList = null;
        List oList = null;
        ArrayList listTriples = new ArrayList();
        if (Var.isBlankNodeVar(pfTriple.getSubject())) {
            sList = GraphListUtils.findList(triples, pfTriple.getSubject(), listTriples);
        }
        if (Var.isBlankNodeVar(pfTriple.getObject())) {
            oList = GraphListUtils.findList(triples, pfTriple.getObject(), listTriples);
        }
        if (sList != null || oList != null) {
            Iterator iter = listTriples.iterator();
            while (iter.hasNext()) {
                Triple t = (Triple)iter.next();
                if (triples.contains(t)) continue;
                System.err.println("WARN: List triple not found");
            }
            triples.removeAll(listTriples);
        }
        PropFuncArg subjArgs = new PropFuncArg(sList, pfTriple.getSubject());
        PropFuncArg objArgs = new PropFuncArg(oList, pfTriple.getObject());
        PlanElement propFuncPlan = PlanPropertyFunction.make(context, subjArgs, pfTriple.getPredicate(), objArgs);
        return propFuncPlan;
    }

    public static PropertyFunctionRegistry chooseRegistry(Context context) {
        PropertyFunctionRegistry registry = (PropertyFunctionRegistry)context.get(EngineConfig.registryPropertyFunctions);
        if (registry == null) {
            registry = PropertyFunctionRegistry.get();
        }
        return registry;
    }
}

