/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine1.compiler;

import com.hp.hpl.jena.query.core.ARQInternalErrorException;
import com.hp.hpl.jena.query.core.Element;
import com.hp.hpl.jena.query.core.ElementBasicGraphPattern;
import com.hp.hpl.jena.query.core.ElementDataset;
import com.hp.hpl.jena.query.core.ElementExtension;
import com.hp.hpl.jena.query.core.ElementFilter;
import com.hp.hpl.jena.query.core.ElementGroup;
import com.hp.hpl.jena.query.core.ElementNamedGraph;
import com.hp.hpl.jena.query.core.ElementOptional;
import com.hp.hpl.jena.query.core.ElementTriplePattern;
import com.hp.hpl.jena.query.core.ElementUnion;
import com.hp.hpl.jena.query.core.ElementUnsaid;
import com.hp.hpl.jena.query.core.ElementVisitor;
import com.hp.hpl.jena.query.core.ElementWalker;
import com.hp.hpl.jena.query.engine1.PlanElement;
import com.hp.hpl.jena.query.engine1.plan.PlanBasicGraphPattern;
import com.hp.hpl.jena.query.engine1.plan.PlanDataset;
import com.hp.hpl.jena.query.engine1.plan.PlanExtension;
import com.hp.hpl.jena.query.engine1.plan.PlanFilter;
import com.hp.hpl.jena.query.engine1.plan.PlanGroup;
import com.hp.hpl.jena.query.engine1.plan.PlanNamedGraph;
import com.hp.hpl.jena.query.engine1.plan.PlanOptional;
import com.hp.hpl.jena.query.engine1.plan.PlanTriplePattern;
import com.hp.hpl.jena.query.engine1.plan.PlanUnion;
import com.hp.hpl.jena.query.engine1.plan.PlanUnsaid;
import com.hp.hpl.jena.query.util.Context;
import java.util.ArrayList;
import java.util.Stack;

public class QueryCompilerVisitor
implements ElementVisitor {
    protected Context context;
    private Stack retStack = new Stack();

    public QueryCompilerVisitor(Context context) {
        this.context = context;
    }

    public PlanElement compile(Element el) {
        ElementWalker.walk(el, this);
        if (this.retStack.size() != 1) {
            throw new ARQInternalErrorException("Plan compilation stack is not the expected size");
        }
        PlanElement cElt = (PlanElement)this.retStack.pop();
        return cElt;
    }

    public void visit(ElementTriplePattern el) {
        PlanElement cElt = PlanTriplePattern.make(this.context, el);
        this.push(cElt);
    }

    public void visit(ElementBasicGraphPattern el) {
        PlanElement cElt = PlanBasicGraphPattern.make(this.context, el);
        this.push(cElt);
    }

    public void visit(ElementFilter el) {
        PlanElement cElt = PlanFilter.make(this.context, el);
        this.push(cElt);
    }

    public void visit(ElementUnion el) {
        ArrayList<PlanElement> acc = new ArrayList<PlanElement>();
        int x = el.getElements().size();
        int z1 = this.retStack.size();
        for (int i = 0; i < x; ++i) {
            PlanElement ex2 = this.pop();
            acc.add(0, ex2);
        }
        int z2 = this.retStack.size();
        PlanElement ex = PlanUnion.make(this.context, acc);
        this.push(ex);
    }

    public void visit(ElementGroup el) {
        ArrayList<PlanElement> acc = new ArrayList<PlanElement>();
        int x = el.getElements().size();
        for (int i = 0; i < x; ++i) {
            PlanElement ex2 = this.pop();
            acc.add(0, ex2);
        }
        PlanElement ex = PlanGroup.make(this.context, acc);
        this.push(ex);
    }

    public void visit(ElementDataset el) {
        PlanElement cSubElt = null;
        if (el.getPatternElement() != null) {
            cSubElt = this.pop();
        }
        PlanElement cElt = PlanDataset.make(this.context, el, cSubElt);
        this.push(cElt);
    }

    public void visit(ElementOptional el) {
        PlanElement pOpt = this.pop();
        PlanElement pFixed = this.pop();
        PlanElement cElt = PlanOptional.make(this.context, el, pFixed, pOpt);
        this.push(cElt);
    }

    public void visit(ElementNamedGraph el) {
        PlanElement cSubElt = this.pop();
        PlanElement cElt = PlanNamedGraph.make(this.context, el, cSubElt);
        this.push(cElt);
    }

    public void visit(ElementUnsaid el) {
        PlanElement cSubElt = this.pop();
        PlanElement cElt = PlanUnsaid.make(this.context, el, cSubElt);
        this.push(cElt);
    }

    public void visit(ElementExtension el) {
        PlanElement cElt = PlanExtension.make(this.context, el);
        this.push(cElt);
    }

    private void push(PlanElement cElt) {
        this.retStack.push(cElt);
    }

    private PlanElement pop() {
        return (PlanElement)this.retStack.pop();
    }
}

