/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine1.plan;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.core.ElementBasicGraphPattern;
import com.hp.hpl.jena.query.core.ElementFilter;
import com.hp.hpl.jena.query.core.ElementTriplePattern;
import com.hp.hpl.jena.query.engine.QueryIterator;
import com.hp.hpl.jena.query.engine1.EngineConfig;
import com.hp.hpl.jena.query.engine1.ExecutionContext;
import com.hp.hpl.jena.query.engine1.PlanElement;
import com.hp.hpl.jena.query.engine1.PlanVisitor;
import com.hp.hpl.jena.query.engine1.compiler.PFuncOps;
import com.hp.hpl.jena.query.engine1.compiler.QueryPatternCompiler;
import com.hp.hpl.jena.query.engine1.plan.PlanBlockTriples;
import com.hp.hpl.jena.query.engine1.plan.PlanElementN;
import com.hp.hpl.jena.query.engine1.plan.PlanUtils;
import com.hp.hpl.jena.query.engine1.plan.Transform;
import com.hp.hpl.jena.query.pfunction.PropertyFunctionRegistry;
import com.hp.hpl.jena.query.util.Context;
import com.hp.hpl.jena.query.util.RefBoolean;
import com.hp.hpl.jena.query.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PlanBasicGraphPattern
extends PlanElementN {
    private static Log log = LogFactory.getLog((Class)PlanBasicGraphPattern.class);
    public static RefBoolean enableMagicProperties = new RefBoolean(EngineConfig.getContext(), ARQ.enablePropertyFunctions);

    public static PlanElement make(Context context, ElementBasicGraphPattern bgp) {
        return new PlanBasicGraphPattern(context, bgp);
    }

    public PlanBasicGraphPattern(Context context) {
        this(context, (List)null);
    }

    private PlanBasicGraphPattern(Context context, ElementBasicGraphPattern bgp) {
        this(context, PlanBasicGraphPattern.process(context, bgp));
    }

    private PlanBasicGraphPattern(Context context, List readyMadePlanElements) {
        super(context, readyMadePlanElements);
    }

    private static List process(Context context, ElementBasicGraphPattern bgp) {
        boolean doingMagicProperties = enableMagicProperties.getValue();
        ArrayList<PlanElement> planBGPElements = new ArrayList<PlanElement>();
        ArrayList<Triple> propertyFunctionTriples = new ArrayList<Triple>();
        PropertyFunctionRegistry registry = PFuncOps.chooseRegistry(context);
        ArrayList<Triple> triples = new ArrayList<Triple>();
        Iterator iter = bgp.getElements().iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (obj instanceof ElementTriplePattern) {
                ElementTriplePattern eTriple = (ElementTriplePattern)obj;
                Triple t = eTriple.getTriple();
                triples.add(t);
                if (!doingMagicProperties || !PFuncOps.isMagicProperty(registry, t)) continue;
                propertyFunctionTriples.add(t);
                continue;
            }
            if (obj instanceof ElementFilter) {
                PlanBasicGraphPattern.finishTriples(context, registry, planBGPElements, triples, propertyFunctionTriples);
                if (triples.size() != 0 || propertyFunctionTriples.size() != 0) {
                    log.warn((Object)"finishTriples left some things behind");
                }
                ElementFilter pf = (ElementFilter)obj;
                PlanElement e2 = QueryPatternCompiler.makePlan(context, pf);
                planBGPElements.add(e2);
                continue;
            }
            log.warn((Object)("Don't recognize: [" + Utils.className(obj) + "]"));
        }
        PlanBasicGraphPattern.finishTriples(context, registry, planBGPElements, triples, propertyFunctionTriples);
        if (triples.size() != 0 || propertyFunctionTriples.size() != 0) {
            log.warn((Object)"finishTriples left some things behind");
        }
        return planBGPElements;
    }

    private static void finishTriples(Context context, PropertyFunctionRegistry registry, List planBGPElements, List triples, List pfTriples) {
        if (pfTriples.size() == 0) {
            PlanBlockTriples pBlk = new PlanBlockTriples(context);
            pBlk.getPattern().addAll(triples);
            planBGPElements.add(pBlk);
            triples.clear();
            return;
        }
        HashMap<Triple, PlanElement> pfPlanElts = new HashMap<Triple, PlanElement>();
        Iterator iter = pfTriples.iterator();
        while (iter.hasNext()) {
            Triple pf = (Triple)iter.next();
            PlanElement planElt = PFuncOps.magicProperty(context, registry, pf, triples);
            if (planElt == null) {
                log.warn((Object)"Lost a PlanElement for a property function");
                continue;
            }
            pfPlanElts.put(pf, planElt);
        }
        PlanBlockTriples pBlk = new PlanBlockTriples(context);
        Iterator iter2 = triples.iterator();
        while (iter2.hasNext()) {
            Triple t = (Triple)iter2.next();
            if (!pfTriples.contains(t)) {
                pBlk.addTriple(t);
                continue;
            }
            PlanElement planElt = (PlanElement)pfPlanElts.get(t);
            pfTriples.remove(t);
            if (pBlk.getPattern().size() > 0) {
                planBGPElements.add(pBlk);
                pBlk = new PlanBlockTriples(context);
            }
            planBGPElements.add(planElt);
        }
        triples.clear();
        if (pfTriples.size() > 0) {
            log.warn((Object)("Property function triples remain: " + pfTriples));
        }
        if (pBlk.getPattern().size() > 0) {
            planBGPElements.add(pBlk);
        }
    }

    public QueryIterator build(QueryIterator input, ExecutionContext execCxt) {
        return PlanUtils.buildSerial(this, input, execCxt);
    }

    public void visit(PlanVisitor visitor) {
        visitor.visit(this);
    }

    public PlanElement apply(Transform transform, List newSubElements) {
        return transform.transform(this, newSubElements);
    }

    public PlanElement copy(List newSubElements) {
        return new PlanBasicGraphPattern(this.getContext(), newSubElements);
    }
}

