/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine1.plan;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.engine.QueryIterator;
import com.hp.hpl.jena.query.engine1.ExecutionContext;
import com.hp.hpl.jena.query.engine1.PlanElement;
import com.hp.hpl.jena.query.engine1.PlanFormatter;
import com.hp.hpl.jena.query.engine1.PlanVisitor;
import com.hp.hpl.jena.query.engine1.analyse.AnalyseFilters;
import com.hp.hpl.jena.query.engine1.analyse.AnalyseOrderSets;
import com.hp.hpl.jena.query.engine1.plan.PlanElementN;
import com.hp.hpl.jena.query.engine1.plan.PlanTriplePattern;
import com.hp.hpl.jena.query.engine1.plan.PlanUtils;
import com.hp.hpl.jena.query.engine1.plan.Transform;
import com.hp.hpl.jena.query.util.Context;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PlanGroup
extends PlanElementN {
    private static Log log = LogFactory.getLog((Class)PlanGroup.class);
    public static boolean enableOrderWarnings = true;
    public static boolean removeGroupOfOne = true;
    private boolean canReorder = true;

    public static PlanElement make(Context context, List acc) {
        if (removeGroupOfOne && acc.size() == 1 && !(acc.get(0) instanceof PlanTriplePattern)) {
            return (PlanElement)acc.get(0);
        }
        return new PlanGroup(context, acc, true);
    }

    public static PlanGroup make(Context context, List acc, boolean reorderable) {
        return new PlanGroup(context, acc, reorderable);
    }

    public boolean canReorder() {
        return this.canReorder;
    }

    protected PlanGroup(Context context, List subElts, boolean reorderable) {
        super(context, subElts);
        this.canReorder = reorderable;
        if (this.getContext().isTrue(ARQ.orderPlanning)) {
            this.planGroup();
        }
    }

    private void planGroup() {
        if (!this.canReorder) {
            return;
        }
        AnalyseOrderSets aOpt = new AnalyseOrderSets(this);
        this.setSubElements(aOpt.reorder());
        AnalyseFilters aFlt = new AnalyseFilters(this);
        this.setSubElements(aFlt.reorder());
    }

    public QueryIterator build(QueryIterator input, ExecutionContext execCxt) {
        return PlanUtils.buildSerial(this, input, execCxt);
    }

    public void visit(PlanVisitor visitor) {
        visitor.visit(this);
    }

    public PlanElement apply(Transform transform, List newSubElements) {
        return transform.transform(this, newSubElements);
    }

    public PlanElement copy(List newSubElements) {
        return PlanGroup.make(this.getContext(), newSubElements, false);
    }

    private void warnOrderDependence(AnalyseOrderSets a) {
        Iterator iter = a.getEquivalenceSets().iterator();
        while (iter.hasNext()) {
            Set r = (Set)iter.next();
            if (!enableOrderWarnings || r.size() == 1) continue;
            log.warn((Object)"Potential order dependence");
            Iterator pEltIter = r.iterator();
            while (pEltIter.hasNext()) {
                PlanElement e2 = (PlanElement)pEltIter.next();
                PlanFormatter.out(System.out, e2);
            }
        }
    }
}

