/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine1.plan;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.engine.QueryIterator;
import com.hp.hpl.jena.query.engine1.ExecutionContext;
import com.hp.hpl.jena.query.engine1.PlanElement;
import com.hp.hpl.jena.query.engine1.PlanVisitor;
import com.hp.hpl.jena.query.engine1.iterator.QueryIterLimitOffset;
import com.hp.hpl.jena.query.engine1.plan.PlanSequenceModifier;
import com.hp.hpl.jena.query.engine1.plan.Transform;
import com.hp.hpl.jena.query.util.Context;

public class PlanLimitOffset
extends PlanSequenceModifier {
    long limit;
    long offset;

    public static PlanElement make(Context context, PlanElement cElt, long limit, long offset) {
        return new PlanLimitOffset(context, cElt, limit, offset);
    }

    private PlanLimitOffset(Context context, PlanElement cElt, long limit, long offset) {
        super(context, cElt);
        this.limit = limit;
        this.offset = offset;
    }

    protected QueryIterator execModifer(QueryIterator qIter, ExecutionContext context) {
        long posn;
        long num = this.limit;
        if (num == Query.NOLIMIT) {
            num = Long.MAX_VALUE;
        }
        if ((posn = this.offset) == Query.NOLIMIT) {
            posn = 0L;
        }
        qIter = new QueryIterLimitOffset(qIter, num, posn, context);
        return qIter;
    }

    public void visit(PlanVisitor visitor) {
        visitor.visit(this);
    }

    public PlanElement apply(Transform transform, PlanElement subElt) {
        return transform.transform(this, subElt);
    }

    public PlanElement copy(PlanElement newSubElement) {
        return PlanLimitOffset.make(this.getContext(), newSubElement, this.limit, this.offset);
    }
}

