/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine1.plan;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.engine.QueryIterator;
import com.hp.hpl.jena.query.engine1.CompileException;
import com.hp.hpl.jena.query.engine1.ExecutionContext;
import com.hp.hpl.jena.query.engine1.PlanElement;
import com.hp.hpl.jena.query.engine1.PlanVisitor;
import com.hp.hpl.jena.query.engine1.compiler.PFuncOps;
import com.hp.hpl.jena.query.engine1.plan.PlanElement0;
import com.hp.hpl.jena.query.engine1.plan.Transform;
import com.hp.hpl.jena.query.extension.Extension;
import com.hp.hpl.jena.query.extension.ExtensionFactory;
import com.hp.hpl.jena.query.extension.ExtensionRegistry;
import com.hp.hpl.jena.query.pfunction.PropFuncAdapter;
import com.hp.hpl.jena.query.pfunction.PropFuncArg;
import com.hp.hpl.jena.query.pfunction.PropertyFunction;
import com.hp.hpl.jena.query.pfunction.PropertyFunctionFactory;
import com.hp.hpl.jena.query.pfunction.PropertyFunctionRegistry;
import com.hp.hpl.jena.query.util.Context;
import com.hp.hpl.jena.query.util.Utils;
import org.apache.commons.logging.LogFactory;

public class PlanPropertyFunction
extends PlanElement0 {
    Node predicate;
    PropFuncArg subjArgs;
    PropFuncArg objArgs;

    public static PlanElement make(Context context, PropFuncArg sArgs, Node predicate, PropFuncArg oArgs) {
        return new PlanPropertyFunction(context, sArgs, predicate, oArgs);
    }

    private PlanPropertyFunction(Context context, PropFuncArg sArgs, Node predicate, PropFuncArg oArgs) {
        super(context);
        this.subjArgs = sArgs;
        this.predicate = predicate;
        this.objArgs = oArgs;
    }

    public QueryIterator build(QueryIterator input, ExecutionContext execCxt) {
        String uri = this.predicate.getURI();
        PropertyFunctionRegistry registry = PFuncOps.chooseRegistry(execCxt.getContext());
        PropertyFunctionFactory factory = registry.get(uri);
        PropertyFunction propFunc = null;
        if (factory == null) {
            propFunc = this.adapter(uri, execCxt);
            if (propFunc == null) {
                throw new CompileException("No property function for '" + uri + "'");
            }
        } else {
            propFunc = factory.create(uri);
        }
        propFunc.build(this.getSubjArgs(), this.getPredicate(), this.getObjArgs(), execCxt);
        if (input == null) {
            LogFactory.getLog(this.getClass()).fatal((Object)("Null input to " + Utils.classShortName(this.getClass())));
        }
        QueryIterator qIter = propFunc.exec(input, this.getSubjArgs(), this.getPredicate(), this.getObjArgs(), execCxt);
        return qIter;
    }

    private PropertyFunction adapter(String uri, ExecutionContext execCxt) {
        ExtensionFactory extFact = ExtensionRegistry.get().get(uri);
        if (extFact == null) {
            throw new CompileException("No property function for '" + uri + "'");
        }
        Extension ext = extFact.create(uri);
        PropFuncAdapter propFunc = new PropFuncAdapter(ext);
        return propFunc;
    }

    public void visit(PlanVisitor visitor) {
        visitor.visit(this);
    }

    public PlanElement apply(Transform transform) {
        return transform.transform(this);
    }

    public PlanElement copy() {
        return PlanPropertyFunction.make(this.getContext(), this.subjArgs, this.predicate, this.objArgs);
    }

    public PropFuncArg getSubjArgs() {
        return this.subjArgs;
    }

    public Node getPredicate() {
        return this.predicate;
    }

    public PropFuncArg getObjArgs() {
        return this.objArgs;
    }
}

