/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine1.plan;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.core.ElementTriplePattern;
import com.hp.hpl.jena.query.engine.QueryIterator;
import com.hp.hpl.jena.query.engine1.ExecutionContext;
import com.hp.hpl.jena.query.engine1.PlanElement;
import com.hp.hpl.jena.query.engine1.PlanVisitor;
import com.hp.hpl.jena.query.engine1.iterator.QueryIterNullIterator;
import com.hp.hpl.jena.query.engine1.plan.PlanBasicGraphPattern;
import com.hp.hpl.jena.query.engine1.plan.PlanBlockTriples;
import com.hp.hpl.jena.query.engine1.plan.PlanElement0;
import com.hp.hpl.jena.query.engine1.plan.Transform;
import com.hp.hpl.jena.query.util.Context;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PlanTriplePattern
extends PlanElement0 {
    private static Log log = LogFactory.getLog((Class)ElementTriplePattern.class);
    private static int warnCount = 0;
    ElementTriplePattern elementTriple;

    public static PlanElement make(Context context, ElementTriplePattern el) {
        return new PlanTriplePattern(context, el);
    }

    private PlanTriplePattern(Context context, ElementTriplePattern el) {
        super(context);
        if (warnCount < 10) {
            log.info((Object)("PlanTriplePattern used unexpectedly: " + el));
        }
        ++warnCount;
        this.elementTriple = el;
    }

    public Triple getTriple() {
        return this.elementTriple.getTriple();
    }

    public QueryIterator build(QueryIterator input, ExecutionContext execCxt) {
        LogFactory.getLog((Class)ElementTriplePattern.class).info((Object)"Odd : .build called");
        if (this.elementTriple == null) {
            log.warn((Object)"Triple is null");
            return new QueryIterNullIterator(execCxt);
        }
        return this.toBasicGraphPattern().build(input, execCxt);
    }

    public PlanBasicGraphPattern toBasicGraphPattern() {
        PlanBlockTriples cBase = new PlanBlockTriples(this.getContext());
        cBase.addTriple(this.elementTriple.getTriple());
        PlanBasicGraphPattern bgp = new PlanBasicGraphPattern(this.getContext());
        bgp.getSubElements().add(cBase);
        return bgp;
    }

    private PlanBlockTriples toBlockTriples() {
        PlanBlockTriples cBase = new PlanBlockTriples(this.getContext());
        cBase.addTriple(this.elementTriple.getTriple());
        return cBase;
    }

    public void visit(PlanVisitor visitor) {
        visitor.visit(this);
    }

    public PlanElement apply(Transform transform) {
        return transform.transform(this);
    }

    public PlanElement copy() {
        return PlanTriplePattern.make(this.getContext(), this.elementTriple);
    }
}

