/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine1.plan;

import com.hp.hpl.jena.query.engine.QueryIterator;
import com.hp.hpl.jena.query.engine1.ExecutionContext;
import com.hp.hpl.jena.query.engine1.PlanElement;
import com.hp.hpl.jena.query.engine1.PlanVisitor;
import com.hp.hpl.jena.query.engine1.iterator.QueryIterUnion;
import com.hp.hpl.jena.query.engine1.plan.PlanElementN;
import com.hp.hpl.jena.query.engine1.plan.Transform;
import com.hp.hpl.jena.query.util.Context;
import java.util.List;

public class PlanUnion
extends PlanElementN {
    public static PlanElement make(Context context, List acc) {
        if (acc.size() == 1) {
            return (PlanElement)acc.get(0);
        }
        return new PlanUnion(context, acc);
    }

    private PlanUnion(Context context, List cElts) {
        super(context, cElts);
    }

    public QueryIterator build(QueryIterator input, ExecutionContext execCxt) {
        if (this.numSubElements() == 0) {
            return input;
        }
        if (this.numSubElements() == 1) {
            PlanElement e2 = this.getSubElement(1);
            return e2.build(input, execCxt);
        }
        return new QueryIterUnion(input, this.getSubElements(), execCxt);
    }

    public void visit(PlanVisitor visitor) {
        visitor.visit(this);
    }

    public PlanElement apply(Transform transform, List x) {
        return transform.transform(this, x);
    }

    public PlanElement copy(List newSubElements) {
        return PlanUnion.make(this.getContext(), newSubElements);
    }
}

