/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine1.plan;

import com.hp.hpl.jena.query.engine1.PlanElement;
import com.hp.hpl.jena.query.engine1.PlanStructureVisitor;
import com.hp.hpl.jena.query.engine1.plan.PlanElement0;
import com.hp.hpl.jena.query.engine1.plan.PlanElement1;
import com.hp.hpl.jena.query.engine1.plan.PlanElement2;
import com.hp.hpl.jena.query.engine1.plan.PlanElementExternal;
import com.hp.hpl.jena.query.engine1.plan.PlanElementN;
import com.hp.hpl.jena.query.engine1.plan.Transform;
import java.util.ArrayList;
import java.util.Stack;
import org.apache.commons.logging.LogFactory;

class TransformApplyBase
implements PlanStructureVisitor {
    Stack stack = new Stack();
    private Transform transform;

    private PlanElement pop() {
        return (PlanElement)this.stack.pop();
    }

    private void push(PlanElement newElt) {
        this.stack.push(newElt);
    }

    public PlanElement result() {
        if (this.stack.size() != 1) {
            LogFactory.getLog((Class)TransformApplyBase.class).warn((Object)"Stack is not aligned");
        }
        return this.pop();
    }

    TransformApplyBase(Transform transform) {
        this.transform = transform;
    }

    public void visit(PlanElement0 planElt) {
        this.push(planElt.apply(this.transform));
    }

    public void visit(PlanElement1 planElt) {
        planElt.getSubElement().visit(this);
        PlanElement x = this.pop();
        this.push(planElt.apply(this.transform, x));
    }

    public void visit(PlanElement2 planElt) {
        planElt.getSubElement1().visit(this);
        PlanElement x = this.pop();
        planElt.getSubElement2().visit(this);
        PlanElement y = this.pop();
        this.push(planElt.apply(this.transform, x, y));
    }

    public void visit(PlanElementN planElt) {
        ArrayList<PlanElement> x = new ArrayList<PlanElement>();
        int N = planElt.numSubElements();
        for (int i = 0; i < N; ++i) {
            planElt.getSubElement(i).visit(this);
            x.add(this.pop());
        }
        this.push(planElt.apply(this.transform, x));
    }

    public void visit(PlanElementExternal planElt) {
        LogFactory.getLog((Class)TransformApplyBase.class).warn((Object)"Visiting external plan element");
        this.push(planElt);
    }
}

