/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.expr;

import com.hp.hpl.jena.query.core.Binding;
import com.hp.hpl.jena.query.engine1.EngineConfig;
import com.hp.hpl.jena.query.engine1.ExecutionContext;
import com.hp.hpl.jena.query.expr.Expr;
import com.hp.hpl.jena.query.expr.ExprEvalException;
import com.hp.hpl.jena.query.expr.ExprException;
import com.hp.hpl.jena.query.expr.ExprFunctionN;
import com.hp.hpl.jena.query.expr.NodeValue;
import com.hp.hpl.jena.query.function.Function;
import com.hp.hpl.jena.query.function.FunctionFactory;
import com.hp.hpl.jena.query.function.FunctionRegistry;
import com.hp.hpl.jena.query.serializer.SerializationContext;
import com.hp.hpl.jena.query.util.FmtUtils;
import java.util.List;
import org.apache.commons.logging.LogFactory;

public class E_Function
extends ExprFunctionN {
    private static final String name = "function";
    public static boolean WarnOnUnknownFunction = true;
    private String functionIRI;
    private Function function = null;
    private boolean functionBound = false;

    public E_Function(String functionIRI, List args) {
        super(name, args);
        this.functionIRI = functionIRI;
    }

    public String getFunctionIRI() {
        return this.functionIRI;
    }

    public void buildFunction(ExecutionContext execCxt) {
        block2: {
            try {
                this.bindFunction(execCxt);
            }
            catch (ExprException ex) {
                if (!WarnOnUnknownFunction) break block2;
                LogFactory.getLog((Class)E_Function.class).warn((Object)("URI '" + this.functionIRI + "' has no registered function factory"));
            }
        }
    }

    private FunctionRegistry chooseRegistry(ExecutionContext execCxt) {
        FunctionRegistry registry = null;
        if (execCxt != null) {
            registry = (FunctionRegistry)execCxt.getContext().get(EngineConfig.registryFunctions);
        }
        if (registry == null) {
            registry = FunctionRegistry.get();
        }
        return registry;
    }

    private void bindFunction(ExecutionContext execCxt) {
        if (this.functionBound) {
            return;
        }
        FunctionRegistry registry = this.chooseRegistry(execCxt);
        FunctionFactory ff = registry.get(this.functionIRI);
        if (ff == null) {
            this.functionBound = true;
            throw new ExprEvalException("URI '" + this.functionIRI + "' not found as a function");
        }
        this.function = ff.create(this.functionIRI);
        this.function.build(this.functionIRI, this.args);
        this.functionBound = true;
    }

    public NodeValue eval(Binding binding, ExecutionContext execCxt) {
        if (!this.functionBound) {
            this.bindFunction(execCxt);
        }
        if (this.function == null) {
            throw new ExprEvalException("URI '" + this.getFunctionIRI() + "' not bound");
        }
        NodeValue r = this.function.exec(binding, this.args, this.getFunctionIRI(), execCxt);
        return r;
    }

    public String getFunctionPrintName(SerializationContext cxt) {
        return FmtUtils.stringForURI(this.functionIRI, cxt);
    }

    protected Expr copy(List newArgs) {
        return new E_Function(this.getFunctionIRI(), newArgs);
    }
}

