/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.expr;

import com.hp.hpl.jena.datatypes.DatatypeFormatException;
import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDateTime;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.core.ARQInternalErrorException;
import com.hp.hpl.jena.query.core.Binding;
import com.hp.hpl.jena.query.engine1.ExecutionContext;
import com.hp.hpl.jena.query.expr.Expr;
import com.hp.hpl.jena.query.expr.ExprEvalException;
import com.hp.hpl.jena.query.expr.ExprException;
import com.hp.hpl.jena.query.expr.ExprNode;
import com.hp.hpl.jena.query.expr.ExprNotComparableException;
import com.hp.hpl.jena.query.expr.ExprVisitor;
import com.hp.hpl.jena.query.expr.nodevalue.Functions;
import com.hp.hpl.jena.query.expr.nodevalue.NodeFunctions;
import com.hp.hpl.jena.query.expr.nodevalue.NodeValueBoolean;
import com.hp.hpl.jena.query.expr.nodevalue.NodeValueDate;
import com.hp.hpl.jena.query.expr.nodevalue.NodeValueDateTime;
import com.hp.hpl.jena.query.expr.nodevalue.NodeValueDecimal;
import com.hp.hpl.jena.query.expr.nodevalue.NodeValueDouble;
import com.hp.hpl.jena.query.expr.nodevalue.NodeValueFloat;
import com.hp.hpl.jena.query.expr.nodevalue.NodeValueInteger;
import com.hp.hpl.jena.query.expr.nodevalue.NodeValueNode;
import com.hp.hpl.jena.query.expr.nodevalue.NodeValueString;
import com.hp.hpl.jena.query.expr.nodevalue.NodeValueVisitor;
import com.hp.hpl.jena.query.serializer.SerializationContext;
import com.hp.hpl.jena.query.util.FmtUtils;
import com.hp.hpl.jena.query.util.NodeUtils;
import com.hp.hpl.jena.query.util.RefBoolean;
import com.hp.hpl.jena.query.util.RomanNumeral;
import com.hp.hpl.jena.query.util.RomanNumeralDatatype;
import com.hp.hpl.jena.query.util.Utils;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.impl.JenaParameters;
import com.hp.hpl.jena.vocabulary.XSD;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class NodeValue
extends ExprNode {
    private static Log log = LogFactory.getLog((Class)NodeValue.class);
    public static boolean VerboseWarnings = true;
    public static boolean VerboseExceptions = false;
    private static final boolean sameValueAsString = JenaParameters.enablePlainLiteralSameAsString;
    private static RefBoolean enableRomanNumerals = new RefBoolean(ARQ.enableRomanNumerals, false);
    public static final BigInteger IntegerZERO = new BigInteger("0");
    public static final BigDecimal DecimalZERO = new BigDecimal("0");
    public static final NodeValue TRUE = NodeValue.makeNode("true", XSDDatatype.XSDboolean);
    public static final NodeValue FALSE = NodeValue.makeNode("false", XSDDatatype.XSDboolean);
    private Node node = null;
    private static final int VSPACE_NUM = 10;
    private static final int VSPACE_DATETIME = 20;
    private static final int VSPACE_DATE = 30;
    private static final int VSPACE_STRING = 40;
    private static final int VSPACE_LANG = 50;
    private static final int VSPACE_BOOLEAN = 60;
    private static final int VSPACE_NODE = 70;
    private static final int VSPACE_UNKNOWN = 80;
    private static final int VSPACE_DIFFERENT = 90;

    protected NodeValue() {
    }

    protected NodeValue(Node n) {
        this.node = n;
    }

    public static NodeValue makeInteger(long i) {
        return new NodeValueInteger(i);
    }

    public static NodeValue makeInteger(BigInteger i) {
        return new NodeValueInteger(i);
    }

    public static NodeValue makeInteger(String lexicalForm) {
        return new NodeValueInteger(new BigInteger(lexicalForm));
    }

    public static NodeValue makeFloat(float f) {
        return new NodeValueFloat(f);
    }

    public static NodeValue makeDouble(double d) {
        return new NodeValueDouble(d);
    }

    public static NodeValue makeString(String s) {
        return new NodeValueString(s);
    }

    public static NodeValue makeDecimal(BigDecimal d) {
        return new NodeValueDecimal(d);
    }

    public static NodeValue makeDecimal(long i) {
        return new NodeValueDecimal(BigDecimal.valueOf(i));
    }

    public static NodeValue makeDecimal(double d) {
        return new NodeValueDecimal(new BigDecimal(d));
    }

    public static NodeValue makeDecimal(String lexicalForm) {
        return NodeValue.makeNode(lexicalForm, XSDDatatype.XSDdecimal);
    }

    public static NodeValue makeDateTime(String lexicalForm) {
        return NodeValue.makeNode(lexicalForm, XSDDatatype.XSDdateTime);
    }

    public static NodeValue makeDateTime(Calendar cal) {
        return new NodeValueDateTime(cal);
    }

    public static NodeValue makeDate(String lexicalForm) {
        return NodeValue.makeNode(lexicalForm, XSDDatatype.XSDdate);
    }

    public static NodeValue makeDate(Calendar cal) {
        return new NodeValueDate(cal);
    }

    public static NodeValue makeBoolean(boolean b) {
        return b ? TRUE : FALSE;
    }

    public static NodeValue booleanReturn(boolean b) {
        return b ? TRUE : FALSE;
    }

    public static NodeValue makeNode(Node n) {
        NodeValue nv = NodeValue.nodeToNodeValue(n);
        return nv;
    }

    public static NodeValue makeNode(String lexicalForm, XSDDatatype dtype) {
        Node n = Node.createLiteral((String)lexicalForm, null, (RDFDatatype)dtype);
        NodeValue nv = NodeValue.makeNode(n);
        return nv;
    }

    public static NodeValue makeNode(String lexicalForm, String langTag, Node datatype) {
        String uri = datatype == null ? null : datatype.getURI();
        return NodeValue.makeNode(lexicalForm, langTag, uri);
    }

    public static NodeValue makeNode(String lexicalForm, String langTag, String datatype) {
        if (datatype != null && datatype.equals("")) {
            datatype = null;
        }
        if (langTag != null && datatype != null) {
            log.warn((Object)("Both lang tag and datatype defined (lexcial form '" + lexicalForm + "')"));
        }
        Node n = null;
        if (datatype != null) {
            RDFDatatype dType = TypeMapper.getInstance().getSafeTypeByName(datatype);
            n = Node.createLiteral((String)lexicalForm, null, (RDFDatatype)dType);
        } else {
            n = Node.createLiteral((String)lexicalForm, (String)langTag, null);
        }
        return NodeValue.makeNode(n);
    }

    public static NodeValue makeNodeBoolean(boolean b) {
        return b ? TRUE : FALSE;
    }

    public static NodeValue makeNodeBoolean(String lexicalForm) {
        NodeValue nv = NodeValue.makeNode(lexicalForm, null, XSD.xboolean.getURI());
        return nv;
    }

    public static NodeValue makeNodeInteger(long v) {
        NodeValue nv = NodeValue.makeNode(Long.toString(v), null, XSD.integer.getURI());
        return nv;
    }

    public static NodeValue makeNodeInteger(String lexicalForm) {
        NodeValue nv = NodeValue.makeNode(lexicalForm, null, XSD.integer.getURI());
        return nv;
    }

    public static NodeValue makeNodeFloat(float f) {
        NodeValue nv = NodeValue.makeNode(Utils.stringForm(f), null, XSD.xfloat.getURI());
        return nv;
    }

    public static NodeValue makeNodeFloat(String lexicalForm) {
        NodeValue nv = NodeValue.makeNode(lexicalForm, null, XSD.xdouble.getURI());
        return nv;
    }

    public static NodeValue makeNodeDouble(double v) {
        NodeValue nv = NodeValue.makeNode(Utils.stringForm(v), null, XSD.xdouble.getURI());
        return nv;
    }

    public static NodeValue makeNodeDouble(String lexicalForm) {
        NodeValue nv = NodeValue.makeNode(lexicalForm, null, XSD.xdouble.getURI());
        return nv;
    }

    public static NodeValue makeNodeDecimal(BigDecimal decimal) {
        NodeValue nv = NodeValue.makeNode(Utils.stringForm(decimal), null, XSD.decimal.getURI());
        return nv;
    }

    public static NodeValue makeNodeDecimal(String lexicalForm) {
        NodeValue nv = NodeValue.makeNode(lexicalForm, null, XSD.decimal.getURI());
        return nv;
    }

    public static NodeValue makeNodeString(String string) {
        NodeValue nv = NodeValue.makeNode(string, null, (String)null);
        return nv;
    }

    public static NodeValue makeNodeDateTime(Calendar date2) {
        String lex = Utils.calendarToXSDDateTimeString(date2);
        NodeValue nv = NodeValue.makeNode(lex, XSDDatatype.XSDdateTime);
        return nv;
    }

    public static NodeValue makeNodeDateTime(String lexicalForm) {
        NodeValue nv = NodeValue.makeNode(lexicalForm, XSDDatatype.XSDdateTime);
        return nv;
    }

    public static NodeValue makeNodeDate(Calendar date2) {
        String lex = Utils.calendarToXSDDateString(date2);
        NodeValue nv = NodeValue.makeNode(lex, XSDDatatype.XSDdate);
        return nv;
    }

    public static NodeValue makeNodeDate(String lexicalForm) {
        NodeValue nv = NodeValue.makeNode(lexicalForm, XSDDatatype.XSDdate);
        return nv;
    }

    public NodeValue eval(Binding binding, ExecutionContext execCxt) {
        return this;
    }

    public Expr copySubstitute(Binding binding, boolean foldConstants) {
        Node n = this.asNode();
        return NodeValue.makeNode(n);
    }

    public NodeValue evalNodeValue(Binding binding, ExecutionContext execCxt) {
        System.err.println("eval - convert back to NodeValue");
        return null;
    }

    public Node evalNode(Binding binding, ExecutionContext execCxt) {
        return this.asNode();
    }

    public boolean isConstant() {
        return true;
    }

    public NodeValue getConstant() {
        return this;
    }

    public static boolean sameValueAs(NodeValue nv1, NodeValue nv2) {
        if (nv1 == null || nv2 == null) {
            new ARQInternalErrorException("Attempt to sameValueAs on a null");
        }
        int compType = NodeValue.classifyValueOp(nv1, nv2);
        switch (compType) {
            case 10: {
                return Functions.compareNumeric(nv1, nv2) == 0;
            }
            case 20: {
                return Functions.compareDateTime(nv1, nv2) == 0;
            }
            case 30: {
                return Functions.compareDate(nv1, nv2) == 0;
            }
            case 40: {
                return Functions.compareString(nv1, nv2) == 0;
            }
            case 60: {
                return Functions.compareBoolean(nv1, nv2) == 0;
            }
            case 90: {
                return false;
            }
            case 50: {
                Node node1 = nv1.getNode();
                Node node2 = nv2.getNode();
                return node1.getLiteralLexicalForm().equals(node2.getLiteralLexicalForm()) && node1.getLiteralLanguage().equalsIgnoreCase(node2.getLiteralLanguage());
            }
            case 80: {
                Node node1 = nv1.getNode();
                Node node2 = nv2.getNode();
                if (!node1.isLiteral() || !node2.isLiteral()) {
                    return NodeUtils.sameNode(node1, node2);
                }
                if (NodeUtils.sameNode(node1, node2)) {
                    return true;
                }
                if (!node1.getLiteralLanguage().equals("") || !node2.getLiteralLanguage().equals("")) {
                    return false;
                }
                NodeValue.raise(new ExprEvalException("Unknown equality test: " + nv1 + " and " + nv2));
                throw new ARQInternalErrorException("raise returned (sameValueAs)");
            }
            case 70: {
                return NodeUtils.sameNode(nv1.getNode(), nv2.getNode());
            }
        }
        throw new ARQInternalErrorException("Can't sameValueAs " + nv1 + " and " + nv2);
    }

    public static boolean notSameValueAs(NodeValue nv1, NodeValue nv2) {
        return !NodeValue.sameValueAs(nv1, nv2);
    }

    public static int compareAlways(NodeValue nv1, NodeValue nv2) {
        try {
            return NodeValue.compare(nv1, nv2, true);
        }
        catch (ExprNotComparableException ex) {
            nv1.forceToNode();
            nv2.forceToNode();
            return NodeUtils.compareNodesByKindTypeLexical(nv1.getNode(), nv2.getNode());
        }
    }

    public static int compare(NodeValue nv1, NodeValue nv2) {
        if (nv1 == null || nv2 == null) {
            new ARQInternalErrorException("Attempt to compare on null");
        }
        int x = NodeValue.compare(nv1, nv2, false);
        return x;
    }

    private static int compare(NodeValue nv1, NodeValue nv2, boolean generalCompare) {
        if (nv1 == null && nv2 == null) {
            return 0;
        }
        if (nv1 == null) {
            return -1;
        }
        if (nv2 == null) {
            return 1;
        }
        int compType = NodeValue.classifyValueOp(nv1, nv2);
        switch (compType) {
            case 10: {
                return Functions.compareNumeric(nv1, nv2);
            }
            case 20: {
                return Functions.compareDateTime(nv1, nv2);
            }
            case 30: {
                return Functions.compareDate(nv1, nv2);
            }
            case 40: {
                return Functions.compareString(nv1, nv2);
            }
            case 60: {
                return Functions.compareBoolean(nv1, nv2);
            }
        }
        if (!generalCompare) {
            NodeValue.raise(new ExprNotComparableException("Can't compare " + nv1 + " and " + nv2));
        }
        throw new ExprNotComparableException("Can't compare " + nv1 + " and " + nv2);
    }

    private static int classifyValueOp(NodeValue nv1, NodeValue nv2) {
        int c2;
        int c1 = NodeValue.classifyValueSpace(nv1);
        if (c1 == (c2 = NodeValue.classifyValueSpace(nv2))) {
            return c1;
        }
        if (c1 == 80 || c2 == 80) {
            return 80;
        }
        return 90;
    }

    private static int classifyValueSpace(NodeValue nv) {
        if (nv.isNumber()) {
            return 10;
        }
        if (nv.isDateTime()) {
            return 20;
        }
        if (nv.isDate()) {
            return 30;
        }
        if (nv.isString()) {
            return 40;
        }
        if (nv.isBoolean()) {
            return 60;
        }
        if (!nv.isLiteral()) {
            return 70;
        }
        if (nv.getNode() != null && nv.getNode().isLiteral() && !nv.getNode().getLiteralLanguage().equals("")) {
            return 50;
        }
        return 80;
    }

    public static Node toNode(NodeValue nv) {
        if (nv == null) {
            return null;
        }
        return nv.asNode();
    }

    public final Node asNode() {
        if (this.node == null) {
            this.node = this.makeNode();
        }
        return this.node;
    }

    protected abstract Node makeNode();

    public Node getNode() {
        return this.node;
    }

    public boolean hasNode() {
        return this.node != null;
    }

    public boolean hasKnownValue() {
        return this.isBoolean() || this.isNumber() || this.isString() || this.isDateTime() || this.isDate();
    }

    public boolean isBoolean() {
        return false;
    }

    public boolean isString() {
        return false;
    }

    public boolean isNumber() {
        return false;
    }

    public boolean isInteger() {
        return false;
    }

    public boolean isDecimal() {
        return false;
    }

    public boolean isFloat() {
        return false;
    }

    public boolean isDouble() {
        return false;
    }

    public boolean isDateTime() {
        return false;
    }

    public boolean isDate() {
        return false;
    }

    public boolean isLiteral() {
        return this.getNode() == null || this.getNode().isLiteral();
    }

    public boolean getBoolean() {
        NodeValue.raise(new ExprEvalException("Not a boolean: " + this));
        return false;
    }

    public String getString() {
        NodeValue.raise(new ExprEvalException("Not a string: " + this));
        return null;
    }

    public BigInteger getInteger() {
        NodeValue.raise(new ExprEvalException("Not an int: " + this));
        return null;
    }

    public BigDecimal getDecimal() {
        NodeValue.raise(new ExprEvalException("Not a decimal: " + this));
        return null;
    }

    public float getFloat() {
        NodeValue.raise(new ExprEvalException("Not a float: " + this));
        return Float.NaN;
    }

    public double getDouble() {
        NodeValue.raise(new ExprEvalException("Not a double: " + this));
        return Double.NaN;
    }

    public Calendar getDateTime() {
        NodeValue.raise(new ExprEvalException("Not a dateTime: " + this));
        return null;
    }

    public Calendar getDate() {
        NodeValue.raise(new ExprEvalException("Not a date: " + this));
        return null;
    }

    private static NodeValue nodeToNodeValue(Node node) {
        boolean isPlainLiteral;
        if (!node.isLiteral()) {
            return new NodeValueNode(node);
        }
        boolean hasLangTag = node.getLiteralLanguage() != null && !node.getLiteralLanguage().equals("");
        boolean bl = isPlainLiteral = node.getLiteralDatatypeURI() == null && !hasLangTag;
        if (isPlainLiteral) {
            return new NodeValueString(node.getLiteralLexicalForm(), node);
        }
        if (hasLangTag) {
            if (node.getLiteralDatatypeURI() != null) {
                if (VerboseWarnings) {
                    log.warn((Object)"Lang tag and datatype (datatype ignored)");
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)"Lang tag and datatype (datatype ignored)");
                }
            }
            return new NodeValueNode(node);
        }
        LiteralLabel lit = node.getLiteral();
        if (!lit.getDatatype().isValidLiteral(lit)) {
            if (VerboseWarnings) {
                String tmp = FmtUtils.stringForNode(node, PrefixMapping.Standard);
                log.warn((Object)("Datatype format exception: " + tmp));
            } else if (log.isDebugEnabled()) {
                String tmp = FmtUtils.stringForNode(node, PrefixMapping.Standard);
                log.debug((Object)("Datatype format exception: " + tmp));
            }
            return new NodeValueNode(node);
        }
        NodeValue nv = NodeValue._setByValue(node);
        if (nv != null) {
            return nv;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Unrecognized literal: " + node));
        }
        return new NodeValueNode(node);
    }

    private static NodeValue _setByValue(Node node) {
        LiteralLabel lit = node.getLiteral();
        try {
            if (sameValueAsString && XSDDatatype.XSDstring.isValidLiteral(node.getLiteral())) {
                return new NodeValueString(lit.getLexicalForm(), node);
            }
            if (!node.getLiteralDatatype().equals(XSDDatatype.XSDdecimal) && XSDDatatype.XSDinteger.isValidLiteral(lit)) {
                long i = ((Number)lit.getValue()).longValue();
                return new NodeValueInteger(i, node);
            }
            if (XSDDatatype.XSDdecimal.isValidLiteral(lit)) {
                BigDecimal decimal = new BigDecimal(lit.getLexicalForm());
                return new NodeValueDecimal(decimal, node);
            }
            if (XSDDatatype.XSDfloat.isValidLiteral(lit)) {
                float f = ((Number)lit.getValue()).floatValue();
                return new NodeValueFloat(f, node);
            }
            if (XSDDatatype.XSDdouble.isValidLiteral(lit)) {
                double d = ((Number)lit.getValue()).doubleValue();
                return new NodeValueDouble(d, node);
            }
            if (XSDDatatype.XSDdateTime.isValidLiteral(lit)) {
                XSDDateTime dateTime = (XSDDateTime)lit.getValue();
                return new NodeValueDateTime(dateTime.asCalendar(), node);
            }
            if (XSDDatatype.XSDdate.isValidLiteral(lit)) {
                XSDDateTime dateTime = (XSDDateTime)lit.getValue();
                return new NodeValueDate(dateTime.asCalendar(), node);
            }
            if (XSDDatatype.XSDboolean.isValidLiteral(lit)) {
                boolean b = (Boolean)lit.getValue();
                return new NodeValueBoolean(b, node);
            }
            if (enableRomanNumerals.getValue() && lit.getDatatypeURI().equals(RomanNumeralDatatype.get().getURI())) {
                Object obj = RomanNumeralDatatype.get().parse(lit.getLexicalForm());
                if (obj instanceof Integer) {
                    return new NodeValueInteger(((Integer)obj).longValue());
                }
                if (obj instanceof RomanNumeral) {
                    return new NodeValueInteger(((RomanNumeral)obj).intValue());
                }
                throw new ARQInternalErrorException("DatatypeFormatException: Roman numeral is unknown class");
            }
        }
        catch (DatatypeFormatException ex) {
            throw new ARQInternalErrorException("DatatypeFormatException: " + lit, ex);
        }
        return null;
    }

    public static void raise(ExprException ex) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Exception: " + ex.getMessage()));
        }
        throw ex;
    }

    public void visit(ExprVisitor visitor) {
        visitor.visit(this);
    }

    private void forceToNode() {
        if (this.node == null) {
            this.node = this.asNode();
        }
        if (this.node == null) {
            NodeValue.raise(new ExprEvalException("Not a node: " + this));
        }
    }

    public final String asUnquotedString() {
        return this.asString();
    }

    public final String asQuotedString() {
        return this.asQuotedString(null);
    }

    public final String asQuotedString(SerializationContext context) {
        if (this.node == null) {
            this.node = this.asNode();
        }
        if (this.node != null) {
            return FmtUtils.stringForNode(this.node, context);
        }
        return this.toString();
    }

    public String asString() {
        this.forceToNode();
        return NodeFunctions.str(this.node);
    }

    public int hashCode() {
        return this.asNode().hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof NodeValue)) {
            return false;
        }
        NodeValue nv = (NodeValue)other;
        return this.asNode().equals((Object)nv.asNode());
    }

    public abstract void visit(NodeValueVisitor var1);

    public String toString() {
        return this.asQuotedString();
    }
}

