/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.expr;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.core.ARQInternalErrorException;
import com.hp.hpl.jena.query.core.Binding;
import com.hp.hpl.jena.query.core.Var;
import com.hp.hpl.jena.query.engine1.ExecutionContext;
import com.hp.hpl.jena.query.expr.Expr;
import com.hp.hpl.jena.query.expr.ExprNode;
import com.hp.hpl.jena.query.expr.ExprVisitor;
import com.hp.hpl.jena.query.expr.NodeValue;
import com.hp.hpl.jena.query.expr.VariableNotBoundException;
import com.hp.hpl.jena.query.util.IndentedWriter;
import org.apache.commons.logging.LogFactory;

public class NodeVar
extends ExprNode {
    Node varNode = null;

    public NodeVar(String name) {
        this.varNode = Node.createVariable((String)name);
    }

    public NodeVar(Node n) {
        if (!n.isVariable()) {
            throw new ARQInternalErrorException("Attempt to create a NodeVar from a non variable Node: " + n);
        }
        this.varNode = n;
    }

    public NodeValue eval(Binding binding, ExecutionContext execCxt) {
        String name = this.varNode.getName();
        if (binding == null) {
            throw new VariableNotBoundException("Not bound: (no binding): " + name);
        }
        Node v = binding.get(name);
        if (v == null) {
            throw new VariableNotBoundException("Not bound: variable ?" + name);
        }
        return NodeValue.makeNode(v);
    }

    public Expr copySubstitute(Binding binding, boolean foldConstants) {
        if (binding == null || !binding.contains(this.getVarName())) {
            return new NodeVar(this.varNode.getName());
        }
        try {
            return this.eval(binding, null);
        }
        catch (VariableNotBoundException ex) {
            LogFactory.getLog((Class)NodeVar.class).warn((Object)"Failed to eval bound variable");
            throw ex;
        }
    }

    public void visit(ExprVisitor visitor) {
        visitor.visit(this);
    }

    public void format(Query query, IndentedWriter out) {
        out.print('?');
        out.print(this.varNode.getName());
    }

    public int hashCode() {
        return this.varNode.hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof NodeVar)) {
            return false;
        }
        NodeVar nvar = (NodeVar)other;
        return this.getVarName().equals(nvar.getVarName());
    }

    public boolean isVariable() {
        return true;
    }

    public String getVarName() {
        return this.varNode.getName();
    }

    public NodeVar getNodeVar() {
        return this;
    }

    public Var getAsVar() {
        return new Var(this.varNode);
    }

    public Node getAsNode() {
        return this.varNode;
    }

    public String toString() {
        return "?" + this.varNode.getName();
    }
}

