/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.expr.nodevalue;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.expr.NodeValue;
import com.hp.hpl.jena.query.expr.nodevalue.NodeValueVisitor;
import com.hp.hpl.jena.query.util.Utils;

public class NodeValueDouble
extends NodeValue {
    double value = Double.NaN;

    public NodeValueDouble(double d) {
        this.value = d;
    }

    public NodeValueDouble(double d, Node n) {
        super(n);
        this.value = d;
    }

    public boolean isNumber() {
        return true;
    }

    public boolean isDouble() {
        return true;
    }

    public double getDouble() {
        return this.value;
    }

    protected Node makeNode() {
        return Node.createLiteral((String)Utils.stringForm(this.value), null, (RDFDatatype)XSDDatatype.XSDdouble);
    }

    public String asString() {
        return this.toString();
    }

    public String toString() {
        if (this.getNode() != null) {
            return super.asString();
        }
        return Double.toString(this.value);
    }

    public void visit(NodeValueVisitor visitor) {
        visitor.visit(this);
    }
}

