/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.function.library;

import com.hp.hpl.jena.query.QueryBuildException;
import com.hp.hpl.jena.query.core.ARQInternalErrorException;
import com.hp.hpl.jena.query.core.Binding;
import com.hp.hpl.jena.query.engine1.ExecutionContext;
import com.hp.hpl.jena.query.expr.Expr;
import com.hp.hpl.jena.query.expr.ExprEvalException;
import com.hp.hpl.jena.query.expr.NodeValue;
import com.hp.hpl.jena.query.function.Function;
import com.hp.hpl.jena.query.serializer.FmtExprARQSubst;
import com.hp.hpl.jena.query.util.Utils;
import com.hp.hpl.jena.util.FileUtils;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.List;

public class trace
implements Function {
    private static PrintWriter out = FileUtils.asPrintWriterUTF8((OutputStream)System.out);

    public static void setStream(PrintStream stream) {
        out = FileUtils.asPrintWriterUTF8((OutputStream)stream);
    }

    public void build(String uri, List args) {
        if (args.size() != 1) {
            throw new QueryBuildException("Function '" + Utils.className(this) + "' takes one argument");
        }
    }

    public NodeValue exec(Binding binding, List args, String uri, ExecutionContext execCxt) {
        if (args == null) {
            throw new ARQInternalErrorException("Function '" + Utils.className(this) + " Null args list");
        }
        if (args.size() != 1) {
            throw new ExprEvalException("Function '" + Utils.className(this) + " Wanted 1, got " + args.size());
        }
        Expr expr = (Expr)args.get(0);
        String s = FmtExprARQSubst.format(expr, binding, execCxt);
        try {
            NodeValue x = expr.eval(binding, execCxt);
            out.println(s + " => " + x);
            out.flush();
        }
        catch (ExprEvalException ex) {
            out.println(s + " => Exception(" + ex.getMessage() + ")");
        }
        out.flush();
        return NodeValue.booleanReturn(true);
    }
}

