/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.lang.rdql;

import com.hp.hpl.jena.graph.query.Expression;
import com.hp.hpl.jena.graph.query.IndexValues;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.lang.rdql.ExprBoolean;
import com.hp.hpl.jena.query.lang.rdql.ExprNode;
import com.hp.hpl.jena.query.lang.rdql.ExprRDQL;
import com.hp.hpl.jena.query.lang.rdql.NodeValue;
import com.hp.hpl.jena.query.lang.rdql.RDQLEvalTypeException;
import com.hp.hpl.jena.query.lang.rdql.RDQLParser;
import com.hp.hpl.jena.query.lang.rdql.RDQLQueryPrintUtils;
import com.hp.hpl.jena.query.lang.rdql.WorkingVar;
import com.hp.hpl.jena.query.util.IndentedWriter;

public class Q_UnaryNot
extends ExprNode
implements ExprRDQL,
ExprBoolean {
    private String printName = "not";
    private String opSymbol = "!";
    ExprRDQL expr;

    Q_UnaryNot(int id) {
        super(id);
    }

    Q_UnaryNot(RDQLParser p, int id) {
        super(p, id);
    }

    public void jjtClose() {
        int n = this.jjtGetNumChildren();
        if (n != 1) {
            throw new QueryException("Q_UnaryNot: Wrong number of children: " + n);
        }
        this.expr = (ExprRDQL)((Object)this.jjtGetChild(0));
    }

    public NodeValue evalRDQL(Query q, IndexValues env) {
        NodeValue v = this.expr.evalRDQL(q, env);
        if (!v.isBoolean()) {
            throw new RDQLEvalTypeException("Q_UnaryNot: Wanted a number: got " + this.expr);
        }
        WorkingVar result = new WorkingVar();
        result.setBoolean(!v.getBoolean());
        return result;
    }

    public boolean isApply() {
        return true;
    }

    public String getFun() {
        return super.constructURI(this.getClass().getName());
    }

    public int argCount() {
        return 1;
    }

    public Expression getArg(int i) {
        if (i == 0 && this.expr instanceof Expression) {
            return (Expression)this.expr;
        }
        return null;
    }

    public String asInfixString() {
        return RDQLQueryPrintUtils.asInfixString1(this.expr, this.printName, this.opSymbol);
    }

    public String asPrefixString() {
        return RDQLQueryPrintUtils.asPrefixString(this.expr, null, this.printName, this.opSymbol);
    }

    public void format(IndentedWriter w) {
        RDQLQueryPrintUtils.format(w, this.expr, null, this.printName, this.opSymbol);
    }

    public String toString() {
        return this.asInfixString();
    }
}

