/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.pfunction;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.QueryBuildException;
import com.hp.hpl.jena.query.core.Binding;
import com.hp.hpl.jena.query.engine.QueryIterator;
import com.hp.hpl.jena.query.engine1.ExecutionContext;
import com.hp.hpl.jena.query.engine1.iterator.QueryIterNullIterator;
import com.hp.hpl.jena.query.engine1.iterator.QueryIterRepeatApply;
import com.hp.hpl.jena.query.pfunction.PropFuncArg;
import com.hp.hpl.jena.query.pfunction.PropFuncArgType;
import com.hp.hpl.jena.query.pfunction.PropertyFunction;

public abstract class PropertyFunctionBase
implements PropertyFunction {
    PropFuncArgType subjArgType;
    PropFuncArgType objFuncArgType;

    protected PropertyFunctionBase() {
        this(PropFuncArgType.PF_ARG_EITHER, PropFuncArgType.PF_ARG_EITHER);
    }

    protected PropertyFunctionBase(PropFuncArgType subjArgType, PropFuncArgType objFuncArgType) {
        this.subjArgType = subjArgType;
        this.objFuncArgType = objFuncArgType;
    }

    public void build(PropFuncArg argSubject, Node predicate, PropFuncArg argObject, ExecutionContext execCxt) {
        if (this.subjArgType.equals(PropFuncArgType.PF_ARG_SINGLE) && argSubject.isList()) {
            throw new QueryBuildException("List arguments (subject) to " + predicate.getURI());
        }
        if (this.subjArgType.equals(PropFuncArgType.PF_ARG_LIST) && !argSubject.isList()) {
            throw new QueryBuildException("Single argument, list expected (subject) to " + predicate.getURI());
        }
        if (this.objFuncArgType.equals(PropFuncArgType.PF_ARG_SINGLE) && argObject.isList()) {
            throw new QueryBuildException("List arguments (subject) to " + predicate.getURI());
        }
        if (this.objFuncArgType.equals(PropFuncArgType.PF_ARG_LIST) && !argObject.isList()) {
            throw new QueryBuildException("Single argument, list expected (subject) to " + predicate.getURI());
        }
    }

    public QueryIterator exec(QueryIterator input, PropFuncArg argSubject, Node predicate, PropFuncArg argObject, ExecutionContext execCxt) {
        return new RepeatApplyIterator(input, argSubject, predicate, argObject, execCxt);
    }

    public abstract QueryIterator exec(Binding var1, PropFuncArg var2, Node var3, PropFuncArg var4, ExecutionContext var5);

    class RepeatApplyIterator
    extends QueryIterRepeatApply {
        private ExecutionContext execCxt;
        private PropFuncArg argSubject;
        private Node predicate;
        private PropFuncArg argObject;

        public RepeatApplyIterator(QueryIterator input, PropFuncArg argSubject, Node predicate, PropFuncArg argObject, ExecutionContext execCxt) {
            super(input, execCxt);
            this.argSubject = argSubject;
            this.predicate = predicate;
            this.argObject = argObject;
        }

        protected QueryIterator nextStage(Binding binding) {
            QueryIterator iter = PropertyFunctionBase.this.exec(binding, this.argSubject, this.predicate, this.argObject, super.getExecContext());
            if (iter == null) {
                iter = new QueryIterNullIterator(this.execCxt);
            }
            return iter;
        }
    }
}

