/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.serializer;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryVisitor;
import com.hp.hpl.jena.query.SortCondition;
import com.hp.hpl.jena.query.serializer.FmtExpr;
import com.hp.hpl.jena.query.serializer.FmtExprPrefix;
import com.hp.hpl.jena.query.serializer.FormatterElement;
import com.hp.hpl.jena.query.serializer.FormatterPrefix;
import com.hp.hpl.jena.query.serializer.FormatterTemplate;
import com.hp.hpl.jena.query.serializer.SerializationContext;
import com.hp.hpl.jena.query.util.FmtUtils;
import com.hp.hpl.jena.query.util.IndentedWriter;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class QuerySerializerPrefix
implements QueryVisitor {
    protected FormatterTemplate fmtTemplate;
    protected FormatterElement fmtElement;
    protected FmtExpr fmtExpr;
    protected IndentedWriter out = null;
    static final int INDENT = 2;
    static final boolean closingBracketOnSameLine = true;

    QuerySerializerPrefix(OutputStream outStream, SerializationContext context) {
        this(new IndentedWriter(outStream), context);
    }

    QuerySerializerPrefix(IndentedWriter iwriter, SerializationContext context) {
        FormatterPrefix fmt = new FormatterPrefix(iwriter, context);
        this.fmtElement = fmt;
        this.fmtTemplate = fmt;
        this.fmtExpr = new FmtExprPrefix(iwriter, context);
        this.out = iwriter;
    }

    public void startVisit(Query query) {
        this.out.println("(query ");
        this.out.incIndent(2);
    }

    public void finishVisit(Query query) {
        this.out.decIndent(2);
        this.out.println(")");
        this.out.flush();
    }

    public void visitResultForm(Query query) {
    }

    public void visitBase(Query query) {
    }

    public void visitPrefixes(Query query) {
        if (query.getPrefixMapping() == null) {
            return;
        }
        Map pmap = query.getPrefixMapping().getNsPrefixMap();
        Iterator iter = pmap.keySet().iterator();
        while (iter.hasNext()) {
            String k = (String)iter.next();
            String v = (String)pmap.get(k);
            this.out.println("(prefix " + k + ": <" + v + ">)");
        }
    }

    public void visitSelectResultForm(Query query) {
        this.out.print("(select");
        if (query.isQueryResultStar()) {
            this.out.print(" *");
        } else {
            this.writeVarList(query.getResultVars());
        }
        this.out.println(")");
        this.resultFormModifiers(query);
    }

    public void visitConstructResultForm(Query query) {
        this.out.print("(construct");
        this.out.println();
        this.out.incIndent(2);
        query.getConstructTemplate().visit(this.fmtTemplate);
        this.out.decIndent(2);
        this.out.println(")");
        this.resultFormModifiers(query);
    }

    public void visitDescribeResultForm(Query query) {
        this.out.print("(describe");
        this.writeVarList(query.getResultVars());
        this.writeNodeList(query.getResultURIs());
        this.out.println(")");
        this.resultFormModifiers(query);
    }

    public void visitAskResultForm(Query query) {
        this.out.print("(ask");
        this.out.incIndent(2);
        this.out.decIndent(2);
        this.out.println(")");
        this.resultFormModifiers(query);
    }

    public void visitDatasetDecl(Query query) {
        String $;
        String graphIRI;
        Iterator iter = query.getGraphURIs().iterator();
        while (iter.hasNext()) {
            graphIRI = (String)iter.next();
            $ = FmtUtils.stringForNode(Node.createURI((String)graphIRI), query.getPrefixMapping());
            this.out.println("(from " + $ + ")");
        }
        iter = query.getNamedGraphURIs().iterator();
        while (iter.hasNext()) {
            graphIRI = (String)iter.next();
            $ = FmtUtils.stringForNode(Node.createURI((String)graphIRI), query.getPrefixMapping());
            this.out.println("(from named " + $ + ")");
        }
    }

    public void visitQueryPattern(Query query) {
        if (query.getQueryPattern() != null) {
            query.getQueryPattern().visit(this.fmtElement);
        }
        this.out.println();
    }

    public void visitOrderBy(Query query) {
    }

    public void visitOffset(Query query) {
    }

    public void visitLimit(Query query) {
    }

    private void writeVarList(List vars) {
        Iterator iter = vars.iterator();
        while (iter.hasNext()) {
            String var = (String)iter.next();
            this.out.print(" ?" + var);
        }
    }

    private void writeNodeList(List nodes) {
        Iterator iter = nodes.iterator();
        while (iter.hasNext()) {
            Node n = (Node)iter.next();
            this.out.print(" ");
            this.out.print(FmtUtils.stringForNode(n));
        }
    }

    private void resultFormModifiers(Query query) {
        if (query.hasOrderBy()) {
            Iterator iter = query.getOrderBy().iterator();
            while (iter.hasNext()) {
                this.out.print("(order by ");
                SortCondition sc = (SortCondition)iter.next();
                sc.format(this.fmtExpr, this.out);
                this.out.println(")");
            }
        }
        if (query.isDistinct()) {
            this.out.println("(distinct true)");
        }
        if (query.hasOffset()) {
            this.out.println("(offset " + query.getOffset() + ")");
        }
        if (query.hasLimit()) {
            this.out.println("(limit " + query.getLimit() + ")");
        }
    }
}

