/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.util;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QueryParseException;
import com.hp.hpl.jena.query.core.ARQConstants;
import com.hp.hpl.jena.query.expr.Expr;
import com.hp.hpl.jena.query.expr.NodeValue;
import com.hp.hpl.jena.query.expr.NodeVar;
import com.hp.hpl.jena.query.lang.sparql.ParseException;
import com.hp.hpl.jena.query.lang.sparql.SPARQLParser;
import com.hp.hpl.jena.query.lang.sparql.Token;
import com.hp.hpl.jena.query.lang.sparql.TokenMgrError;
import com.hp.hpl.jena.query.serializer.FmtExprARQ;
import com.hp.hpl.jena.query.serializer.FmtExprPrefix;
import com.hp.hpl.jena.query.util.IndentedLineBuffer;
import com.hp.hpl.jena.query.util.IndentedWriter;
import java.io.StringReader;
import java.util.List;
import java.util.ListIterator;

public class ExprUtils {
    public static Expr nodeToExpr(Node n) {
        if (n.isVariable()) {
            return new NodeVar(n);
        }
        return NodeValue.makeNode(n);
    }

    public static String joinList(List args, String sep) {
        if (args == null) {
            return "<<Null list>>";
        }
        if (args.size() == 0) {
            return "<<Empty list>>";
        }
        StringBuffer s = new StringBuffer();
        boolean first = true;
        ListIterator iter = args.listIterator();
        while (iter.hasNext()) {
            Expr ex;
            if (!first) {
                s.append(sep);
            }
            if ((ex = (Expr)iter.next()) instanceof NodeValue) {
                NodeValue nv = (NodeValue)ex;
                s.append(nv.asQuotedString());
            } else {
                s.append(ex.toString());
            }
            first = false;
        }
        return s.toString();
    }

    public static Expr parse(String s) {
        Query query = QueryFactory.make();
        query.setPrefixMapping(ARQConstants.getGlobalPrefixMap());
        return ExprUtils.parse(query, s, true);
    }

    public static Expr parse(Query query, String s, boolean checkAllUsed) {
        try {
            StringReader in = new StringReader(s);
            SPARQLParser parser = new SPARQLParser(in);
            parser.setQuery(query);
            Expr expr = parser.Expression();
            if (checkAllUsed) {
                Token t = parser.getNextToken();
                if (t.kind != 0) {
                    throw new QueryParseException("Extra tokens beginning \"" + t.image + "\" starting line " + t.beginLine + ", column " + t.beginColumn, t.beginLine, t.beginColumn);
                }
            }
            return expr;
        }
        catch (ParseException ex) {
            throw new QueryParseException(ex.getMessage(), ex.currentToken.beginLine, ex.currentToken.beginLine);
        }
        catch (TokenMgrError tErr) {
            throw new QueryParseException(tErr.getMessage(), -1, -1);
        }
        catch (Error err) {
            String tmp = err.getMessage();
            if (tmp == null) {
                throw new QueryParseException(err, -1, -1);
            }
            throw new QueryParseException(tmp, -1, -1);
        }
    }

    public static NodeValue parseNodeValue(String s) {
        try {
            Query query = QueryFactory.make();
            query.setPrefixMapping(ARQConstants.getGlobalPrefixMap());
            StringReader in = new StringReader(s);
            SPARQLParser parser = new SPARQLParser(in);
            parser.setQuery(query);
            Node n = parser.GraphTerm();
            Token t = parser.getNextToken();
            if (t.kind != 0) {
                throw ExprUtils.makeException("Extra tokens beginning \"" + t.image + "\" starting line " + t.beginLine + ", column " + t.beginColumn, t.beginLine, t.beginColumn);
            }
            NodeValue nv = NodeValue.makeNode(n);
            return nv;
        }
        catch (ParseException ex) {
            throw new QueryParseException(ex.getMessage(), ex.currentToken.beginLine, ex.currentToken.beginColumn);
        }
    }

    private static QueryParseException makeException(String msg, int line, int column) {
        return new QueryParseException(msg, line, column);
    }

    public static void fmtSPARQL(IndentedWriter iOut, Expr expr) {
        FmtExprARQ v = new FmtExprARQ(iOut, ARQConstants.getGlobalPrefixMap());
        expr.visit(v);
    }

    public static String fmtSPARQL(Expr expr) {
        IndentedLineBuffer buff = new IndentedLineBuffer();
        ExprUtils.fmtSPARQL(buff.getIndentedWriter(), expr);
        return buff.toString();
    }

    public static void fmtPrefix(IndentedWriter iOut, Expr expr) {
        FmtExprPrefix v = new FmtExprPrefix(iOut, ARQConstants.getGlobalPrefixMap());
        expr.visit(v);
    }

    public static String fmtPrefix(Expr expr) {
        IndentedLineBuffer buff = new IndentedLineBuffer();
        ExprUtils.fmtPrefix(buff.getIndentedWriter(), expr);
        return buff.toString();
    }
}

