/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.util;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.core.ARQInternalErrorException;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class GraphListUtils {
    private static Node rdfFirst = RDF.first.asNode();
    private static Node rdfRest = RDF.rest.asNode();
    private static Node rdfNil = RDF.nil.asNode();

    public static List findList(List triples, Node start, final List listTriples) {
        Accumulate acc = new Accumulate(){

            public void acc(List list2, Slot slot) {
                if (listTriples != null) {
                    listTriples.add(slot.tripleFirst);
                    listTriples.add(slot.tripleRest);
                }
                list2.add(slot.listElt);
            }
        };
        return GraphListUtils.processList(triples, new ArrayList(), start, acc);
    }

    private static List processList(List triples, List elements, Node node, Accumulate acc) {
        if (node.equals((Object)rdfNil)) {
            return elements;
        }
        Slot slot = GraphListUtils.getNextInList(triples, node);
        if (slot == null) {
            return null;
        }
        acc.acc(elements, slot);
        return GraphListUtils.processList(triples, elements, slot.tripleRest.getObject(), acc);
    }

    private static Slot getNextInList(List triples, Node listNode) {
        if (listNode.equals((Object)rdfNil)) {
            throw new ARQInternalErrorException("rdf:nil passed to getNextInList");
        }
        Slot slot = new Slot();
        slot.tripleFirst = GraphListUtils.findUnique(triples, listNode, rdfFirst);
        if (slot.tripleFirst == null) {
            return null;
        }
        slot.tripleRest = GraphListUtils.findUnique(triples, listNode, rdfRest);
        if (slot.tripleRest == null) {
            return null;
        }
        slot.listElt = slot.tripleFirst.getObject();
        return slot;
    }

    private static Triple findUnique(List triples, Node s, Node p) {
        return GraphListUtils.findUnique(triples, s, p, null);
    }

    public static Triple findUnique(List triples, Node s, Node p, Node o) {
        Iterator iter = GraphListUtils.find(triples, s, p, null);
        if (!iter.hasNext()) {
            return null;
        }
        Triple triple = (Triple)iter.next();
        if (iter.hasNext()) {
            return null;
        }
        return triple;
    }

    public static Iterator find(List triples, Node s, Node p, Node o) {
        if (s == Node.ANY) {
            s = null;
        }
        if (p == Node.ANY) {
            p = null;
        }
        if (o == Node.ANY) {
            o = null;
        }
        HashSet<Triple> r = new HashSet<Triple>();
        Iterator iter = triples.iterator();
        while (iter.hasNext()) {
            Triple t = (Triple)iter.next();
            if (s != null && !t.getSubject().equals((Object)s) || p != null && !t.getPredicate().equals((Object)p) || o != null && !t.getObject().equals((Object)o)) continue;
            r.add(t);
        }
        return r.iterator();
    }

    private static interface Accumulate {
        public void acc(List var1, Slot var2);
    }

    private static class Slot {
        Node listElt;
        Triple tripleFirst;
        Triple tripleRest;

        private Slot() {
        }
    }
}

