/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.util;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.core.ARQConstants;
import java.util.HashMap;
import java.util.Map;

public class LabelToNodeMap {
    Map bNodeLabels = new HashMap();
    long varCounter = 0L;
    String marker = ARQConstants.anonVarMarker;
    boolean generateVars = false;

    public LabelToNodeMap(boolean genVars) {
        this.generateVars = genVars;
    }

    public LabelToNodeMap(boolean genVars, String marker) {
        this.generateVars = genVars;
        this.marker = ARQConstants.anonVarMarker + marker;
    }

    public Node asNode(String label) {
        Node n = (Node)this.bNodeLabels.get(label);
        if (n != null) {
            return n;
        }
        n = this.allocNode();
        this.bNodeLabels.put(label, n);
        return n;
    }

    public Node allocNode() {
        if (this.generateVars) {
            return this.allocAnonVariable();
        }
        return Node.createAnon();
    }

    private Node allocAnonVariable() {
        ++this.varCounter;
        Node v = Node.createVariable((String)(this.marker + this.varCounter));
        return v;
    }

    public void clear() {
        this.bNodeLabels.clear();
    }
}

