/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.explanation;

import com.clarkparsia.explanation.BlackBoxExplanation;
import com.clarkparsia.explanation.ExplanationGenerator;
import com.clarkparsia.explanation.HSTExplanationGenerator;
import com.clarkparsia.explanation.MultipleExplanationGenerator;
import com.clarkparsia.explanation.SatisfiabilityConverter;
import com.clarkparsia.explanation.util.ExplanationProgressMonitor;
import java.util.Set;
import org.semanticweb.owl.inference.OWLReasoner;
import org.semanticweb.owl.inference.OWLReasonerException;
import org.semanticweb.owl.inference.OWLReasonerFactory;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.model.OWLRuntimeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultExplanationGenerator
implements ExplanationGenerator {
    private OWLDataFactory dataFactory;
    private MultipleExplanationGenerator gen;

    public DefaultExplanationGenerator(OWLOntologyManager man, OWLReasonerFactory reasonerFactory, OWLOntology ontology, ExplanationProgressMonitor progressMonitor) {
        this(man, reasonerFactory, ontology, DefaultExplanationGenerator.createAndLoadReasoner(man, reasonerFactory, ontology), progressMonitor);
    }

    private static OWLReasoner createAndLoadReasoner(OWLOntologyManager man, OWLReasonerFactory factory, OWLOntology ont) {
        OWLReasoner reasoner = factory.createReasoner(man);
        try {
            reasoner.loadOntologies(man.getImportsClosure(ont));
            return reasoner;
        }
        catch (OWLReasonerException e) {
            throw new OWLRuntimeException(e);
        }
    }

    public DefaultExplanationGenerator(OWLOntologyManager man, OWLReasonerFactory reasonerFactory, OWLOntology ontology, OWLReasoner reasoner, ExplanationProgressMonitor progressMonitor) {
        this.dataFactory = man.getOWLDataFactory();
        BlackBoxExplanation singleGen = new BlackBoxExplanation(man);
        this.gen = new HSTExplanationGenerator(singleGen);
        this.gen.setOntology(ontology);
        this.gen.setReasoner(reasoner);
        this.gen.setReasonerFactory(reasonerFactory);
        if (progressMonitor != null) {
            this.gen.setProgressMonitor(progressMonitor);
        }
    }

    @Override
    public Set<OWLAxiom> getExplanation(OWLDescription unsatClass) {
        return this.gen.getExplanation(unsatClass);
    }

    public Set<OWLAxiom> getExplanation(OWLAxiom axiom) {
        SatisfiabilityConverter converter = new SatisfiabilityConverter(this.dataFactory);
        return this.getExplanation(converter.convert(axiom));
    }

    @Override
    public Set<Set<OWLAxiom>> getExplanations(OWLDescription unsatClass) {
        return this.gen.getExplanations(unsatClass);
    }

    public Set<Set<OWLAxiom>> getExplanations(OWLAxiom axiom) {
        SatisfiabilityConverter converter = new SatisfiabilityConverter(this.dataFactory);
        return this.getExplanations(converter.convert(axiom));
    }

    @Override
    public Set<Set<OWLAxiom>> getExplanations(OWLDescription unsatClass, int maxExplanations) {
        return this.gen.getExplanations(unsatClass, maxExplanations);
    }

    public Set<Set<OWLAxiom>> getExplanations(OWLAxiom axiom, int maxExplanations) throws OWLException {
        SatisfiabilityConverter converter = new SatisfiabilityConverter(this.dataFactory);
        return this.getExplanations(converter.convert(axiom), maxExplanations);
    }
}

