/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.modularity.locality;

import com.clarkparsia.modularity.locality.LocalityClass;
import com.clarkparsia.modularity.locality.LocalityEvaluator;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import org.semanticweb.owl.model.OWLAntiSymmetricObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLAxiomAnnotationAxiom;
import org.semanticweb.owl.model.OWLAxiomVisitor;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLClassAssertionAxiom;
import org.semanticweb.owl.model.OWLDataAllRestriction;
import org.semanticweb.owl.model.OWLDataExactCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataMaxCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataMinCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLDataPropertyExpression;
import org.semanticweb.owl.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLDataSomeRestriction;
import org.semanticweb.owl.model.OWLDataSubPropertyAxiom;
import org.semanticweb.owl.model.OWLDataValueRestriction;
import org.semanticweb.owl.model.OWLDeclarationAxiom;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLDescriptionVisitor;
import org.semanticweb.owl.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owl.model.OWLDisjointClassesAxiom;
import org.semanticweb.owl.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owl.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLDisjointUnionAxiom;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLEntityAnnotationAxiom;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owl.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owl.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLImportsDeclaration;
import org.semanticweb.owl.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLObjectAllRestriction;
import org.semanticweb.owl.model.OWLObjectComplementOf;
import org.semanticweb.owl.model.OWLObjectExactCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectIntersectionOf;
import org.semanticweb.owl.model.OWLObjectMaxCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectMinCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectOneOf;
import org.semanticweb.owl.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyChainSubPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLObjectSelfRestriction;
import org.semanticweb.owl.model.OWLObjectSomeRestriction;
import org.semanticweb.owl.model.OWLObjectSubPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectUnionOf;
import org.semanticweb.owl.model.OWLObjectValueRestriction;
import org.semanticweb.owl.model.OWLOntologyAnnotationAxiom;
import org.semanticweb.owl.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLSameIndividualsAxiom;
import org.semanticweb.owl.model.OWLSubClassAxiom;
import org.semanticweb.owl.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owl.model.SWRLRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyntacticLocalityEvaluator
implements LocalityEvaluator {
    private LocalityClass localityCls;
    private AxiomLocalityVisitor axiomVisitor;
    private static EnumSet<LocalityClass> supportedLocalityClasses = EnumSet.of(LocalityClass.TOP_BOTTOM, LocalityClass.BOTTOM_BOTTOM, LocalityClass.TOP_TOP);

    public SyntacticLocalityEvaluator(LocalityClass localityClass) {
        this.localityCls = localityClass;
        this.axiomVisitor = new AxiomLocalityVisitor();
        if (!supportedLocalityClasses.contains((Object)localityClass)) {
            throw new RuntimeException("Unsupported locality class: " + (Object)((Object)localityClass));
        }
    }

    public Set<LocalityClass> supportedLocalityClasses() {
        return supportedLocalityClasses;
    }

    @Override
    public boolean isLocal(OWLAxiom axiom, Set<? extends OWLEntity> signature) {
        return this.axiomVisitor.isLocal(axiom, signature);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TopEquivalenceEvaluator
    implements OWLDescriptionVisitor {
        private BottomEquivalenceEvaluator bottomEvaluator;
        private boolean isTopEquivalent;
        private LocalityClass localityCls;
        private Collection<? extends OWLEntity> signature;

        private boolean isTopEquivalent(OWLDescription desc) {
            desc.accept(this);
            return this.isTopEquivalent;
        }

        public boolean isTopEquivalent(OWLDescription desc, Collection<? extends OWLEntity> signature, LocalityClass localityCls) {
            this.localityCls = localityCls;
            this.signature = signature;
            desc.accept(this);
            return this.isTopEquivalent;
        }

        public void setBottomEvaluator(BottomEquivalenceEvaluator evaluator) {
            this.bottomEvaluator = evaluator;
        }

        @Override
        public void visit(OWLClass desc) {
            switch (this.localityCls) {
                case BOTTOM_BOTTOM: {
                    this.isTopEquivalent = desc.isOWLThing();
                    break;
                }
                case TOP_BOTTOM: 
                case TOP_TOP: {
                    this.isTopEquivalent = desc.isOWLThing() || !desc.isOWLNothing() && !this.signature.contains(desc);
                }
            }
        }

        @Override
        public void visit(OWLDataAllRestriction desc) {
            switch (this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isTopEquivalent = !this.signature.contains(((OWLDataPropertyExpression)desc.getProperty()).asOWLDataProperty());
                    break;
                }
                case TOP_TOP: {
                    this.isTopEquivalent = false;
                }
            }
        }

        @Override
        public void visit(OWLDataExactCardinalityRestriction desc) {
            switch (this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isTopEquivalent = desc.getCardinality() == 0 && !this.signature.contains(((OWLDataPropertyExpression)desc.getProperty()).asOWLDataProperty());
                    break;
                }
                case TOP_TOP: {
                    this.isTopEquivalent = false;
                }
            }
        }

        @Override
        public void visit(OWLDataMaxCardinalityRestriction desc) {
            switch (this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isTopEquivalent = !this.signature.contains(((OWLDataPropertyExpression)desc.getProperty()).asOWLDataProperty());
                    break;
                }
                case TOP_TOP: {
                    this.isTopEquivalent = false;
                }
            }
        }

        @Override
        public void visit(OWLDataMinCardinalityRestriction desc) {
            this.isTopEquivalent = desc.getCardinality() == 0;
        }

        @Override
        public void visit(OWLDataSomeRestriction desc) {
            this.isTopEquivalent = false;
        }

        @Override
        public void visit(OWLDataValueRestriction desc) {
            this.isTopEquivalent = false;
        }

        @Override
        public void visit(OWLObjectAllRestriction desc) {
            switch (this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isTopEquivalent = !this.signature.contains(((OWLObjectPropertyExpression)desc.getProperty()).getNamedProperty()) || this.isTopEquivalent((OWLDescription)desc.getFiller());
                    break;
                }
                case TOP_TOP: {
                    this.isTopEquivalent = this.isTopEquivalent((OWLDescription)desc.getFiller());
                }
            }
        }

        @Override
        public void visit(OWLObjectComplementOf desc) {
            this.isTopEquivalent = this.bottomEvaluator.isBottomEquivalent(desc.getOperand(), this.signature, this.localityCls);
        }

        @Override
        public void visit(OWLObjectExactCardinalityRestriction desc) {
            switch (this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isTopEquivalent = desc.getCardinality() == 0 && (!this.signature.contains(((OWLObjectPropertyExpression)desc.getProperty()).getNamedProperty()) || this.bottomEvaluator.isBottomEquivalent((OWLDescription)desc.getFiller(), this.signature, this.localityCls));
                    break;
                }
                case TOP_TOP: {
                    this.isTopEquivalent = desc.getCardinality() == 0 && this.bottomEvaluator.isBottomEquivalent((OWLDescription)desc.getFiller(), this.signature, this.localityCls);
                }
            }
        }

        @Override
        public void visit(OWLObjectIntersectionOf desc) {
            for (OWLDescription conj : desc.getOperands()) {
                if (this.isTopEquivalent(conj)) continue;
                this.isTopEquivalent = false;
                return;
            }
            this.isTopEquivalent = true;
        }

        @Override
        public void visit(OWLObjectMaxCardinalityRestriction desc) {
            switch (this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isTopEquivalent = !this.signature.contains(((OWLObjectPropertyExpression)desc.getProperty()).getNamedProperty()) || this.bottomEvaluator.isBottomEquivalent((OWLDescription)desc.getFiller(), this.signature, this.localityCls);
                    break;
                }
                case TOP_TOP: {
                    this.isTopEquivalent = this.bottomEvaluator.isBottomEquivalent((OWLDescription)desc.getFiller(), this.signature, this.localityCls);
                }
            }
        }

        @Override
        public void visit(OWLObjectMinCardinalityRestriction desc) {
            int card = desc.getCardinality();
            switch (this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isTopEquivalent = card == 0;
                    break;
                }
                case TOP_TOP: {
                    this.isTopEquivalent = card == 0 || card > 0 && !this.signature.contains(((OWLObjectPropertyExpression)desc.getProperty()).getNamedProperty()) && this.isTopEquivalent((OWLDescription)desc.getFiller());
                }
            }
        }

        @Override
        public void visit(OWLObjectOneOf desc) {
            this.isTopEquivalent = false;
        }

        @Override
        public void visit(OWLObjectSelfRestriction desc) {
            switch (this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isTopEquivalent = false;
                    break;
                }
                case TOP_TOP: {
                    this.isTopEquivalent = !this.signature.contains(((OWLObjectPropertyExpression)desc.getProperty()).getNamedProperty());
                }
            }
        }

        @Override
        public void visit(OWLObjectSomeRestriction desc) {
            switch (this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isTopEquivalent = false;
                    break;
                }
                case TOP_TOP: {
                    this.isTopEquivalent = !this.signature.contains(((OWLObjectPropertyExpression)desc.getProperty()).getNamedProperty()) && this.isTopEquivalent((OWLDescription)desc.getFiller());
                }
            }
        }

        @Override
        public void visit(OWLObjectUnionOf desc) {
            for (OWLDescription conj : desc.getOperands()) {
                if (!this.isTopEquivalent(conj)) continue;
                this.isTopEquivalent = true;
                return;
            }
            this.isTopEquivalent = false;
        }

        @Override
        public void visit(OWLObjectValueRestriction desc) {
            switch (this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isTopEquivalent = false;
                    break;
                }
                case TOP_TOP: {
                    this.isTopEquivalent = !this.signature.contains(((OWLObjectPropertyExpression)desc.getProperty()).getNamedProperty());
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BottomEquivalenceEvaluator
    implements OWLDescriptionVisitor {
        private boolean isBottomEquivalent;
        private LocalityClass localityCls;
        private Collection<? extends OWLEntity> signature;
        private TopEquivalenceEvaluator topEvaluator;

        private boolean isBottomEquivalent(OWLDescription desc) {
            desc.accept(this);
            return this.isBottomEquivalent;
        }

        public boolean isBottomEquivalent(OWLDescription desc, Collection<? extends OWLEntity> signature, LocalityClass localityCls) {
            this.localityCls = localityCls;
            this.signature = signature;
            desc.accept(this);
            return this.isBottomEquivalent;
        }

        public void setTopEvaluator(TopEquivalenceEvaluator evaluator) {
            this.topEvaluator = evaluator;
        }

        @Override
        public void visit(OWLClass desc) {
            switch (this.localityCls) {
                case BOTTOM_BOTTOM: {
                    this.isBottomEquivalent = desc.isOWLNothing() || !desc.isOWLThing() && !this.signature.contains(desc);
                    break;
                }
                case TOP_BOTTOM: 
                case TOP_TOP: {
                    this.isBottomEquivalent = desc.isOWLNothing();
                }
            }
        }

        @Override
        public void visit(OWLDataAllRestriction desc) {
            this.isBottomEquivalent = false;
        }

        @Override
        public void visit(OWLDataExactCardinalityRestriction desc) {
            switch (this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isBottomEquivalent = desc.getCardinality() > 0 && !this.signature.contains(((OWLDataPropertyExpression)desc.getProperty()).asOWLDataProperty());
                    break;
                }
                case TOP_TOP: {
                    this.isBottomEquivalent = false;
                }
            }
        }

        @Override
        public void visit(OWLDataMaxCardinalityRestriction desc) {
            this.isBottomEquivalent = false;
        }

        @Override
        public void visit(OWLDataMinCardinalityRestriction desc) {
            switch (this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isBottomEquivalent = desc.getCardinality() > 0 && !this.signature.contains(((OWLDataPropertyExpression)desc.getProperty()).asOWLDataProperty());
                    break;
                }
                case TOP_TOP: {
                    this.isBottomEquivalent = false;
                }
            }
        }

        @Override
        public void visit(OWLDataSomeRestriction desc) {
            switch (this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isBottomEquivalent = !this.signature.contains(((OWLDataPropertyExpression)desc.getProperty()).asOWLDataProperty());
                    break;
                }
                case TOP_TOP: {
                    this.isBottomEquivalent = false;
                }
            }
        }

        @Override
        public void visit(OWLDataValueRestriction desc) {
            switch (this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isBottomEquivalent = !this.signature.contains(((OWLDataPropertyExpression)desc.getProperty()).asOWLDataProperty());
                    break;
                }
                case TOP_TOP: {
                    this.isBottomEquivalent = false;
                }
            }
        }

        @Override
        public void visit(OWLObjectAllRestriction desc) {
            switch (this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isBottomEquivalent = false;
                    break;
                }
                case TOP_TOP: {
                    this.isBottomEquivalent = !this.signature.contains(((OWLObjectPropertyExpression)desc.getProperty()).getNamedProperty()) && this.isBottomEquivalent((OWLDescription)desc.getFiller());
                }
            }
        }

        @Override
        public void visit(OWLObjectComplementOf desc) {
            this.isBottomEquivalent = this.topEvaluator.isTopEquivalent(desc.getOperand(), this.signature, this.localityCls);
        }

        @Override
        public void visit(OWLObjectExactCardinalityRestriction desc) {
            switch (this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isBottomEquivalent = desc.getCardinality() > 0 && !this.signature.contains(((OWLObjectPropertyExpression)desc.getProperty()).getNamedProperty()) || this.isBottomEquivalent((OWLDescription)desc.getFiller());
                    break;
                }
                case TOP_TOP: {
                    this.isBottomEquivalent = desc.getCardinality() > 0 && (this.isBottomEquivalent((OWLDescription)desc.getFiller()) || !this.signature.contains(((OWLObjectPropertyExpression)desc.getProperty()).getNamedProperty()) && this.topEvaluator.isTopEquivalent((OWLDescription)desc.getFiller(), this.signature, this.localityCls));
                }
            }
        }

        @Override
        public void visit(OWLObjectIntersectionOf desc) {
            for (OWLDescription conj : desc.getOperands()) {
                if (!this.isBottomEquivalent(conj)) continue;
                this.isBottomEquivalent = true;
                return;
            }
            this.isBottomEquivalent = false;
        }

        @Override
        public void visit(OWLObjectMaxCardinalityRestriction desc) {
            switch (this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isBottomEquivalent = false;
                    break;
                }
                case TOP_TOP: {
                    this.isBottomEquivalent = desc.getCardinality() > 0 && !this.signature.contains(((OWLObjectPropertyExpression)desc.getProperty()).getNamedProperty()) && this.topEvaluator.isTopEquivalent((OWLDescription)desc.getFiller(), this.signature, this.localityCls);
                }
            }
        }

        @Override
        public void visit(OWLObjectMinCardinalityRestriction desc) {
            switch (this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isBottomEquivalent = desc.getCardinality() > 0 && !this.signature.contains(((OWLObjectPropertyExpression)desc.getProperty()).getNamedProperty()) || this.isBottomEquivalent((OWLDescription)desc.getFiller());
                    break;
                }
                case TOP_TOP: {
                    this.isBottomEquivalent = desc.getCardinality() > 0 && this.isBottomEquivalent((OWLDescription)desc.getFiller());
                }
            }
        }

        @Override
        public void visit(OWLObjectOneOf desc) {
            this.isBottomEquivalent = desc.getIndividuals().isEmpty();
        }

        @Override
        public void visit(OWLObjectSelfRestriction desc) {
            switch (this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isBottomEquivalent = !this.signature.contains(((OWLObjectPropertyExpression)desc.getProperty()).getNamedProperty());
                    break;
                }
                case TOP_TOP: {
                    this.isBottomEquivalent = false;
                }
            }
        }

        @Override
        public void visit(OWLObjectSomeRestriction desc) {
            switch (this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isBottomEquivalent = !this.signature.contains(((OWLObjectPropertyExpression)desc.getProperty()).getNamedProperty()) || this.isBottomEquivalent((OWLDescription)desc.getFiller());
                    break;
                }
                case TOP_TOP: {
                    this.isBottomEquivalent = this.isBottomEquivalent((OWLDescription)desc.getFiller());
                }
            }
        }

        @Override
        public void visit(OWLObjectUnionOf desc) {
            for (OWLDescription disj : desc.getOperands()) {
                if (this.isBottomEquivalent(disj)) continue;
                this.isBottomEquivalent = false;
                return;
            }
            this.isBottomEquivalent = true;
        }

        @Override
        public void visit(OWLObjectValueRestriction desc) {
            switch (this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isBottomEquivalent = !this.signature.contains(((OWLObjectPropertyExpression)desc.getProperty()).getNamedProperty()) || !this.signature.contains(desc.getValue());
                    break;
                }
                case TOP_TOP: {
                    this.isBottomEquivalent = false;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AxiomLocalityVisitor
    implements OWLAxiomVisitor {
        private BottomEquivalenceEvaluator bottomEvaluator = new BottomEquivalenceEvaluator();
        private boolean isLocal;
        private Collection<? extends OWLEntity> signature;
        private TopEquivalenceEvaluator topEvaluator = new TopEquivalenceEvaluator();

        public AxiomLocalityVisitor() {
            this.topEvaluator.setBottomEvaluator(this.bottomEvaluator);
            this.bottomEvaluator.setTopEvaluator(this.topEvaluator);
        }

        public boolean isLocal(OWLAxiom axiom, Collection<? extends OWLEntity> signature) {
            this.signature = signature;
            this.isLocal = false;
            axiom.accept(this);
            return this.isLocal;
        }

        @Override
        public void visit(OWLAntiSymmetricObjectPropertyAxiom axiom) {
            switch (SyntacticLocalityEvaluator.this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isLocal = true;
                    break;
                }
                case TOP_TOP: {
                    this.isLocal = false;
                }
            }
        }

        @Override
        public void visit(OWLAxiomAnnotationAxiom axiom) {
            this.isLocal = true;
        }

        @Override
        public void visit(OWLClassAssertionAxiom axiom) {
            this.isLocal = this.topEvaluator.isTopEquivalent(axiom.getDescription(), this.signature, SyntacticLocalityEvaluator.this.localityCls);
        }

        @Override
        public void visit(OWLDataPropertyAssertionAxiom axiom) {
            switch (SyntacticLocalityEvaluator.this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isLocal = false;
                    break;
                }
                case TOP_TOP: {
                    this.isLocal = !this.signature.contains(((OWLDataPropertyExpression)axiom.getProperty()).asOWLDataProperty());
                }
            }
        }

        @Override
        public void visit(OWLDataPropertyDomainAxiom axiom) {
            switch (SyntacticLocalityEvaluator.this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isLocal = !this.signature.contains(((OWLDataPropertyExpression)axiom.getProperty()).asOWLDataProperty()) || this.topEvaluator.isTopEquivalent(axiom.getDomain(), this.signature, SyntacticLocalityEvaluator.this.localityCls);
                    break;
                }
                case TOP_TOP: {
                    this.isLocal = this.topEvaluator.isTopEquivalent(axiom.getDomain(), this.signature, SyntacticLocalityEvaluator.this.localityCls);
                }
            }
        }

        @Override
        public void visit(OWLDataPropertyRangeAxiom axiom) {
            switch (SyntacticLocalityEvaluator.this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isLocal = !this.signature.contains(((OWLDataPropertyExpression)axiom.getProperty()).asOWLDataProperty());
                    break;
                }
                case TOP_TOP: {
                    this.isLocal = false;
                }
            }
        }

        @Override
        public void visit(OWLDataSubPropertyAxiom axiom) {
            switch (SyntacticLocalityEvaluator.this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isLocal = !this.signature.contains(((OWLDataPropertyExpression)axiom.getSubProperty()).asOWLDataProperty());
                    break;
                }
                case TOP_TOP: {
                    this.isLocal = !this.signature.contains(((OWLDataPropertyExpression)axiom.getSuperProperty()).asOWLDataProperty());
                }
            }
        }

        @Override
        public void visit(OWLDeclarationAxiom axiom) {
            this.isLocal = true;
        }

        @Override
        public void visit(OWLDifferentIndividualsAxiom axiom) {
            this.isLocal = true;
        }

        @Override
        public void visit(OWLDisjointClassesAxiom axiom) {
            Set<OWLDescription> disjs = axiom.getDescriptions();
            int size = disjs.size();
            if (size == 1) {
                throw new RuntimeException("Unary disjoint axiom.");
            }
            boolean nonBottomEquivDescFound = false;
            for (OWLDescription desc : disjs) {
                if (this.bottomEvaluator.isBottomEquivalent(desc, this.signature, SyntacticLocalityEvaluator.this.localityCls)) continue;
                if (nonBottomEquivDescFound) {
                    this.isLocal = false;
                    return;
                }
                nonBottomEquivDescFound = true;
            }
            this.isLocal = true;
        }

        @Override
        public void visit(OWLDisjointDataPropertiesAxiom axiom) {
            switch (SyntacticLocalityEvaluator.this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    Set disjs = axiom.getProperties();
                    int size = disjs.size();
                    if (size == 1) {
                        throw new RuntimeException("Unary disjoint axiom.");
                    }
                    boolean nonBottomEquivPropFound = false;
                    for (OWLDataPropertyExpression dpe : disjs) {
                        if (!this.signature.contains(dpe.asOWLDataProperty())) continue;
                        if (nonBottomEquivPropFound) {
                            this.isLocal = false;
                            return;
                        }
                        nonBottomEquivPropFound = true;
                    }
                    this.isLocal = true;
                    break;
                }
                case TOP_TOP: {
                    this.isLocal = false;
                }
            }
        }

        @Override
        public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
            switch (SyntacticLocalityEvaluator.this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    Set disjs = axiom.getProperties();
                    int size = disjs.size();
                    if (size == 1) {
                        throw new RuntimeException("Unary disjoint axiom.");
                    }
                    boolean nonBottomEquivPropFound = false;
                    for (OWLObjectPropertyExpression ope : disjs) {
                        if (!this.signature.contains(ope.getNamedProperty())) continue;
                        if (nonBottomEquivPropFound) {
                            this.isLocal = false;
                            return;
                        }
                        nonBottomEquivPropFound = true;
                    }
                    this.isLocal = true;
                    break;
                }
                case TOP_TOP: {
                    this.isLocal = false;
                }
            }
        }

        @Override
        public void visit(OWLDisjointUnionAxiom axiom) {
            OWLClass lhs = axiom.getOWLClass();
            Set<OWLDescription> rhs = axiom.getDescriptions();
            switch (SyntacticLocalityEvaluator.this.localityCls) {
                case BOTTOM_BOTTOM: {
                    if (!this.signature.contains(lhs)) {
                        for (OWLDescription desc : rhs) {
                            if (this.bottomEvaluator.isBottomEquivalent(desc, this.signature, SyntacticLocalityEvaluator.this.localityCls)) continue;
                            this.isLocal = false;
                            return;
                        }
                        this.isLocal = true;
                        break;
                    }
                    this.isLocal = false;
                    break;
                }
                case TOP_BOTTOM: 
                case TOP_TOP: {
                    if (!this.signature.contains(rhs)) {
                        boolean bottomEquivDescFound = false;
                        for (OWLDescription desc : rhs) {
                            if (this.bottomEvaluator.isBottomEquivalent(desc, this.signature, SyntacticLocalityEvaluator.this.localityCls)) continue;
                            if (this.topEvaluator.isTopEquivalent(desc, this.signature, SyntacticLocalityEvaluator.this.localityCls)) {
                                if (bottomEquivDescFound) {
                                    this.isLocal = false;
                                    return;
                                }
                                bottomEquivDescFound = true;
                                continue;
                            }
                            this.isLocal = false;
                            return;
                        }
                        this.isLocal = true;
                        break;
                    }
                    this.isLocal = false;
                }
            }
        }

        @Override
        public void visit(OWLEntityAnnotationAxiom axiom) {
            this.isLocal = true;
        }

        @Override
        public void visit(OWLEquivalentClassesAxiom axiom) {
            this.isLocal = true;
            Iterator<OWLDescription> eqs = axiom.getDescriptions().iterator();
            OWLDescription first = eqs.next();
            if (!eqs.hasNext()) {
                return;
            }
            boolean isBottom = this.bottomEvaluator.isBottomEquivalent(first, this.signature, SyntacticLocalityEvaluator.this.localityCls);
            if (!isBottom && !this.topEvaluator.isTopEquivalent(first, this.signature, SyntacticLocalityEvaluator.this.localityCls)) {
                this.isLocal = false;
            }
            if (isBottom) {
                while (this.isLocal && eqs.hasNext()) {
                    OWLDescription next = eqs.next();
                    if (this.bottomEvaluator.isBottomEquivalent(next, this.signature, SyntacticLocalityEvaluator.this.localityCls)) continue;
                    this.isLocal = false;
                }
            } else {
                while (this.isLocal && eqs.hasNext()) {
                    OWLDescription next = eqs.next();
                    if (this.topEvaluator.isTopEquivalent(next, this.signature, SyntacticLocalityEvaluator.this.localityCls)) continue;
                    this.isLocal = false;
                }
            }
        }

        @Override
        public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
            Set eqs = axiom.getProperties();
            int size = eqs.size();
            if (size == 1) {
                this.isLocal = true;
            } else {
                for (OWLDataPropertyExpression p : eqs) {
                    if (!this.signature.contains(p.asOWLDataProperty())) continue;
                    this.isLocal = false;
                    return;
                }
                this.isLocal = true;
            }
        }

        @Override
        public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
            Set eqs = axiom.getProperties();
            int size = eqs.size();
            if (size == 1) {
                this.isLocal = true;
            } else {
                for (OWLObjectPropertyExpression p : eqs) {
                    if (!this.signature.contains(p.getNamedProperty())) continue;
                    this.isLocal = false;
                    return;
                }
                this.isLocal = true;
            }
        }

        @Override
        public void visit(OWLFunctionalDataPropertyAxiom axiom) {
            switch (SyntacticLocalityEvaluator.this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isLocal = !this.signature.contains(((OWLDataPropertyExpression)axiom.getProperty()).asOWLDataProperty());
                    break;
                }
                case TOP_TOP: {
                    this.isLocal = false;
                }
            }
        }

        @Override
        public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
            switch (SyntacticLocalityEvaluator.this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isLocal = !this.signature.contains(((OWLObjectPropertyExpression)axiom.getProperty()).getNamedProperty());
                    break;
                }
                case TOP_TOP: {
                    this.isLocal = false;
                }
            }
        }

        @Override
        public void visit(OWLImportsDeclaration axiom) {
            this.isLocal = false;
        }

        @Override
        public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
            switch (SyntacticLocalityEvaluator.this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isLocal = !this.signature.contains(((OWLObjectPropertyExpression)axiom.getProperty()).getNamedProperty());
                    break;
                }
                case TOP_TOP: {
                    this.isLocal = false;
                }
            }
        }

        @Override
        public void visit(OWLInverseObjectPropertiesAxiom axiom) {
            this.isLocal = !this.signature.contains(axiom.getFirstProperty().getNamedProperty()) && !this.signature.contains(axiom.getSecondProperty().getNamedProperty());
        }

        @Override
        public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
            switch (SyntacticLocalityEvaluator.this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isLocal = true;
                    break;
                }
                case TOP_TOP: {
                    this.isLocal = false;
                }
            }
        }

        @Override
        public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
            switch (SyntacticLocalityEvaluator.this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isLocal = !this.signature.contains(((OWLDataPropertyExpression)axiom.getProperty()).asOWLDataProperty());
                    break;
                }
                case TOP_TOP: {
                    this.isLocal = false;
                }
            }
        }

        @Override
        public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
            switch (SyntacticLocalityEvaluator.this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isLocal = !this.signature.contains(((OWLObjectPropertyExpression)axiom.getProperty()).getNamedProperty());
                    break;
                }
                case TOP_TOP: {
                    this.isLocal = false;
                }
            }
        }

        @Override
        public void visit(OWLObjectPropertyAssertionAxiom axiom) {
            switch (SyntacticLocalityEvaluator.this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isLocal = false;
                    break;
                }
                case TOP_TOP: {
                    this.isLocal = !this.signature.contains(((OWLObjectPropertyExpression)axiom.getProperty()).getNamedProperty());
                }
            }
        }

        @Override
        public void visit(OWLObjectPropertyChainSubPropertyAxiom axiom) {
            switch (SyntacticLocalityEvaluator.this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    for (OWLObjectPropertyExpression ope : axiom.getPropertyChain()) {
                        if (this.signature.contains(ope.getNamedProperty())) continue;
                        this.isLocal = true;
                        return;
                    }
                    this.isLocal = false;
                    break;
                }
                case TOP_TOP: {
                    this.isLocal = !this.signature.contains(axiom.getSuperProperty().getNamedProperty());
                }
            }
        }

        @Override
        public void visit(OWLObjectPropertyDomainAxiom axiom) {
            switch (SyntacticLocalityEvaluator.this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isLocal = !this.signature.contains(((OWLObjectPropertyExpression)axiom.getProperty()).getNamedProperty()) || this.topEvaluator.isTopEquivalent(axiom.getDomain(), this.signature, SyntacticLocalityEvaluator.this.localityCls);
                    break;
                }
                case TOP_TOP: {
                    this.isLocal = this.topEvaluator.isTopEquivalent(axiom.getDomain(), this.signature, SyntacticLocalityEvaluator.this.localityCls);
                }
            }
        }

        @Override
        public void visit(OWLObjectPropertyRangeAxiom axiom) {
            switch (SyntacticLocalityEvaluator.this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isLocal = !this.signature.contains(((OWLObjectPropertyExpression)axiom.getProperty()).getNamedProperty()) || this.topEvaluator.isTopEquivalent((OWLDescription)axiom.getRange(), this.signature, SyntacticLocalityEvaluator.this.localityCls);
                    break;
                }
                case TOP_TOP: {
                    this.isLocal = this.topEvaluator.isTopEquivalent((OWLDescription)axiom.getRange(), this.signature, SyntacticLocalityEvaluator.this.localityCls);
                }
            }
        }

        @Override
        public void visit(OWLObjectSubPropertyAxiom axiom) {
            switch (SyntacticLocalityEvaluator.this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isLocal = !this.signature.contains(((OWLObjectPropertyExpression)axiom.getSubProperty()).getNamedProperty());
                    break;
                }
                case TOP_TOP: {
                    this.isLocal = !this.signature.contains(((OWLObjectPropertyExpression)axiom.getSuperProperty()).getNamedProperty());
                }
            }
        }

        @Override
        public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
            this.isLocal = !this.signature.contains(((OWLObjectPropertyExpression)axiom.getProperty()).getNamedProperty());
        }

        @Override
        public void visit(OWLOntologyAnnotationAxiom axiom) {
            this.isLocal = true;
        }

        @Override
        public void visit(OWLSameIndividualsAxiom axiom) {
            this.isLocal = true;
        }

        @Override
        public void visit(OWLSubClassAxiom axiom) {
            this.isLocal = this.bottomEvaluator.isBottomEquivalent(axiom.getSubClass(), this.signature, SyntacticLocalityEvaluator.this.localityCls) || this.topEvaluator.isTopEquivalent(axiom.getSuperClass(), this.signature, SyntacticLocalityEvaluator.this.localityCls);
        }

        @Override
        public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
            this.isLocal = !this.signature.contains(((OWLObjectPropertyExpression)axiom.getProperty()).getNamedProperty());
        }

        @Override
        public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
            this.isLocal = !this.signature.contains(((OWLObjectPropertyExpression)axiom.getProperty()).getNamedProperty());
        }

        @Override
        public void visit(SWRLRule axiom) {
            this.isLocal = false;
        }
    }
}

