/*
 * Decompiled with CFR 0.152.
 */
package edu.unika.aifb.rdf.api.syntax;

import edu.unika.aifb.rdf.api.syntax.RDFConsumer;
import edu.unika.aifb.rdf.api.syntax.RDFParserException;
import edu.unika.aifb.rdf.api.util.RDFConstants;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.LocatorImpl;

public class RDFParser
extends DefaultHandler
implements RDFConstants {
    protected static final Locator s_nullDocumentLocator = new LocatorImpl();
    protected static final SAXParserFactory s_parserFactory = SAXParserFactory.newInstance();
    protected ErrorHandler m_errorHandler;
    protected Stack m_baseURIs;
    protected URI m_baseURI;
    protected Stack m_languages;
    protected String m_language;
    protected RDFConsumer m_consumer;
    protected State m_state;
    protected List m_states = new ArrayList();
    protected int m_generatedURIIndex;
    protected Locator m_documentLocator;

    public RDFParser() {
        this.m_baseURIs = new Stack();
        this.m_languages = new Stack();
    }

    public void parse(InputSource source, RDFConsumer consumer) throws SAXException, IOException {
        String systemID = source.getSystemId();
        try {
            this.m_documentLocator = s_nullDocumentLocator;
            if (systemID == null) {
                throw new SAXException("Supplied InputSource object myst have systemId property set, which is needed for URI resolution.");
            }
            this.m_baseURI = new URI(source.getSystemId());
            this.m_consumer = consumer;
            this.m_consumer.startModel(this.m_baseURI.toString());
            SAXParser parser = s_parserFactory.newSAXParser();
            parser.parse(source, (DefaultHandler)this);
            this.m_consumer.endModel();
        }
        catch (ParserConfigurationException e) {
            throw new SAXException("Parser coniguration exception", e);
        }
        catch (URISyntaxException e) {
            throw new SAXException("Invalid SystemID '" + systemID + "'of the supplied input source.");
        }
        finally {
            this.m_state = null;
            this.m_states.clear();
            this.m_documentLocator = null;
            this.m_baseURIs.clear();
        }
    }

    public void setDocumentLocator(Locator locator) {
        this.m_documentLocator = locator;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.m_errorHandler = errorHandler;
    }

    public void warning(SAXParseException e) throws SAXException {
        if (this.m_errorHandler == null) {
            super.warning(e);
        } else {
            this.m_errorHandler.warning(e);
        }
    }

    public void error(SAXParseException e) throws SAXException {
        if (this.m_errorHandler == null) {
            super.error(e);
        } else {
            this.m_errorHandler.error(e);
        }
    }

    public void fatalError(SAXParseException e) throws SAXException {
        if (this.m_errorHandler == null) {
            super.fatalError(e);
        } else {
            this.m_errorHandler.fatalError(e);
        }
    }

    public void startDocument() {
        this.m_generatedURIIndex = 0;
        this.m_states.clear();
        this.pushState(new StartRDF());
    }

    public void endDocument() throws SAXException {
        if (this.m_state != null) {
            throw new RDFParserException("RDF content not finished.", this.m_documentLocator);
        }
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.processXMLBase(atts);
        this.processXMLLanguage(atts);
        this.m_state.startElement(namespaceURI, localName, qName, atts);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.m_state.endElement(namespaceURI, localName, qName);
        this.m_baseURI = (URI)this.m_baseURIs.pop();
        this.m_language = (String)this.m_languages.pop();
    }

    public void characters(char[] data, int start, int length) throws SAXException {
        this.m_state.characters(data, start, length);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if ("include-rdf".equals(target)) {
            Map arguments = this.parseStringArguments(data);
            if (arguments.size() > 2) {
                throw new RDFParserException("Incorrect number of arguments for 'include-rdf' processing instruction.", this.m_documentLocator);
            }
            String logicalURI = (String)arguments.get("logicalURI");
            String physicalURI = (String)arguments.get("physicalURI");
            if (physicalURI != null) {
                physicalURI = this.resolveURI(physicalURI);
            }
            this.m_consumer.includeModel(logicalURI, physicalURI);
        } else if ("model-attribute".equals(target)) {
            Map arguments = this.parseStringArguments(data);
            if (arguments.size() != 2) {
                throw new RDFParserException("Incorrect number of arguments for 'model-attribute' processing instruction.", this.m_documentLocator);
            }
            String key = (String)arguments.get("key");
            if (key == null) {
                throw new RDFParserException("Mising the 'key' argument for 'model-attribute' processing instruction.", this.m_documentLocator);
            }
            String value = (String)arguments.get("value");
            if (value == null) {
                throw new RDFParserException("Mising the 'value' argument for 'model-attribute' processing instruction.", this.m_documentLocator);
            }
            this.m_consumer.addModelAttribte(key, value);
        }
    }

    protected void pushState(State state) {
        this.m_states.add(state);
        this.m_state = state;
    }

    protected void popState() throws SAXException {
        int size = this.m_states.size();
        if (size == 0) {
            throw new RDFParserException("Internal exception: state stack is empty.", this.m_documentLocator);
        }
        this.m_state = size == 1 ? null : (State)this.m_states.get(size - 2);
        this.m_states.remove(size - 1);
    }

    protected void checkUnsupportedAttributes(Attributes atts) throws SAXException {
        if (atts.getIndex("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "aboutEach") != -1) {
            throw new RDFParserException("rdf:aboutEach attribute is not supported.", this.m_documentLocator);
        }
        if (atts.getIndex("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "aboutEachPrefix") != -1) {
            throw new RDFParserException("rdf:aboutEachPrefix attribute is not supported.", this.m_documentLocator);
        }
    }

    protected void processXMLBase(Attributes atts) throws SAXException {
        this.m_baseURIs.push(this.m_baseURI);
        String value = atts.getValue("http://www.w3.org/XML/1998/namespace", "base");
        if (value != null) {
            try {
                this.m_baseURI = this.m_baseURI.resolve(value);
            }
            catch (IllegalArgumentException e) {
                RDFParserException exception = new RDFParserException("New base URI '" + value + "' cannot be resolved against curent base URI " + this.m_baseURI.toString(), this.m_documentLocator);
                exception.initCause(e);
                throw exception;
            }
        }
    }

    protected void processXMLLanguage(Attributes atts) {
        this.m_languages.push(this.m_language);
        String value = atts.getValue("xml:lang");
        if (value != null) {
            this.m_language = value;
        }
    }

    protected String resolveURI(String uri) throws SAXException {
        if (uri.length() == 0) {
            String base = this.m_baseURI.toString();
            int hashIndex = base.indexOf("#");
            if (hashIndex != -1) {
                return base.substring(0, hashIndex);
            }
            return base;
        }
        try {
            return this.m_baseURI.resolve(uri).toString();
        }
        catch (IllegalArgumentException e) {
            RDFParserException exception = new RDFParserException("URI '" + uri + "' cannot be resolved against curent base URI " + this.m_baseURI.toString(), this.m_documentLocator);
            exception.initCause(e);
            throw exception;
        }
    }

    protected String getURIFromID(String id) throws SAXException {
        return this.resolveURI("#" + id);
    }

    protected String getURIFromAbout(String about) throws SAXException {
        return this.resolveURI(about);
    }

    protected String getURIFromNodeID(String nodeID) throws SAXException {
        return this.resolveURI("#genid-" + nodeID);
    }

    protected String getURIFromResource(String resource) throws SAXException {
        return this.resolveURI(resource);
    }

    protected String nextAnonymousURI() throws SAXException {
        return this.getURIFromID("genid" + ++this.m_generatedURIIndex);
    }

    protected String getIDNodeIDAboutResourceURI(Attributes atts) throws SAXException {
        String result = null;
        String value = atts.getValue("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "ID");
        if (value != null) {
            result = this.getURIFromID(value);
        }
        if ((value = atts.getValue("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "about")) != null) {
            if (result != null) {
                throw new RDFParserException("Element cannot specify both rdf:ID and rdf:about attributes.", this.m_documentLocator);
            }
            result = this.getURIFromAbout(value);
        }
        if ((value = atts.getValue("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "nodeID")) != null) {
            if (result != null) {
                throw new RDFParserException("Element cannot specify both rdf:nodeID and rdf:ID or rdf:about attributes.", this.m_documentLocator);
            }
            result = this.getURIFromNodeID(value);
        }
        if (result == null) {
            result = this.nextAnonymousURI();
        }
        return result;
    }

    protected String getNodeIDResourceResourceURI(Attributes atts) throws SAXException {
        String value = atts.getValue("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "resource");
        if (value != null) {
            return this.getURIFromResource(value);
        }
        value = atts.getValue("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "nodeID");
        if (value != null) {
            return this.getURIFromNodeID(value);
        }
        return null;
    }

    protected void statementWithResourceValue(String subject, String predicate, String object, String reificationID) throws SAXException {
        this.m_consumer.statementWithResourceValue(subject, predicate, object);
        if (reificationID != null) {
            this.m_consumer.statementWithResourceValue(reificationID, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", "http://www.w3.org/1999/02/22-rdf-syntax-ns#statement");
            this.m_consumer.statementWithResourceValue(reificationID, "http://www.w3.org/1999/02/22-rdf-syntax-ns#subject", subject);
            this.m_consumer.statementWithResourceValue(reificationID, "http://www.w3.org/1999/02/22-rdf-syntax-ns#predicate", predicate);
            this.m_consumer.statementWithResourceValue(reificationID, "http://www.w3.org/1999/02/22-rdf-syntax-ns#object", object);
        }
    }

    protected void statementWithLiteralValue(String subject, String predicate, String object, String dataType, String reificationID) throws SAXException {
        this.m_consumer.statementWithLiteralValue(subject, predicate, object, this.m_language, dataType);
        if (reificationID != null) {
            this.m_consumer.statementWithResourceValue(reificationID, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", "http://www.w3.org/1999/02/22-rdf-syntax-ns#statement");
            this.m_consumer.statementWithResourceValue(reificationID, "http://www.w3.org/1999/02/22-rdf-syntax-ns#subject", subject);
            this.m_consumer.statementWithResourceValue(reificationID, "http://www.w3.org/1999/02/22-rdf-syntax-ns#predicate", predicate);
            this.m_consumer.statementWithLiteralValue(reificationID, "http://www.w3.org/1999/02/22-rdf-syntax-ns#object", object, this.m_language, dataType);
        }
    }

    protected void propertyAttributes(String subjectURI, Attributes atts, ReificationManager reificationManager) throws SAXException {
        int length = atts.getLength();
        for (int i = 0; i < length; ++i) {
            String reificationID;
            String value;
            String nsURI = atts.getURI(i);
            String localName = atts.getLocalName(i);
            if (!("http://www.w3.org/XML/1998/namespace".equals(nsURI) || "xml:lang".equals(localName) || "http://www.w3.org/1999/02/22-rdf-syntax-ns#".equals(nsURI) && ("ID".equals(localName) || "nodeID".equals(localName) || "about".equals(localName) || "type".equals(localName) || "resource".equals(localName) || "parseType".equals(localName) || "aboutEach".equals(localName) || "aboutEachPrefix".equals(localName) || "bagID".equals(localName)))) {
                value = atts.getValue(i);
                reificationID = reificationManager.getReificationID(null);
                this.statementWithLiteralValue(subjectURI, nsURI + localName, value, null, reificationID);
                continue;
            }
            if (!"http://www.w3.org/1999/02/22-rdf-syntax-ns#".equals(nsURI) || !"type".equals(localName)) continue;
            value = this.resolveURI(atts.getValue(i));
            reificationID = reificationManager.getReificationID(null);
            this.statementWithResourceValue(subjectURI, nsURI + localName, value, reificationID);
        }
    }

    protected boolean isWhitespaceOnly(char[] data, int start, int length) {
        int end = start + length;
        for (int i = start; i < end; ++i) {
            char c = data[i];
            if (c == '\n' || c == '\r' || c == '\t' || c == ' ') continue;
            return false;
        }
        return true;
    }

    protected boolean isWhitespaceOnly(StringBuffer buffer) {
        for (int i = 0; i < buffer.length(); ++i) {
            char c = buffer.charAt(i);
            if (c == '\n' || c == '\r' || c == '\t' || c == ' ') continue;
            return false;
        }
        return true;
    }

    protected ReificationManager getReificationManager(Attributes atts) throws SAXException {
        String bagIDAttr = atts.getValue("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "bagID");
        if (bagIDAttr == null) {
            return ReificationManager.INSTANCE;
        }
        String bagID = this.getURIFromID(bagIDAttr);
        return new ReifiedStatementBag(bagID);
    }

    protected Map parseStringArguments(String string) throws SAXException {
        try {
            StreamTokenizer tokenizer = new StreamTokenizer(new StringReader(string));
            HashMap<String, String> result = new HashMap<String, String>();
            tokenizer.nextToken();
            while (tokenizer.ttype != -1) {
                if (tokenizer.ttype != -3) {
                    throw new RDFParserException("Invalid processing instruction argument.", this.m_documentLocator);
                }
                String name = tokenizer.sval;
                if (61 != tokenizer.nextToken()) {
                    throw new RDFParserException("Expecting token =", this.m_documentLocator);
                }
                tokenizer.nextToken();
                if (tokenizer.ttype != 34 && tokenizer.ttype != 39) {
                    throw new RDFParserException("Invalid processing instruction argument.", this.m_documentLocator);
                }
                String value = tokenizer.sval;
                result.put(name, value);
                tokenizer.nextToken();
            }
            return result;
        }
        catch (IOException e) {
            RDFParserException exception = new RDFParserException("I/O error", this.m_documentLocator);
            exception.initCause(e);
            throw exception;
        }
    }

    public boolean isAnonymousNodeURI(String uri) {
        return uri.indexOf("#genid") != -1;
    }

    static {
        s_parserFactory.setNamespaceAware(true);
    }

    protected class ReifiedStatementBag
    extends ReificationManager {
        protected String m_uri;
        protected int m_elements;

        public ReifiedStatementBag(String uri) throws SAXException {
            this.m_uri = uri;
            this.m_elements = 0;
            RDFParser.this.statementWithResourceValue(this.m_uri, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", "http://www.w3.org/1999/02/22-rdf-syntax-ns#Bag", null);
        }

        public String getReificationID(String reificationID) throws SAXException {
            String resultURI = reificationID == null ? RDFParser.this.nextAnonymousURI() : reificationID;
            RDFParser.this.statementWithResourceValue(this.m_uri, "http://www.w3.org/1999/02/22-rdf-syntax-ns#_" + ++this.m_elements, resultURI, null);
            return resultURI;
        }
    }

    protected static class ReificationManager {
        public static ReificationManager INSTANCE = new ReificationManager();

        protected ReificationManager() {
        }

        public String getReificationID(String reificationID) throws SAXException {
            return reificationID;
        }
    }

    protected class ParseTypeResourcePropertyElement
    extends State {
        protected NodeElement m_nodeElement;
        protected String m_propertyURI;
        protected String m_reificationID;

        public ParseTypeResourcePropertyElement(NodeElement nodeElement) {
            this.m_nodeElement = nodeElement;
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            this.m_propertyURI = this.m_nodeElement.getPropertyURI(namespaceURI + localName);
            this.m_reificationID = this.m_nodeElement.getReificationID(atts);
            NodeElement anonymousNodeElement = new NodeElement();
            anonymousNodeElement.startDummyElement(atts);
            RDFParser.this.statementWithResourceValue(this.m_nodeElement.getSubjectURI(), this.m_propertyURI, anonymousNodeElement.getSubjectURI(), this.m_reificationID);
            RDFParser.this.pushState(new PropertyElementList(anonymousNodeElement));
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            RDFParser.this.popState();
        }

        public void characters(char[] data, int start, int length) throws SAXException {
            if (!RDFParser.this.isWhitespaceOnly(data, start, length)) {
                throw new RDFParserException("Cannot process characters when object properties are excepted.", RDFParser.this.m_documentLocator);
            }
        }
    }

    protected class ParseTypeLiteralPropertyElement
    extends State {
        protected NodeElement m_nodeElement;
        protected String m_propertyURI;
        protected String m_reificationID;
        protected int m_depth;
        protected StringBuffer m_content;

        public ParseTypeLiteralPropertyElement(NodeElement nodeElement) {
            this.m_nodeElement = nodeElement;
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            if (this.m_depth == 0) {
                this.m_propertyURI = this.m_nodeElement.getPropertyURI(namespaceURI + localName);
                this.m_reificationID = this.m_nodeElement.getReificationID(atts);
                this.m_content = new StringBuffer();
            } else {
                this.m_content.append('<');
                this.m_content.append(qName);
                int length = atts.getLength();
                for (int i = 0; i < length; ++i) {
                    this.m_content.append(' ');
                    this.m_content.append(atts.getQName(i));
                    this.m_content.append("=\"");
                    this.m_content.append(atts.getValue(i));
                    this.m_content.append("\"");
                }
                this.m_content.append(">");
            }
            ++this.m_depth;
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (this.m_depth == 1) {
                RDFParser.this.statementWithLiteralValue(this.m_nodeElement.getSubjectURI(), this.m_propertyURI, this.m_content.toString(), "http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral", this.m_reificationID);
                RDFParser.this.popState();
            } else {
                this.m_content.append("</");
                this.m_content.append(qName);
                this.m_content.append(">");
            }
            --this.m_depth;
        }

        public void characters(char[] data, int start, int length) {
            this.m_content.append(data, start, length);
        }
    }

    protected class ParseTypeCollectionPropertyElement
    extends State {
        protected NodeElement m_nodeElement;
        protected String m_propertyURI;
        protected String m_reificationID;
        protected String m_lastCellURI;

        public ParseTypeCollectionPropertyElement(NodeElement nodeElement) {
            this.m_nodeElement = nodeElement;
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            if (this.m_propertyURI == null) {
                this.m_propertyURI = this.m_nodeElement.getPropertyURI(namespaceURI + localName);
                this.m_reificationID = this.m_nodeElement.getReificationID(atts);
            } else {
                NodeElement collectionNode = new NodeElement();
                RDFParser.this.pushState(collectionNode);
                RDFParser.this.m_state.startElement(namespaceURI, localName, qName, atts);
                String newListCellURI = this.listCell(collectionNode.getSubjectURI());
                if (this.m_lastCellURI == null) {
                    RDFParser.this.statementWithResourceValue(this.m_nodeElement.getSubjectURI(), this.m_propertyURI, newListCellURI, this.m_reificationID);
                } else {
                    RDFParser.this.statementWithResourceValue(this.m_lastCellURI, "http://www.w3.org/1999/02/22-rdf-syntax-ns#rest", newListCellURI, null);
                }
                this.m_lastCellURI = newListCellURI;
            }
        }

        protected String listCell(String valueURI) throws SAXException {
            String listCellURI = RDFParser.this.nextAnonymousURI();
            RDFParser.this.statementWithResourceValue(listCellURI, "http://www.w3.org/1999/02/22-rdf-syntax-ns#first", valueURI, null);
            RDFParser.this.statementWithResourceValue(listCellURI, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", "http://www.w3.org/1999/02/22-rdf-syntax-ns#List", null);
            return listCellURI;
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (this.m_lastCellURI == null) {
                RDFParser.this.statementWithResourceValue(this.m_nodeElement.getSubjectURI(), this.m_propertyURI, "http://www.w3.org/1999/02/22-rdf-syntax-ns#nil", this.m_reificationID);
            } else {
                RDFParser.this.statementWithResourceValue(this.m_lastCellURI, "http://www.w3.org/1999/02/22-rdf-syntax-ns#rest", "http://www.w3.org/1999/02/22-rdf-syntax-ns#nil", null);
            }
            RDFParser.this.popState();
        }

        public void characters(char[] data, int start, int length) throws SAXException {
            if (!RDFParser.this.isWhitespaceOnly(data, start, length)) {
                throw new RDFParserException("Expecting an object element instead of character content.", RDFParser.this.m_documentLocator);
            }
        }
    }

    protected class EmptyPropertyElement
    extends State {
        protected NodeElement m_nodeElement;
        protected String m_propertyURI;

        public EmptyPropertyElement(NodeElement nodeElement) {
            this.m_nodeElement = nodeElement;
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            String objectURI;
            String reificationID;
            if (this.m_propertyURI == null) {
                this.m_propertyURI = this.m_nodeElement.getPropertyURI(namespaceURI + localName);
                reificationID = this.m_nodeElement.getReificationID(atts);
                objectURI = RDFParser.this.getNodeIDResourceResourceURI(atts);
                if (objectURI == null) {
                    objectURI = RDFParser.this.nextAnonymousURI();
                }
            } else {
                throw new RDFParserException("incorrect element start encountered.", RDFParser.this.m_documentLocator);
            }
            RDFParser.this.statementWithResourceValue(this.m_nodeElement.getSubjectURI(), this.m_propertyURI, objectURI, reificationID);
            ReificationManager reificationManager = RDFParser.this.getReificationManager(atts);
            RDFParser.this.propertyAttributes(objectURI, atts, reificationManager);
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            RDFParser.this.popState();
        }

        public void characters(char[] data, int start, int length) throws SAXException {
            throw new RDFParserException("Characters were not excepted.", RDFParser.this.m_documentLocator);
        }
    }

    protected class ResourceOrLiteralPropertyElement
    extends State {
        protected NodeElement m_nodeElement;
        protected String m_propertyURI;
        protected String m_reificationID;
        protected String m_datatype;
        protected StringBuffer m_text;
        protected NodeElement m_innerNode;

        public ResourceOrLiteralPropertyElement(NodeElement nodeElement) {
            this.m_nodeElement = nodeElement;
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            if (this.m_text == null) {
                this.m_propertyURI = this.m_nodeElement.getPropertyURI(namespaceURI + localName);
                this.m_reificationID = this.m_nodeElement.getReificationID(atts);
                this.m_datatype = atts.getValue("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "datatype");
                this.m_text = new StringBuffer();
            } else {
                if (!RDFParser.this.isWhitespaceOnly(this.m_text)) {
                    throw new RDFParserException("Text was seen and new node is started.", RDFParser.this.m_documentLocator);
                }
                if (this.m_datatype != null) {
                    throw new RDFParserException("rdf:datatype specified on a node with resource value.", RDFParser.this.m_documentLocator);
                }
                this.m_innerNode = new NodeElement();
                RDFParser.this.pushState(this.m_innerNode);
                RDFParser.this.m_state.startElement(namespaceURI, localName, qName, atts);
            }
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (this.m_innerNode != null) {
                RDFParser.this.statementWithResourceValue(this.m_nodeElement.getSubjectURI(), this.m_propertyURI, this.m_innerNode.getSubjectURI(), this.m_reificationID);
            } else {
                RDFParser.this.statementWithLiteralValue(this.m_nodeElement.getSubjectURI(), this.m_propertyURI, this.m_text.toString().trim(), this.m_datatype, this.m_reificationID);
            }
            RDFParser.this.popState();
        }

        public void characters(char[] data, int start, int length) throws SAXException {
            if (this.m_innerNode != null) {
                if (!RDFParser.this.isWhitespaceOnly(data, start, length)) {
                    throw new RDFParserException("Cannot process characters when object properties are excepted.", RDFParser.this.m_documentLocator);
                }
            } else {
                this.m_text.append(data, start, length);
            }
        }
    }

    protected class PropertyElementList
    extends State {
        protected NodeElement m_nodeElement;

        public PropertyElementList(NodeElement nodeElement) {
            this.m_nodeElement = nodeElement;
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            String parseType = atts.getValue("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "parseType");
            if ("Literal".equals(parseType)) {
                RDFParser.this.pushState(new ParseTypeLiteralPropertyElement(this.m_nodeElement));
            } else if ("Resource".equals(parseType)) {
                RDFParser.this.pushState(new ParseTypeResourcePropertyElement(this.m_nodeElement));
            } else if ("Collection".equals(parseType)) {
                RDFParser.this.pushState(new ParseTypeCollectionPropertyElement(this.m_nodeElement));
            } else if (parseType != null) {
                RDFParser.this.pushState(new ParseTypeLiteralPropertyElement(this.m_nodeElement));
            } else {
                String objectURI = RDFParser.this.getNodeIDResourceResourceURI(atts);
                if (objectURI != null) {
                    RDFParser.this.pushState(new EmptyPropertyElement(this.m_nodeElement));
                } else {
                    RDFParser.this.pushState(new ResourceOrLiteralPropertyElement(this.m_nodeElement));
                }
            }
            RDFParser.this.m_state.startElement(namespaceURI, localName, qName, atts);
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            RDFParser.this.popState();
            RDFParser.this.m_state.endElement(namespaceURI, localName, qName);
        }

        public void characters(char[] data, int start, int length) throws SAXException {
            if (!RDFParser.this.isWhitespaceOnly(data, start, length)) {
                throw new RDFParserException("Cannot process characters when object properties are excepted.", RDFParser.this.m_documentLocator);
            }
        }
    }

    protected class NodeElement
    extends State {
        protected String m_subjectURI;
        protected ReificationManager m_reificationManager;
        protected int m_nextLi = 1;

        protected NodeElement() {
        }

        public void startDummyElement(Attributes atts) throws SAXException {
            this.m_subjectURI = RDFParser.this.nextAnonymousURI();
            this.m_reificationManager = RDFParser.this.getReificationManager(atts);
        }

        public String getSubjectURI() {
            return this.m_subjectURI;
        }

        public String getReificationID(Attributes atts) throws SAXException {
            String rdfID = atts.getValue("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "ID");
            if (rdfID != null) {
                rdfID = RDFParser.this.getURIFromID(rdfID);
            }
            return this.m_reificationManager.getReificationID(rdfID);
        }

        public String getNextLi() {
            return "http://www.w3.org/1999/02/22-rdf-syntax-ns#_" + this.m_nextLi++;
        }

        public String getPropertyURI(String uri) {
            if ("http://www.w3.org/1999/02/22-rdf-syntax-ns#li".equals(uri)) {
                return this.getNextLi();
            }
            return uri;
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            this.m_subjectURI = RDFParser.this.getIDNodeIDAboutResourceURI(atts);
            boolean isRDFNS = "http://www.w3.org/1999/02/22-rdf-syntax-ns#".equals(namespaceURI);
            this.m_reificationManager = RDFParser.this.getReificationManager(atts);
            if (!isRDFNS || !"Description".equals(localName)) {
                RDFParser.this.statementWithResourceValue(this.m_subjectURI, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", namespaceURI + localName, this.m_reificationManager.getReificationID(null));
            }
            RDFParser.this.checkUnsupportedAttributes(atts);
            RDFParser.this.propertyAttributes(this.m_subjectURI, atts, this.m_reificationManager);
            RDFParser.this.pushState(new PropertyElementList(this));
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            RDFParser.this.popState();
        }

        public void characters(char[] data, int start, int length) throws SAXException {
            if (!RDFParser.this.isWhitespaceOnly(data, start, length)) {
                throw new RDFParserException("Cannot process characters when node is excepted.", RDFParser.this.m_documentLocator);
            }
        }
    }

    protected class NodeElementList
    extends State {
        protected NodeElementList() {
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            RDFParser.this.pushState(new NodeElement());
            RDFParser.this.m_state.startElement(namespaceURI, localName, qName, atts);
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            RDFParser.this.popState();
            RDFParser.this.m_state.endElement(namespaceURI, localName, qName);
        }

        public void characters(char[] data, int start, int length) throws SAXException {
            if (!RDFParser.this.isWhitespaceOnly(data, start, length)) {
                throw new RDFParserException("Expecting an object element instead of character content.", RDFParser.this.m_documentLocator);
            }
        }
    }

    protected class StartRDF
    extends State {
        protected StartRDF() {
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            if (!"http://www.w3.org/1999/02/22-rdf-syntax-ns#".equals(namespaceURI) || !"RDF".equals(localName)) {
                throw new RDFParserException("Expecting rdf:RDF element.", RDFParser.this.m_documentLocator);
            }
            RDFParser.this.m_consumer.logicalURI(RDFParser.this.m_baseURI.toString());
            RDFParser.this.pushState(new NodeElementList());
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            RDFParser.this.popState();
        }

        public void characters(char[] data, int start, int length) throws SAXException {
            if (!RDFParser.this.isWhitespaceOnly(data, start, length)) {
                throw new RDFParserException("Expecting rdf:rdf element instead of character content.", RDFParser.this.m_documentLocator);
            }
        }
    }

    protected static class State {
        protected State() {
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        }

        public void characters(char[] data, int start, int length) throws SAXException {
        }
    }
}

