/*
 * Decompiled with CFR 0.152.
 */
package org.coode.obo.renderer;

import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.coode.obo.parser.OBOVocabulary;
import org.coode.obo.renderer.OBOExceptionHandler;
import org.coode.obo.renderer.OBORelationship;
import org.coode.obo.renderer.OBORelationshipGenerator;
import org.coode.obo.renderer.OBOStorageException;
import org.coode.obo.renderer.OBOStorageIncompleteException;
import org.coode.obo.renderer.OBOTagValuePairList;
import org.semanticweb.owl.io.AbstractOWLRenderer;
import org.semanticweb.owl.io.OWLRendererException;
import org.semanticweb.owl.model.OWLAnnotation;
import org.semanticweb.owl.model.OWLAnnotationAxiom;
import org.semanticweb.owl.model.OWLAxiomAnnotationAxiom;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLClassAxiom;
import org.semanticweb.owl.model.OWLConstant;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataPropertyExpression;
import org.semanticweb.owl.model.OWLDataRange;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLDisjointClassesAxiom;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLImportsDeclaration;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLObjectIntersectionOf;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyChainSubPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLObjectUnionOf;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyAnnotationAxiom;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.model.OWLProperty;
import org.semanticweb.owl.model.OWLPropertyExpression;
import org.semanticweb.owl.model.OWLRestriction;
import org.semanticweb.owl.model.OWLSubClassAxiom;
import org.semanticweb.owl.model.SWRLRule;
import org.semanticweb.owl.util.NamespaceUtil;
import org.semanticweb.owl.util.SimpleShortFormProvider;
import org.semanticweb.owl.util.VersionInfo;
import org.semanticweb.owl.vocab.OWLRDFVocabulary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OBOFlatFileRenderer
extends AbstractOWLRenderer
implements OBOExceptionHandler {
    private OBORelationshipGenerator relationshipHandler;
    private SimpleShortFormProvider sfp;
    private String defaultPrefix;
    private List<OBOStorageException> exceptions = new ArrayList<OBOStorageException>();
    private NamespaceUtil nsUtil;
    private String defaultNamespace;

    protected OBOFlatFileRenderer(OWLOntologyManager owlOntologyManager) {
        super(owlOntologyManager);
        this.relationshipHandler = new OBORelationshipGenerator(this);
        this.sfp = new SimpleShortFormProvider();
    }

    @Override
    public void render(OWLOntology ontology, Writer writer) throws OWLRendererException {
        this.exceptions.clear();
        String ontURIStr = ontology.getURI().toString();
        this.defaultNamespace = ontURIStr.endsWith("/") ? ontURIStr : ontURIStr + "#";
        this.nsUtil = new NamespaceUtil();
        this.defaultPrefix = this.nsUtil.getPrefix(this.defaultNamespace);
        this.writeHeader(ontology, writer);
        this.writeStanzas(ontology, writer);
        if (!this.exceptions.isEmpty()) {
            throw new OBOStorageIncompleteException(this.exceptions);
        }
    }

    @Override
    public void addException(OBOStorageException exception) {
        this.exceptions.add(exception);
    }

    @Override
    public List<OBOStorageException> getExceptions() {
        return this.exceptions;
    }

    private void writeHeader(OWLOntology ontology, Writer writer) throws OWLRendererException {
        OBOTagValuePairList tvpList = new OBOTagValuePairList(OBOVocabulary.getHeaderTags());
        tvpList.setDefault(OBOVocabulary.DEFAULT_NAMESPACE, this.defaultPrefix);
        for (OWLOntologyAnnotationAxiom ax : ontology.getAnnotations(ontology)) {
            if (ax.getAnnotation().getAnnotationURI().equals(OWLRDFVocabulary.RDFS_COMMENT.getURI())) {
                tvpList.addPair(OBOVocabulary.REMARK, ax.getAnnotation().getAnnotationValueAsConstant().getLiteral());
                continue;
            }
            tvpList.visit(ax);
        }
        for (OWLImportsDeclaration importDecl : ontology.getImportsDeclarations()) {
            tvpList.addPair(OBOVocabulary.IMPORT, importDecl.getImportedOntologyURI().toString());
        }
        Map<String, String> namespace2PrefixMap = this.loadUsedNamespaces(ontology);
        for (String namespace : namespace2PrefixMap.keySet()) {
            String mapping = namespace2PrefixMap.get(namespace) + " " + namespace;
            tvpList.addPair(OBOVocabulary.ID_SPACE, mapping);
        }
        tvpList.setPair(OBOVocabulary.FORMAT_VERSION, "1.2");
        tvpList.setPair(OBOVocabulary.DATE, this.getTimestampFormatter().format(new Date(System.currentTimeMillis())));
        tvpList.setPair(OBOVocabulary.SAVED_BY, System.getProperty("user.name"));
        tvpList.setPair(OBOVocabulary.AUTO_GENERATED_BY, VersionInfo.getVersionInfo().toString());
        tvpList.write(writer);
    }

    private Map<String, String> loadUsedNamespaces(OWLOntology ontology) {
        for (OWLEntity entity : ontology.getReferencedEntities()) {
            String[] pair = new String[2];
            this.nsUtil.split(entity.getURI().toString(), pair);
            URI base = URI.create(pair[0]);
            this.nsUtil.getPrefix(base.toString());
        }
        return this.nsUtil.getNamespace2PrefixMap();
    }

    private void writeStanzas(OWLOntology ontology, Writer writer) {
        this.write("\n\n! ----------------------  CLASSES  -------------------------\n", writer);
        ArrayList<OWLClass> sortedClasses = new ArrayList<OWLClass>(ontology.getReferencedClasses());
        Collections.sort(sortedClasses);
        for (OWLClass cls : sortedClasses) {
            this.writeTermStanza(cls, ontology, writer);
        }
        this.write("\n\n! ----------------------  PROPERTIES  -------------------------\n", writer);
        ArrayList<OWLObjectProperty> objProps = new ArrayList<OWLObjectProperty>(ontology.getReferencedObjectProperties());
        Collections.sort(objProps);
        for (OWLObjectProperty property : objProps) {
            this.writeTypeDefStanza(property, ontology, writer);
        }
        ArrayList<OWLDataProperty> dataProps = new ArrayList<OWLDataProperty>(ontology.getReferencedDataProperties());
        Collections.sort(dataProps);
        for (OWLDataProperty property : dataProps) {
            this.writeTypeDefStanza(property, ontology, writer);
        }
        this.write("\n\n! ----------------------  INSTANCES  -------------------------\n", writer);
        ArrayList<OWLIndividual> individuals = new ArrayList<OWLIndividual>(ontology.getReferencedIndividuals());
        Collections.sort(individuals);
        for (OWLIndividual oWLIndividual : individuals) {
            this.writeInstanceStanza(oWLIndividual, ontology, writer);
        }
        block4: for (OWLClassAxiom oWLClassAxiom : ontology.getClassAxioms()) {
            if (oWLClassAxiom instanceof OWLSubClassAxiom && ((OWLSubClassAxiom)oWLClassAxiom).isGCI()) {
                this.exceptions.add(new OBOStorageException(oWLClassAxiom, null, "Superclass GCI found in ontology cannot be translated to OBO"));
                continue;
            }
            if (oWLClassAxiom instanceof OWLEquivalentClassesAxiom && ((OWLEquivalentClassesAxiom)oWLClassAxiom).getNamedClasses().isEmpty()) {
                this.exceptions.add(new OBOStorageException(oWLClassAxiom, null, "Equivalent class GCI found in ontology cannot be translated to OBO"));
                continue;
            }
            if (!(oWLClassAxiom instanceof OWLDisjointClassesAxiom)) continue;
            for (OWLDescription op : ((OWLDisjointClassesAxiom)oWLClassAxiom).getDescriptions()) {
                if (!op.isAnonymous()) continue;
                this.exceptions.add(new OBOStorageException(oWLClassAxiom, null, "Disjoint axiom contains anonymous classes - cannot be translated to OBO"));
                continue block4;
            }
        }
        for (SWRLRule sWRLRule : ontology.getRules()) {
            this.exceptions.add(new OBOStorageException(sWRLRule, null, "SWRL rules cannot be translated to OBO"));
        }
        for (OWLAnnotationAxiom oWLAnnotationAxiom : ontology.getAnnotationAxioms()) {
            if (!(oWLAnnotationAxiom instanceof OWLAxiomAnnotationAxiom)) continue;
            this.exceptions.add(new OBOStorageException(oWLAnnotationAxiom, null, "Axiom annotations cannot currently be translated to OBO"));
        }
    }

    private void writeTermStanza(OWLClass cls, OWLOntology ontology, Writer writer) {
        this.write("\n[", writer);
        this.write(OBOVocabulary.TERM.getName(), writer);
        this.write("]\n", writer);
        OBOTagValuePairList tvpList = new OBOTagValuePairList(OBOVocabulary.getTermStanzaTags());
        this.handleEntityBase(cls, ontology, tvpList);
        this.relationshipHandler.setClass(cls);
        for (OWLDescription superCls : cls.getSuperClasses(ontology)) {
            if (!superCls.isAnonymous()) {
                String superclassID = this.getID(superCls.asOWLClass());
                tvpList.addPair(OBOVocabulary.IS_A, superclassID);
                continue;
            }
            if (superCls instanceof OWLRestriction) {
                superCls.accept(this.relationshipHandler);
                continue;
            }
            this.exceptions.add(new OBOStorageException(cls, superCls, "OBO format only supports named superclass or someValuesFrom restrictions"));
        }
        OWLClass owlThing = this.getOWLOntologyManager().getOWLDataFactory().getOWLThing();
        if (!cls.equals(owlThing) && tvpList.getValues(OBOVocabulary.IS_A).isEmpty()) {
            tvpList.addPair(OBOVocabulary.IS_A, this.getID(owlThing));
        }
        for (OWLDescription equiv : cls.getEquivalentClasses(ontology)) {
            if (equiv instanceof OWLObjectIntersectionOf) {
                this.handleIntersection(cls, (OWLObjectIntersectionOf)equiv, tvpList);
                continue;
            }
            if (equiv instanceof OWLObjectUnionOf) {
                this.handleUnion(cls, (OWLObjectUnionOf)equiv, tvpList);
                continue;
            }
            if (equiv instanceof OWLRestriction) {
                OWLObjectIntersectionOf intersection = this.getOWLOntologyManager().getOWLDataFactory().getOWLObjectIntersectionOf(owlThing, equiv);
                this.handleIntersection(cls, intersection, tvpList);
                continue;
            }
            this.exceptions.add(new OBOStorageException(cls, equiv, "Cannot process equivalent class that is not intersection or union"));
        }
        for (OWLDescription disjoint : cls.getDisjointClasses(ontology)) {
            if (!disjoint.isAnonymous()) {
                tvpList.addPair(OBOVocabulary.DISJOINT_FROM, this.getID(disjoint.asOWLClass()));
                continue;
            }
            this.exceptions.add(new OBOStorageException(cls, disjoint, "Found anonymous disjoint class that cannot be represented in OBO"));
        }
        for (OBORelationship relationship : this.relationshipHandler.getOBORelationships()) {
            this.handleRelationship(relationship, tvpList);
        }
        tvpList.write(writer);
    }

    private void handleIntersection(OWLClass cls, OWLObjectIntersectionOf intersectionOf, OBOTagValuePairList tvpList) {
        for (OWLDescription op : intersectionOf.getOperands()) {
            if (!op.isAnonymous()) {
                tvpList.addPair(OBOVocabulary.INTERSECTION_OF, this.getID(op.asOWLClass()));
                continue;
            }
            this.relationshipHandler.setClass(cls);
            op.accept(this.relationshipHandler);
            Set<OBORelationship> relations = this.relationshipHandler.getOBORelationships();
            if (!relations.isEmpty()) {
                OBORelationship rel = relations.iterator().next();
                tvpList.addPair(OBOVocabulary.INTERSECTION_OF, this.renderRestriction(rel));
                continue;
            }
            this.exceptions.add(new OBOStorageException(cls, op, "Found operand in intersection that cannot be represented"));
        }
    }

    private String renderRestriction(OBORelationship rel) {
        StringBuilder sb = new StringBuilder(this.getID(rel.getProperty()));
        sb.append(" ");
        sb.append(this.getID(rel.getFiller()));
        return sb.toString();
    }

    private void handleUnion(OWLClass cls, OWLObjectUnionOf union, OBOTagValuePairList tvpList) {
        for (OWLDescription op : union.getOperands()) {
            if (!op.isAnonymous()) {
                tvpList.addPair(OBOVocabulary.UNION_OF, this.getID(op.asOWLClass()));
                continue;
            }
            this.relationshipHandler.setClass(cls);
            op.accept(this.relationshipHandler);
            Set<OBORelationship> relations = this.relationshipHandler.getOBORelationships();
            if (!relations.isEmpty()) {
                OBORelationship rel = relations.iterator().next();
                tvpList.addPair(OBOVocabulary.UNION_OF, this.renderRestriction(rel));
                continue;
            }
            this.exceptions.add(new OBOStorageException(cls, op, "Found operand in union that cannot be represented"));
        }
    }

    private void handleRelationship(OBORelationship relationship, OBOTagValuePairList tvpList) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.renderRestriction(relationship));
        if (relationship.getCardinality() >= 0) {
            sb.append(OBOVocabulary.CARDINALITY.getName());
            sb.append(":");
            sb.append(Integer.toString(relationship.getCardinality()));
            sb.append("\n");
        }
        if (relationship.getMaxCardinality() >= 0) {
            sb.append(OBOVocabulary.MAX_CARDINALITY.getName());
            sb.append(":");
            sb.append(Integer.toString(relationship.getMaxCardinality()));
            sb.append("\n");
        }
        if (relationship.getMinCardinality() >= 0) {
            sb.append(OBOVocabulary.MIN_CARDINALITY.getName());
            sb.append(":");
            sb.append(Integer.toString(relationship.getMinCardinality()));
            sb.append("\n");
        }
        tvpList.addPair(OBOVocabulary.RELATIONSHIP, sb.toString());
    }

    private <P extends OWLProperty> OBOTagValuePairList handleCommonTypeDefStanza(P property, OWLOntology ontology, Writer writer) {
        this.write("\n[", writer);
        this.write(OBOVocabulary.TYPEDEF.getName(), writer);
        this.write("]\n", writer);
        OBOTagValuePairList tvpList = new OBOTagValuePairList(OBOVocabulary.getTypeDefStanzaTags());
        this.handleEntityBase(property, ontology, tvpList);
        Set<OWLDescription> domains = property.getDomains(ontology);
        for (OWLDescription domain : domains) {
            if (!domain.isAnonymous()) {
                tvpList.addPair(OBOVocabulary.DOMAIN, this.getID(domain.asOWLClass()));
                continue;
            }
            this.exceptions.add(new OBOStorageException(property, domain, "Anonymous domain that cannot be represented in OBO"));
        }
        Set sp = property.getSuperProperties(ontology);
        for (OWLPropertyExpression superProp : sp) {
            if (!superProp.isAnonymous()) {
                tvpList.addPair(OBOVocabulary.IS_A, this.getID((OWLProperty)superProp));
                continue;
            }
            this.exceptions.add(new OBOStorageException(property, superProp, "Anonymous property in superProperty is not supported in OBO"));
        }
        tvpList.setDefault(OBOVocabulary.IS_METADATA_TAG, "false");
        return tvpList;
    }

    private void writeTypeDefStanza(OWLObjectProperty property, OWLOntology ontology, Writer writer) {
        OBOTagValuePairList tvpList = this.handleCommonTypeDefStanza(property, ontology, writer);
        for (OWLDescription range : property.getRanges(ontology)) {
            if (!range.isAnonymous()) {
                tvpList.addPair(OBOVocabulary.RANGE, this.getID(range.asOWLClass()));
                continue;
            }
            this.exceptions.add(new OBOStorageException(property, range, "Anonymous range that cannot be represented in OBO"));
        }
        if (property.isAsymmetric(ontology)) {
            tvpList.addPair(OBOVocabulary.IS_ANTI_SYMMETRIC, "true");
        }
        if (property.isReflexive(ontology)) {
            tvpList.addPair(OBOVocabulary.IS_REFLEXIVE, "true");
        }
        if (property.isSymmetric(ontology)) {
            tvpList.addPair(OBOVocabulary.IS_SYMMETRIC, "true");
        }
        if (property.isTransitive(ontology)) {
            tvpList.addPair(OBOVocabulary.IS_TRANSITIVE, "true");
        }
        for (OWLObjectPropertyExpression inv : property.getInverses(ontology)) {
            if (!inv.isAnonymous()) {
                tvpList.addPair(OBOVocabulary.INVERSE, this.getID(inv.asOWLObjectProperty()));
                continue;
            }
            this.exceptions.add(new OBOStorageException(property, inv, "Anonymous property in inverse is not supported in OBO"));
        }
        for (OWLObjectPropertyChainSubPropertyAxiom ax : ontology.getPropertyChainSubPropertyAxioms()) {
            if (!ax.getSuperProperty().equals(property)) continue;
            List<OWLObjectPropertyExpression> chain = ax.getPropertyChain();
            if (chain.size() == 2 && chain.get(0).equals(property) && !chain.get(1).isAnonymous()) {
                tvpList.addPair(OBOVocabulary.TRANSITIVE_OVER, this.getID(chain.get(1).asOWLObjectProperty()));
                continue;
            }
            this.exceptions.add(new OBOStorageException(property, ax, "Only property chains of form 'p o q -> p' supported"));
        }
        tvpList.write(writer);
    }

    private void writeTypeDefStanza(OWLDataProperty property, OWLOntology ontology, Writer writer) {
        OBOTagValuePairList tvpList = this.handleCommonTypeDefStanza(property, ontology, writer);
        for (OWLDataRange range : property.getRanges(ontology)) {
            if (range.isDataType()) {
                tvpList.addPair(OBOVocabulary.RANGE, range.asOWLDataType().getURI().toString());
                continue;
            }
            this.exceptions.add(new OBOStorageException(property, range, "Complex data range cannot be represented in OBO"));
        }
        tvpList.write(writer);
    }

    private void writeInstanceStanza(OWLIndividual individual, OWLOntology ontology, Writer writer) {
        this.write("\n[", writer);
        this.write(OBOVocabulary.INSTANCE.getName(), writer);
        this.write("]\n", writer);
        OBOTagValuePairList tvpList = new OBOTagValuePairList(OBOVocabulary.getInstanceStanzaTags());
        if (individual.isAnonymous()) {
            tvpList.setDefault(OBOVocabulary.IS_ANONYMOUS, "true");
        }
        this.handleEntityBase(individual, ontology, tvpList);
        for (OWLDescription type : individual.getTypes(ontology)) {
            if (!type.isAnonymous()) {
                tvpList.addPair(OBOVocabulary.INSTANCE_OF, this.getID(type.asOWLClass()));
                continue;
            }
            this.exceptions.add(new OBOStorageException(individual, type, "Complex types cannot be represented in OBO"));
        }
        Map<OWLObjectPropertyExpression, Set<OWLIndividual>> objPropAssertions = individual.getObjectPropertyValues(ontology);
        for (OWLObjectPropertyExpression p : objPropAssertions.keySet()) {
            if (!p.isAnonymous()) {
                for (OWLIndividual ind : objPropAssertions.get(p)) {
                    String rel = this.renderRestriction(new OBORelationship(p.asOWLObjectProperty(), ind));
                    tvpList.addPair(OBOVocabulary.PROPERTY_VALUE, rel);
                }
                continue;
            }
            this.exceptions.add(new OBOStorageException(individual, p, "Anonymous property in assertion is not supported in OBO"));
        }
        Map<OWLDataPropertyExpression, Set<OWLConstant>> dataPropAssertions = individual.getDataPropertyValues(ontology);
        for (OWLDataPropertyExpression p : dataPropAssertions.keySet()) {
            if (!p.isAnonymous()) {
                for (OWLConstant constant : dataPropAssertions.get(p)) {
                    String rel = this.renderPropertyAssertion(p.asOWLDataProperty(), constant);
                    tvpList.addPair(OBOVocabulary.PROPERTY_VALUE, rel);
                }
                continue;
            }
            this.exceptions.add(new OBOStorageException(individual, p, "Anonymous property in assertion is not supported in OBO"));
        }
        tvpList.write(writer);
    }

    private void handleEntityBase(OWLEntity entity, OWLOntology ontology, OBOTagValuePairList tvpList) {
        tvpList.addPair(OBOVocabulary.ID, this.getID(entity));
        HashSet<OWLAnnotation> potentialNames = new HashSet<OWLAnnotation>();
        for (OWLAnnotation oWLAnnotation : entity.getAnnotations(ontology)) {
            if (oWLAnnotation.getAnnotationURI().equals(OWLRDFVocabulary.RDFS_LABEL.getURI())) {
                potentialNames.add(oWLAnnotation);
                continue;
            }
            if (oWLAnnotation.getAnnotationURI().equals(OWLRDFVocabulary.RDFS_COMMENT.getURI())) {
                tvpList.addPair(OBOVocabulary.COMMENT, oWLAnnotation.getAnnotationValueAsConstant().getLiteral());
                continue;
            }
            tvpList.visit(oWLAnnotation);
        }
        if (tvpList.getValues(OBOVocabulary.NAME).isEmpty()) {
            if (!potentialNames.isEmpty()) {
                OWLAnnotation firstLabel = (OWLAnnotation)potentialNames.iterator().next();
                tvpList.addPair(OBOVocabulary.NAME, firstLabel.getAnnotationValueAsConstant().getLiteral());
                potentialNames.remove(firstLabel);
            } else {
                tvpList.addPair(OBOVocabulary.NAME, this.getID(entity));
            }
        }
        for (OWLAnnotation<Object> oWLAnnotation : potentialNames) {
            tvpList.visit(oWLAnnotation);
        }
        String uri = entity.getURI().toString();
        if (!uri.startsWith(this.defaultNamespace)) {
            String[] stringArray = new String[2];
            this.nsUtil.split(uri, stringArray);
            URI base = URI.create(stringArray[0]);
            String prefix = this.nsUtil.getPrefix(base.toString());
            tvpList.setDefault(OBOVocabulary.NAMESPACE, prefix);
        }
    }

    private String renderPropertyAssertion(OWLDataProperty property, OWLConstant constant) {
        StringBuilder sb = new StringBuilder(this.getID(property));
        sb.append(" \"");
        sb.append(constant.getLiteral());
        sb.append("\" ");
        if (constant.isTyped()) {
            sb.append(constant.asOWLTypedConstant().getDataType().getURI());
        }
        return sb.toString();
    }

    private String getID(OWLEntity entity) {
        return this.sfp.getShortForm(entity);
    }

    private void write(String s, Writer writer) {
        try {
            writer.write(s);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private DateFormat getTimestampFormatter() {
        SimpleDateFormat sdf = new SimpleDateFormat();
        sdf.applyPattern("dd:MM:yyyy HH:mm");
        return sdf;
    }
}

