/*
 * Decompiled with CFR 0.152.
 */
package org.coode.obo.renderer;

import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.coode.obo.parser.OBOVocabulary;
import org.semanticweb.owl.model.OWLAnnotation;
import org.semanticweb.owl.model.OWLAnnotationAxiom;
import org.semanticweb.owl.util.SimpleURIShortFormProvider;
import org.semanticweb.owl.util.URIShortFormProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OBOTagValuePairList {
    private Map<String, Set<String>> knownTVPs = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> unknownTVPs = new HashMap<String, Set<String>>();
    private List<OBOVocabulary> vocab;
    private URIShortFormProvider uriSFP;
    private Map<URI, String> defaults = new HashMap<URI, String>();
    private Writer writer;

    public OBOTagValuePairList(List<OBOVocabulary> knownVocab) {
        this.vocab = knownVocab;
        this.uriSFP = new SimpleURIShortFormProvider();
    }

    public void visit(OWLAnnotationAxiom annotAx) {
        this.visit(annotAx.getAnnotation());
    }

    public void visit(OWLAnnotation annot) {
        this.addPair(annot.getAnnotationURI(), annot.getAnnotationValueAsConstant().getLiteral());
    }

    public void addPair(OBOVocabulary tag, String value) {
        this.addPair(tag.getURI(), value);
    }

    public void addPair(URI tag, String value) {
        boolean found = false;
        for (OBOVocabulary obo : this.vocab) {
            if (!tag.equals(obo.getURI())) continue;
            this.addPair(obo.getName(), value, this.knownTVPs);
            found = true;
            break;
        }
        if (!found) {
            String name = this.uriSFP.getShortForm(tag);
            this.addPair(name, value, this.unknownTVPs);
        }
    }

    public void setPair(OBOVocabulary key, String value) {
        this.knownTVPs.remove(key.getName());
        this.addPair(key.getURI(), value);
    }

    public void setDefault(OBOVocabulary tag, String value) {
        this.defaults.put(tag.getURI(), value);
    }

    public void setDefault(URI tag, String value) {
        this.defaults.put(tag, value);
    }

    public Set<String> getValues(OBOVocabulary key) {
        Set values = this.knownTVPs.get(key.getName());
        if (values == null) {
            values = Collections.EMPTY_SET;
        }
        return values;
    }

    private void addPair(String tag, String value, Map<String, Set<String>> map) {
        Set<String> set = map.get(tag);
        if (set == null) {
            set = new HashSet<String>(1);
            map.put(tag, set);
        }
        set.add(value);
    }

    public void write(Writer writer) {
        this.writer = writer;
        for (OBOVocabulary tag : this.vocab) {
            String def;
            Set<String> values = this.knownTVPs.get(tag.getName());
            if (values == null && (def = this.defaults.get(tag.getURI())) != null) {
                values = Collections.singleton(def);
            }
            if (values == null) continue;
            for (String value : values) {
                this.writeTagValuePair(tag, value);
            }
        }
        for (String unknownTag : this.unknownTVPs.keySet()) {
            for (String value : this.unknownTVPs.get(unknownTag)) {
                this.writeTagValuePair(unknownTag, value);
            }
        }
    }

    private void writeTagValuePair(OBOVocabulary key, String value) {
        this.writeTagValuePair(key.getName(), value);
    }

    private void writeTagValuePair(String key, String value) {
        if (key != null && value != null) {
            this.write(key);
            this.write(": ");
            this.write(value);
            this.writeNewLine();
        }
    }

    private void writeNewLine() {
        this.write("\n");
    }

    private void write(String s) {
        try {
            this.writer.write(s);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

