/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owl.latex;

import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDataAllRestriction;
import org.semanticweb.owl.model.OWLDataCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataExactCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataMaxCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataMinCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataSomeRestriction;
import org.semanticweb.owl.model.OWLDataValueRestriction;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLDescriptionVisitor;
import org.semanticweb.owl.model.OWLObjectAllRestriction;
import org.semanticweb.owl.model.OWLObjectCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectComplementOf;
import org.semanticweb.owl.model.OWLObjectExactCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectIntersectionOf;
import org.semanticweb.owl.model.OWLObjectMaxCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectMinCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectOneOf;
import org.semanticweb.owl.model.OWLObjectSelfRestriction;
import org.semanticweb.owl.model.OWLObjectSomeRestriction;
import org.semanticweb.owl.model.OWLObjectUnionOf;
import org.semanticweb.owl.model.OWLObjectValueRestriction;

public class LatexBracketChecker
implements OWLDescriptionVisitor {
    private boolean requiresBracket;
    private static LatexBracketChecker instance;

    private LatexBracketChecker() {
    }

    public void visit(OWLObjectIntersectionOf node) {
        this.requiresBracket = true;
    }

    public void visit(OWLDataAllRestriction node) {
        this.requiresBracket = true;
    }

    public void visit(OWLDataCardinalityRestriction node) {
        this.requiresBracket = true;
    }

    public void visit(OWLDataSomeRestriction node) {
        this.requiresBracket = true;
    }

    public void visit(OWLDataValueRestriction node) {
        this.requiresBracket = true;
    }

    public void visit(OWLObjectAllRestriction node) {
        this.requiresBracket = true;
    }

    public void visit(OWLObjectCardinalityRestriction node) {
        this.requiresBracket = true;
    }

    public void visit(OWLObjectSomeRestriction node) {
        this.requiresBracket = true;
    }

    public void visit(OWLObjectValueRestriction node) {
        this.requiresBracket = true;
    }

    public void visit(OWLObjectComplementOf node) {
        this.requiresBracket = false;
    }

    public void visit(OWLObjectUnionOf node) {
        this.requiresBracket = true;
    }

    public void visit(OWLClass node) {
        this.requiresBracket = false;
    }

    public void visit(OWLObjectOneOf node) {
        this.requiresBracket = node.getIndividuals().size() != 1;
    }

    public void visit(OWLDataExactCardinalityRestriction desc) {
        this.requiresBracket = true;
    }

    public void visit(OWLDataMaxCardinalityRestriction desc) {
        this.requiresBracket = true;
    }

    public void visit(OWLDataMinCardinalityRestriction desc) {
        this.requiresBracket = true;
    }

    public void visit(OWLObjectExactCardinalityRestriction desc) {
        this.requiresBracket = true;
    }

    public void visit(OWLObjectMaxCardinalityRestriction desc) {
        this.requiresBracket = true;
    }

    public void visit(OWLObjectMinCardinalityRestriction desc) {
        this.requiresBracket = true;
    }

    public void visit(OWLObjectSelfRestriction owlSelfRestriction) {
        this.requiresBracket = true;
    }

    public static boolean requiresBracket(OWLDescription description) {
        if (instance == null) {
            instance = new LatexBracketChecker();
        }
        LatexBracketChecker.instance.requiresBracket = true;
        description.accept(instance);
        return LatexBracketChecker.instance.requiresBracket;
    }
}

