/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owl.latex;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.coode.owl.latex.LatexBracketChecker;
import org.coode.owl.latex.LatexWriter;
import org.semanticweb.owl.model.OWLAntiSymmetricObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLAxiomAnnotationAxiom;
import org.semanticweb.owl.model.OWLCardinalityRestriction;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLClassAssertionAxiom;
import org.semanticweb.owl.model.OWLConstant;
import org.semanticweb.owl.model.OWLConstantAnnotation;
import org.semanticweb.owl.model.OWLDataAllRestriction;
import org.semanticweb.owl.model.OWLDataComplementOf;
import org.semanticweb.owl.model.OWLDataExactCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDataMaxCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataMinCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataOneOf;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLDataPropertyExpression;
import org.semanticweb.owl.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLDataRange;
import org.semanticweb.owl.model.OWLDataRangeFacetRestriction;
import org.semanticweb.owl.model.OWLDataRangeRestriction;
import org.semanticweb.owl.model.OWLDataSomeRestriction;
import org.semanticweb.owl.model.OWLDataSubPropertyAxiom;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLDataValueRestriction;
import org.semanticweb.owl.model.OWLDeclarationAxiom;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owl.model.OWLDisjointClassesAxiom;
import org.semanticweb.owl.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owl.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLDisjointUnionAxiom;
import org.semanticweb.owl.model.OWLEntityAnnotationAxiom;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owl.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owl.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLImportsDeclaration;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLObject;
import org.semanticweb.owl.model.OWLObjectAllRestriction;
import org.semanticweb.owl.model.OWLObjectAnnotation;
import org.semanticweb.owl.model.OWLObjectComplementOf;
import org.semanticweb.owl.model.OWLObjectExactCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectIntersectionOf;
import org.semanticweb.owl.model.OWLObjectMaxCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectMinCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectOneOf;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyChainSubPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLObjectPropertyInverse;
import org.semanticweb.owl.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLObjectSelfRestriction;
import org.semanticweb.owl.model.OWLObjectSomeRestriction;
import org.semanticweb.owl.model.OWLObjectSubPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectUnionOf;
import org.semanticweb.owl.model.OWLObjectValueRestriction;
import org.semanticweb.owl.model.OWLObjectVisitor;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyAnnotationAxiom;
import org.semanticweb.owl.model.OWLPropertyRange;
import org.semanticweb.owl.model.OWLQuantifiedRestriction;
import org.semanticweb.owl.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLSameIndividualsAxiom;
import org.semanticweb.owl.model.OWLSubClassAxiom;
import org.semanticweb.owl.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLTypedConstant;
import org.semanticweb.owl.model.OWLUntypedConstant;
import org.semanticweb.owl.model.SWRLAtomConstantObject;
import org.semanticweb.owl.model.SWRLAtomDVariable;
import org.semanticweb.owl.model.SWRLAtomIVariable;
import org.semanticweb.owl.model.SWRLAtomIndividualObject;
import org.semanticweb.owl.model.SWRLBuiltInAtom;
import org.semanticweb.owl.model.SWRLClassAtom;
import org.semanticweb.owl.model.SWRLDataRangeAtom;
import org.semanticweb.owl.model.SWRLDataValuedPropertyAtom;
import org.semanticweb.owl.model.SWRLDifferentFromAtom;
import org.semanticweb.owl.model.SWRLObjectPropertyAtom;
import org.semanticweb.owl.model.SWRLRule;
import org.semanticweb.owl.model.SWRLSameAsAtom;
import org.semanticweb.owl.util.CollectionFactory;
import org.semanticweb.owl.util.ShortFormProvider;
import org.semanticweb.owl.util.SimpleShortFormProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LatexObjectVisitor
implements OWLObjectVisitor {
    public static final String AND = "\\sqcap";
    public static final String OR = "\\sqcup";
    public static final String NOT = "\\lnot";
    public static final String ALL = "\\forall\\,";
    public static final String SOME = "\\exists\\,";
    public static final String MIN = "\\mathnormal{\\geq}\\,";
    public static final String MAX = "\\mathnormal{\\leq}\\,";
    public static final String EQUAL = "\\mathnormal{=}\\,";
    public static final String SUBCLASS = "\\sqsubseteq";
    public static final String EQUIV = "\\equiv";
    public static final String NOT_EQUAL = "\\not=";
    public static final String TOP = "\\top";
    public static final String BOTTOM = "\\bot";
    public static final String SELF = "\\self";
    public static final String CIRC = "\\circ";
    private OWLObject subject;
    private LatexWriter writer;
    private boolean prettyPrint = true;
    private OWLDataFactory df;
    private ShortFormProvider shortFormProvider;

    public LatexObjectVisitor(LatexWriter writer, OWLDataFactory df) {
        this.writer = writer;
        this.df = df;
        this.shortFormProvider = new SimpleShortFormProvider();
        this.subject = df.getOWLThing();
    }

    public void setSubject(OWLObject subject) {
        this.subject = subject;
    }

    public void setShortFormProvider(ShortFormProvider shortFormProvder) {
        this.shortFormProvider = shortFormProvder;
    }

    private void writeSpace() {
        this.writer.writeSpace();
    }

    private void write(int i) {
        this.writer.write(Integer.toString(i));
        this.writer.write("\\,");
    }

    private void write(Object o) {
        this.writer.write(o);
    }

    private void writeOpenBrace() {
        this.writer.writeOpenBrace();
    }

    private void writeCloseBrace() {
        this.writer.writeCloseBrace();
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    @Override
    public void visit(OWLObjectIntersectionOf node) {
        Iterator<OWLDescription> it = node.getOperands().iterator();
        while (it.hasNext()) {
            it.next().accept(this);
            if (!it.hasNext()) continue;
            this.writeSpace();
            this.write(AND);
            this.writeSpace();
        }
    }

    private void writeQuantified(OWLQuantifiedRestriction quantifiedRestriction, String quantifier) {
        this.write(quantifier);
        this.writeSpace();
        quantifiedRestriction.getProperty().accept(this);
        if (quantifiedRestriction.isQualified()) {
            this.write(".");
            this.writeNested((OWLPropertyRange)quantifiedRestriction.getFiller());
        }
    }

    private void writeCardinality(OWLCardinalityRestriction cardinalityRestriction, String quantifier) {
        this.write(quantifier);
        this.writeSpace();
        this.write(cardinalityRestriction.getCardinality());
        cardinalityRestriction.getProperty().accept(this);
        if (cardinalityRestriction.isQualified()) {
            this.write(".");
            this.writeNested((OWLPropertyRange)cardinalityRestriction.getFiller());
        }
    }

    @Override
    public void visit(OWLDataAllRestriction node) {
        this.writeQuantified(node, ALL);
    }

    @Override
    public void visit(OWLDataExactCardinalityRestriction desc) {
        this.writeCardinality(desc, EQUAL);
    }

    @Override
    public void visit(OWLDataMaxCardinalityRestriction desc) {
        this.writeCardinality(desc, MAX);
    }

    @Override
    public void visit(OWLDataMinCardinalityRestriction desc) {
        this.writeCardinality(desc, MIN);
    }

    @Override
    public void visit(OWLDataSomeRestriction node) {
        this.writeQuantified(node, SOME);
    }

    @Override
    public void visit(OWLDataValueRestriction node) {
        node.asSomeValuesFrom().accept(this);
    }

    @Override
    public void visit(OWLObjectAllRestriction node) {
        this.writeQuantified(node, ALL);
    }

    @Override
    public void visit(OWLObjectExactCardinalityRestriction desc) {
        this.writeCardinality(desc, EQUAL);
    }

    @Override
    public void visit(OWLObjectMaxCardinalityRestriction desc) {
        this.writeCardinality(desc, MAX);
    }

    @Override
    public void visit(OWLObjectMinCardinalityRestriction desc) {
        this.writeCardinality(desc, MIN);
    }

    @Override
    public void visit(OWLObjectSomeRestriction node) {
        this.writeQuantified(node, SOME);
    }

    @Override
    public void visit(OWLObjectValueRestriction node) {
        node.asSomeValuesFrom().accept(this);
    }

    @Override
    public void visit(OWLObjectComplementOf node) {
        this.write(NOT);
        this.writeNested(node.getOperand());
    }

    @Override
    public void visit(OWLObjectUnionOf node) {
        Iterator<OWLDescription> it = node.getOperands().iterator();
        while (it.hasNext()) {
            it.next().accept(this);
            if (!it.hasNext()) continue;
            this.writeSpace();
            this.write(OR);
            this.writeSpace();
        }
    }

    @Override
    public void visit(OWLClass node) {
        if (node.isOWLThing()) {
            this.write(TOP);
        } else if (node.isOWLNothing()) {
            this.write(BOTTOM);
        } else {
            this.write("\\class{");
            this.write(this.escapeName(this.shortFormProvider.getShortForm(node)));
            this.write("}");
        }
    }

    @Override
    public void visit(OWLObjectOneOf node) {
        Iterator<OWLIndividual> it = node.getIndividuals().iterator();
        while (it.hasNext()) {
            this.writeOpenBrace();
            it.next().accept(this);
            this.writeCloseBrace();
            if (!it.hasNext()) continue;
            this.writeSpace();
            this.write(OR);
            this.writeSpace();
        }
    }

    @Override
    public void visit(OWLDataProperty entity) {
        this.write("\\dataproperty{");
        this.write(this.escapeName(this.shortFormProvider.getShortForm(entity)));
        this.write("}");
    }

    @Override
    public void visit(OWLObjectProperty entity) {
        this.write("\\objectproperty{");
        this.write(this.escapeName(this.shortFormProvider.getShortForm(entity)));
        this.write("}");
    }

    @Override
    public void visit(OWLIndividual entity) {
        this.write("\\individual{");
        this.write(this.escapeName(this.shortFormProvider.getShortForm(entity)));
        this.write("}");
    }

    @Override
    public void visit(OWLObjectSelfRestriction desc) {
        this.write(SOME);
        this.writeSpace();
        ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
        this.writeSpace();
        this.write(SELF);
    }

    @Override
    public void visit(OWLDisjointClassesAxiom axiom) {
        if (axiom.getDescriptions().size() != 2) {
            for (OWLDescription left : axiom.getDescriptions()) {
                for (OWLDescription right : axiom.getDescriptions()) {
                    if (left == right) continue;
                    if (left.equals(this.subject)) {
                        left.accept(this);
                        this.writeSpace();
                        this.write(SUBCLASS);
                        this.writeSpace();
                        this.write(NOT);
                        this.writeSpace();
                        right.accept(this);
                    } else {
                        right.accept(this);
                        this.writeSpace();
                        this.write(SUBCLASS);
                        this.writeSpace();
                        this.write(NOT);
                        this.writeSpace();
                        left.accept(this);
                    }
                    this.writer.writeNewLine();
                }
            }
        } else {
            OWLDescription rhs;
            OWLDescription lhs;
            Iterator<OWLDescription> it = axiom.getDescriptions().iterator();
            OWLDescription descA = it.next();
            OWLDescription descB = it.next();
            if (descA.equals(this.subject)) {
                lhs = descA;
                rhs = descB;
            } else {
                lhs = descB;
                rhs = descA;
            }
            lhs.accept(this);
            this.writeSpace();
            this.write(SUBCLASS);
            this.writeSpace();
            this.write(NOT);
            this.writeSpace();
            rhs.accept(this);
        }
    }

    @Override
    public void visit(OWLEquivalentClassesAxiom axiom) {
        if (axiom.getDescriptions().size() > 2) {
            HashSet<Set<OWLDescription>> rendered = new HashSet<Set<OWLDescription>>();
            for (OWLDescription left : axiom.getDescriptions()) {
                for (OWLDescription right : axiom.getDescriptions()) {
                    Set<OWLDescription> cur;
                    if (left == right || rendered.contains(cur = CollectionFactory.createSet(left, right))) continue;
                    rendered.add(cur);
                    left.accept(this);
                    this.writeSpace();
                    this.write(EQUIV);
                    this.writeSpace();
                    right.accept(this);
                }
            }
        } else if (axiom.getDescriptions().size() == 2) {
            OWLDescription rhs;
            OWLDescription lhs;
            Iterator<OWLDescription> it = axiom.getDescriptions().iterator();
            OWLDescription descA = it.next();
            OWLDescription descB = it.next();
            if (this.subject.equals(descA)) {
                lhs = descA;
                rhs = descB;
            } else {
                lhs = descB;
                rhs = descA;
            }
            lhs.accept(this);
            this.writeSpace();
            this.write(EQUIV);
            this.writeSpace();
            rhs.accept(this);
        }
    }

    @Override
    public void visit(OWLSubClassAxiom axiom) {
        this.setPrettyPrint(false);
        axiom.getSubClass().accept(this);
        this.writeSpace();
        this.write(SUBCLASS);
        this.writeSpace();
        axiom.getSuperClass().accept(this);
        this.writeSpace();
        this.setPrettyPrint(true);
    }

    @Override
    public void visit(OWLClassAssertionAxiom axiom) {
        if (axiom.getDescription().isAnonymous()) {
            this.write("(");
        }
        axiom.getDescription().accept(this);
        if (axiom.getDescription().isAnonymous()) {
            this.write("(");
        }
        this.write("(");
        axiom.getIndividual().accept(this);
        this.write(")");
    }

    @Override
    public void visit(OWLAntiSymmetricObjectPropertyAxiom axiom) {
        this.df.getOWLDisjointObjectPropertiesAxiom((OWLObjectPropertyExpression)axiom.getProperty(), ((OWLObjectPropertyExpression)axiom.getProperty()).getInverseProperty());
    }

    @Override
    public void visit(OWLAxiomAnnotationAxiom axiom) {
    }

    @Override
    public void visit(OWLDataPropertyAssertionAxiom axiom) {
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        this.write("(");
        axiom.getSubject().accept(this);
        this.write(", ");
        ((OWLConstant)axiom.getObject()).accept(this);
        this.write(")");
    }

    @Override
    public void visit(OWLDataPropertyDomainAxiom axiom) {
        axiom.asSubClassAxiom().accept(this);
    }

    @Override
    public void visit(OWLDataPropertyRangeAxiom axiom) {
        axiom.asSubClassAxiom().accept(this);
    }

    @Override
    public void visit(OWLDataSubPropertyAxiom axiom) {
        ((OWLDataPropertyExpression)axiom.getSubProperty()).accept(this);
        this.write(SUBCLASS);
        ((OWLDataPropertyExpression)axiom.getSuperProperty()).accept(this);
    }

    @Override
    public void visit(OWLDeclarationAxiom axiom) {
    }

    @Override
    public void visit(OWLDifferentIndividualsAxiom axiom) {
        this.writePairwise(axiom.getIndividuals(), NOT_EQUAL);
    }

    @Override
    public void visit(OWLDisjointDataPropertiesAxiom axiom) {
        this.writePairwiseDisjoint(axiom.getProperties());
    }

    @Override
    public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
        this.writePairwiseDisjoint(axiom.getProperties());
    }

    private void writePairwiseDisjoint(Set<? extends OWLObject> objects) {
        this.writePairwise(objects, "\\sqsubseteq\\lnot");
    }

    private void writePairwise(Set<? extends OWLObject> objects, String delim) {
        ArrayList<? extends OWLObject> list = new ArrayList<OWLObject>(objects);
        for (int i = 0; i < list.size() - 1; ++i) {
            for (int j = i + 1; j < list.size(); ++j) {
                OWLObject o1 = (OWLObject)list.get(i);
                OWLObject o2 = (OWLObject)list.get(j);
                if (o1.equals(this.subject)) {
                    o1.accept(this);
                    this.write(delim);
                    o2.accept(this);
                    this.write(" \\\\ ");
                    continue;
                }
                o2.accept(this);
                this.write(delim);
                o1.accept(this);
                this.write(" \\\\ ");
            }
        }
    }

    @Override
    public void visit(OWLDisjointUnionAxiom axiom) {
    }

    @Override
    public void visit(OWLEntityAnnotationAxiom axiom) {
    }

    @Override
    public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
        this.writePairwise(axiom.getProperties(), EQUIV);
    }

    @Override
    public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        this.writePairwise(axiom.getProperties(), EQUIV);
    }

    @Override
    public void visit(OWLFunctionalDataPropertyAxiom axiom) {
        this.write(TOP);
        this.writeSpace();
        this.write(SUBCLASS);
        this.writeSpace();
        this.df.getOWLDataMaxCardinalityRestriction((OWLDataPropertyExpression)axiom.getProperty(), 1).accept(this);
    }

    @Override
    public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
        this.write(TOP);
        this.writeSpace();
        this.write(SUBCLASS);
        this.writeSpace();
        this.df.getOWLObjectMaxCardinalityRestriction((OWLObjectPropertyExpression)axiom.getProperty(), 1).accept(this);
    }

    @Override
    public void visit(OWLImportsDeclaration axiom) {
    }

    @Override
    public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        this.write(TOP);
        this.writeSpace();
        this.write(SUBCLASS);
        this.writeSpace();
        OWLObjectPropertyInverse prop = this.df.getOWLObjectPropertyInverse((OWLObjectPropertyExpression)axiom.getProperty());
        this.df.getOWLObjectMaxCardinalityRestriction(prop, 1).accept(this);
    }

    @Override
    public void visit(OWLInverseObjectPropertiesAxiom axiom) {
        this.write(axiom.getFirstProperty());
        this.writeSpace();
        this.write(EQUIV);
        this.writeSpace();
        this.write(axiom.getSecondProperty());
        this.write("^-");
    }

    @Override
    public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
    }

    @Override
    public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        this.write(NOT);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        this.write("(");
        axiom.getSubject().accept(this);
        this.write(", ");
        ((OWLConstant)axiom.getObject()).accept(this);
        this.write(")");
    }

    @Override
    public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        this.write(NOT);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.write("(");
        axiom.getSubject().accept(this);
        this.write(", ");
        ((OWLIndividual)axiom.getObject()).accept(this);
        this.write(")");
    }

    @Override
    public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.write("(");
        axiom.getSubject().accept(this);
        this.write(", ");
        ((OWLIndividual)axiom.getObject()).accept(this);
        this.write(")");
    }

    @Override
    public void visit(OWLObjectPropertyChainSubPropertyAxiom axiom) {
        Iterator<OWLObjectPropertyExpression> it = axiom.getPropertyChain().iterator();
        while (it.hasNext()) {
            it.next().accept(this);
            if (!it.hasNext()) continue;
            this.writeSpace();
            this.write(CIRC);
            this.writeSpace();
        }
        this.writeSpace();
        this.write(SUBCLASS);
        this.writeSpace();
        axiom.getSuperProperty().accept(this);
    }

    @Override
    public void visit(OWLObjectPropertyDomainAxiom axiom) {
        axiom.asSubClassAxiom().accept(this);
    }

    @Override
    public void visit(OWLObjectPropertyRangeAxiom axiom) {
        axiom.asSubClassAxiom().accept(this);
    }

    @Override
    public void visit(OWLObjectSubPropertyAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getSubProperty()).accept(this);
        this.writeSpace();
        this.write(SUBCLASS);
        this.writeSpace();
        ((OWLObjectPropertyExpression)axiom.getSuperProperty()).accept(this);
    }

    @Override
    public void visit(OWLOntologyAnnotationAxiom axiom) {
    }

    @Override
    public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
        axiom.asSubClassAxiom().accept(this);
    }

    @Override
    public void visit(OWLSameIndividualsAxiom axiom) {
        this.writePairwise(axiom.getIndividuals(), EQUAL);
    }

    @Override
    public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.writeSpace();
        this.write(EQUIV);
        this.writeSpace();
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.write("^-");
    }

    @Override
    public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.writeSpace();
        this.write(CIRC);
        this.writeSpace();
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.writeSpace();
        this.write(SUBCLASS);
        this.writeSpace();
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(SWRLRule rule) {
    }

    private void writeNested(OWLPropertyRange range) {
        if (range instanceof OWLDataRange) {
            range.accept(this);
        } else {
            this.writeNested((OWLDescription)range);
        }
    }

    private void writeNested(OWLDescription description) {
        this.openBracket(description);
        description.accept(this);
        this.closeBracket(description);
    }

    private void openBracket(OWLDescription description) {
        if (LatexBracketChecker.requiresBracket(description)) {
            this.write("(");
        }
    }

    private void closeBracket(OWLDescription description) {
        if (LatexBracketChecker.requiresBracket(description)) {
            this.write(")");
        }
    }

    private String escapeName(String name) {
        return name.replace("_", "\\_");
    }

    @Override
    public void visit(OWLOntology ontology) {
    }

    @Override
    public void visit(OWLObjectPropertyInverse property) {
        property.getInverse().accept(this);
        this.write("^-");
    }

    @Override
    public void visit(OWLConstantAnnotation annotation) {
    }

    @Override
    public void visit(OWLObjectAnnotation annotation) {
    }

    @Override
    public void visit(OWLDataComplementOf node) {
    }

    @Override
    public void visit(OWLDataOneOf node) {
        Iterator<OWLConstant> it = node.getValues().iterator();
        while (it.hasNext()) {
            this.writeOpenBrace();
            it.next().accept(this);
            this.writeCloseBrace();
            if (!it.hasNext()) continue;
            this.writeSpace();
            this.write(OR);
            this.writeSpace();
        }
    }

    @Override
    public void visit(OWLDataRangeFacetRestriction node) {
    }

    @Override
    public void visit(OWLDataRangeRestriction node) {
    }

    @Override
    public void visit(OWLDataType node) {
        this.write("\\datatype{");
        this.write(this.shortFormProvider.getShortForm(node));
        this.write("}");
    }

    @Override
    public void visit(OWLTypedConstant node) {
        this.writeConstant(node);
    }

    private void writeConstant(OWLConstant node) {
        this.write("\\constant{");
        this.write(node.getLiteral());
        this.write("}");
    }

    @Override
    public void visit(OWLUntypedConstant node) {
        this.writeConstant(node);
    }

    @Override
    public void visit(SWRLAtomConstantObject node) {
    }

    @Override
    public void visit(SWRLAtomDVariable node) {
    }

    @Override
    public void visit(SWRLAtomIndividualObject node) {
    }

    @Override
    public void visit(SWRLAtomIVariable node) {
    }

    @Override
    public void visit(SWRLBuiltInAtom node) {
    }

    @Override
    public void visit(SWRLClassAtom node) {
    }

    @Override
    public void visit(SWRLDataRangeAtom node) {
    }

    @Override
    public void visit(SWRLDataValuedPropertyAtom node) {
    }

    @Override
    public void visit(SWRLDifferentFromAtom node) {
    }

    @Override
    public void visit(SWRLObjectPropertyAtom node) {
    }

    @Override
    public void visit(SWRLSameAsAtom node) {
    }
}

