/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owl.rdfxml.parser;

import java.net.URI;
import org.coode.owl.rdfxml.parser.OWLRDFConsumer;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLConstant;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDataPropertyExpression;
import org.semanticweb.owl.model.OWLDataRange;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;

public class AbstractTripleHandler {
    private OWLRDFConsumer consumer;

    public AbstractTripleHandler(OWLRDFConsumer consumer) {
        this.consumer = consumer;
    }

    public OWLRDFConsumer getConsumer() {
        return this.consumer;
    }

    protected void consumeTriple(URI subject, URI predicate, URI object) throws OWLException {
        this.consumer.consumeTriple(subject, predicate, object);
    }

    protected void consumeTriple(URI subject, URI predicate, OWLConstant object) throws OWLException {
        this.consumer.consumeTriple(subject, predicate, object);
    }

    protected boolean isAnonymous(URI uri) {
        return this.getConsumer().isAnonymousNode(uri);
    }

    protected void addAxiom(OWLAxiom axiom) throws OWLException {
        this.consumer.addAxiom(axiom);
    }

    protected OWLDataFactory getDataFactory() throws OWLException {
        return this.consumer.getDataFactory();
    }

    protected OWLDescription translateDescription(URI uri) throws OWLException {
        return this.consumer.translateDescription(uri);
    }

    protected OWLObjectPropertyExpression translateObjectProperty(URI uri) throws OWLException {
        return this.consumer.translateObjectPropertyExpression(uri);
    }

    protected OWLDataPropertyExpression translateDataProperty(URI uri) throws OWLException {
        return this.consumer.translateDataPropertyExpression(uri);
    }

    protected OWLDataRange translateDataRange(URI uri) throws OWLException {
        return this.consumer.translateDataRange(uri);
    }

    protected OWLIndividual translateIndividual(URI uri) throws OWLException {
        return this.consumer.translateIndividual(uri);
    }
}

