/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owl.rdfxml.parser;

import java.net.URI;
import org.coode.owl.rdfxml.parser.ListItemTranslator;
import org.coode.owl.rdfxml.parser.OWLRDFConsumer;
import org.coode.owl.rdfxml.parser.OWLRDFParserException;
import org.semanticweb.owl.model.OWLConstant;
import org.semanticweb.owl.model.OWLDataRangeFacetRestriction;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLTypedConstant;
import org.semanticweb.owl.util.OWLDataUtil;
import org.semanticweb.owl.vocab.OWLRestrictedDataRangeFacetVocabulary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacetRestrictionListItemTranslator
implements ListItemTranslator<OWLDataRangeFacetRestriction> {
    private OWLRDFConsumer consumer;

    public FacetRestrictionListItemTranslator(OWLRDFConsumer consumer) {
        this.consumer = consumer;
    }

    @Override
    public OWLDataRangeFacetRestriction translate(URI uri) throws OWLException {
        for (OWLRestrictedDataRangeFacetVocabulary facet : OWLRestrictedDataRangeFacetVocabulary.values()) {
            OWLConstant val = this.consumer.getLiteralObject(uri, facet.getURI(), true);
            if (val == null) continue;
            if (val.isTyped()) {
                return this.consumer.getDataFactory().getOWLDataRangeFacetRestriction(facet, (OWLTypedConstant)val);
            }
            return this.consumer.getDataFactory().getOWLDataRangeFacetRestriction(facet, this.consumer.getDataFactory().getOWLTypedConstant(val.getLiteral(), OWLDataUtil.getIntDataType(this.consumer.getDataFactory())));
        }
        return null;
    }

    @Override
    public OWLDataRangeFacetRestriction translate(OWLConstant firstObject) throws OWLException {
        throw new OWLRDFParserException("Cannot translate list item to facet restriction, because rdf:first triple is a literal triple.");
    }
}

