/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owl.rdfxml.parser;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.coode.owl.rdfxml.parser.ListItemTranslator;
import org.coode.owl.rdfxml.parser.OWLRDFConsumer;
import org.semanticweb.owl.model.OWLConstant;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptimisedListTranslator<O extends OWLObject> {
    private static final Logger logger = Logger.getLogger(OWLRDFConsumer.class.getName());
    private OWLRDFConsumer consumer;
    private ListItemTranslator<O> translator;

    protected OptimisedListTranslator(OWLRDFConsumer consumer, ListItemTranslator<O> translator) {
        this.consumer = consumer;
        this.translator = translator;
    }

    protected OWLRDFConsumer getConsumer() {
        return this.consumer;
    }

    private void translateList(URI mainNode, List<O> list) throws OWLException {
        URI firstResource;
        if (!this.consumer.isList(mainNode, true) && logger.isLoggable(Level.FINE)) {
            logger.fine("Untyped list found: " + mainNode);
        }
        if ((firstResource = this.getConsumer().getFirstResource(mainNode, true)) != null) {
            list.add(this.translator.translate(firstResource));
        } else {
            OWLConstant constant = this.getConsumer().getFirstLiteral(mainNode);
            if (constant != null) {
                list.add(this.translator.translate(constant));
            } else if (logger.isLoggable(Level.FINE)) {
                logger.fine("Possible malformed list: rdf:first triple missing");
            }
        }
        URI rest = this.getConsumer().getRest(mainNode, true);
        if (rest != null) {
            this.translateList(rest, list);
        }
    }

    public List<O> translateList(URI mainNode) throws OWLException {
        ArrayList list = new ArrayList();
        this.translateList(mainNode, list);
        return list;
    }

    public Set<O> translateToSet(URI mainNode) throws OWLException {
        return new HashSet<O>(this.translateList(mainNode));
    }
}

