/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owl.rdfxml.parser;

import edu.unika.aifb.rdf.api.syntax.RDFConsumer;
import edu.unika.aifb.rdf.api.syntax.RDFParser;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owl.vocab.OWLRDFVocabulary;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RDFAPITest
implements RDFConsumer {
    private int count = 0;
    private Set<AbstractTriple> triples = new HashSet<AbstractTriple>();
    private Map<URI, Set<AbstractTriple>> triplesBySubject;
    private Map<URI, Set<AbstractTriple>> triplesByPredicate;
    private Map<String, URI> uriCache = new HashMap<String, URI>();

    public static void main(String[] args) {
        try {
            RDFAPITest con = new RDFAPITest();
            RDFParser parser = new RDFParser();
            URI uri = URI.create("http://www.co-ode.org/ontologies/pizza/2006/07/18/pizza.owl");
            File file = new File("/Users/matthewhorridge/Desktop/Thesaurus.owl");
            uri = file.toURI();
            BufferedInputStream inputStream = new BufferedInputStream(uri.toURL().openStream());
            long t0 = System.currentTimeMillis();
            InputSource is = new InputSource(inputStream);
            is.setSystemId(uri.toString());
            parser.parse(is, con);
            long t1 = System.currentTimeMillis();
            System.gc();
            System.gc();
            System.gc();
            System.gc();
            System.out.println("Mem consumed: " + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 0x100000L);
            System.out.println("Time to load: " + (t1 - t0));
            System.out.println("Number of triples: " + con.count);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public RDFAPITest() {
        this.triplesBySubject = new HashMap<URI, Set<AbstractTriple>>();
        this.triplesByPredicate = new HashMap<URI, Set<AbstractTriple>>();
    }

    @Override
    public void addModelAttribte(String string, String string1) throws SAXException {
    }

    @Override
    public void endModel() throws SAXException {
        this.uriCache.clear();
        Set<AbstractTriple> trips = this.getTriplesByPredicate(OWLRDFVocabulary.RDF_TYPE.getURI());
    }

    @Override
    public void includeModel(String string, String string1) throws SAXException {
    }

    @Override
    public void logicalURI(String string) throws SAXException {
    }

    @Override
    public void startModel(String string) throws SAXException {
    }

    @Override
    public void statementWithLiteralValue(String subject, String predicate, String val, String datatype, String lang) throws SAXException {
        ++this.count;
        LiteralTriple t = new LiteralTriple(this.getURI(subject), this.getURI(predicate), null, lang, null);
        this.triples.add(t);
        this.indexTriple(t);
    }

    private URI getURI(String s) {
        URI uri = this.uriCache.get(s);
        if (uri == null) {
            uri = URI.create(s);
            this.uriCache.put(s, uri);
        }
        return uri;
    }

    private void index(AbstractTriple triple, Map<URI, Set<AbstractTriple>> map, URI key) {
        Set<AbstractTriple> triples = map.get(key);
        if (triples == null) {
            triples = new HashSet<AbstractTriple>();
            map.put(key, triples);
        }
        triples.add(triple);
    }

    private Set<AbstractTriple> getTriplesByPredicate(URI predicate) {
        long t0 = System.currentTimeMillis();
        Set<AbstractTriple> ts0 = this.triplesByPredicate.get(predicate);
        long t1 = System.currentTimeMillis();
        System.out.println("Time to get indexed: " + (t1 - t0));
        long t2 = System.currentTimeMillis();
        HashSet<AbstractTriple> ts1 = new HashSet<AbstractTriple>();
        for (AbstractTriple trip : this.triples) {
            if (!trip.predicate.equals(predicate)) continue;
            ts1.add(trip);
        }
        long t3 = System.currentTimeMillis();
        System.out.println("Time to get via search: " + (t3 - t2));
        return ts0;
    }

    private void indexTriple(AbstractTriple t) {
        this.index(t, this.triplesBySubject, t.subject);
        this.index(t, this.triplesByPredicate, t.predicate);
    }

    @Override
    public void statementWithResourceValue(String subject, String predicate, String object) throws SAXException {
        ++this.count;
        Triple t = new Triple(this.getURI(subject), this.getURI(predicate), this.getURI(object));
        this.triples.add(t);
        this.indexTriple(t);
    }

    private class Triple
    extends AbstractTriple {
        URI object;

        public Triple(URI subject, URI predicate, URI object) {
            this.subject = subject;
            this.predicate = predicate;
            this.object = object;
        }
    }

    private class LiteralTriple
    extends AbstractTriple {
        String literal;
        URI datatype;
        String lang;

        public LiteralTriple(URI subject, URI predicate, String literal, String lang, URI datatype) {
            this.subject = subject;
            this.predicate = predicate;
            this.literal = literal;
            this.lang = lang;
            this.datatype = datatype;
        }
    }

    private class AbstractTriple {
        URI subject;
        URI predicate;

        private AbstractTriple() {
        }
    }
}

