/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owl.rdfxml.parser;

import java.net.URI;
import java.util.List;
import java.util.logging.Logger;
import org.coode.owl.rdfxml.parser.ListItemTranslator;
import org.coode.owl.rdfxml.parser.OWLRDFConsumer;
import org.coode.owl.rdfxml.parser.OWLRDFXMLParserMalformedNodeException;
import org.coode.owl.rdfxml.parser.OptimisedListTranslator;
import org.semanticweb.owl.model.OWLConstant;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDataPropertyExpression;
import org.semanticweb.owl.model.OWLDataRange;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.SWRLAtom;
import org.semanticweb.owl.model.SWRLAtomDObject;
import org.semanticweb.owl.model.SWRLAtomIObject;
import org.semanticweb.owl.vocab.SWRLBuiltInsVocabulary;
import org.semanticweb.owl.vocab.SWRLVocabulary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SWRLAtomListItemTranslator
implements ListItemTranslator<SWRLAtom> {
    private static final Logger logger = Logger.getLogger(SWRLAtomListItemTranslator.class.getName());
    private OWLRDFConsumer consumer;
    private OWLDataFactory dataFactory;

    public SWRLAtomListItemTranslator(OWLRDFConsumer consumer) {
        this.consumer = consumer;
        this.dataFactory = consumer.getDataFactory();
    }

    @Override
    public SWRLAtom translate(URI firstObject) throws OWLException {
        if (this.consumer.isSWRLBuiltInAtom(firstObject)) {
            URI builtInURI = this.consumer.getResourceObject(firstObject, SWRLVocabulary.BUILT_IN.getURI(), true);
            URI mainURI = this.consumer.getResourceObject(firstObject, SWRLVocabulary.ARGUMENTS.getURI(), true);
            OptimisedListTranslator<SWRLAtomDObject> listTranslator = new OptimisedListTranslator<SWRLAtomDObject>(this.consumer, new SWRLAtomDObjectListItemTranslator());
            List<SWRLAtomDObject> args = listTranslator.translateList(mainURI);
            return this.dataFactory.getSWRLBuiltInAtom(SWRLBuiltInsVocabulary.getBuiltIn(builtInURI), args);
        }
        if (this.consumer.isSWRLClassAtom(firstObject)) {
            SWRLAtomIObject iObject = this.translateSWRLAtomIObject(firstObject, SWRLVocabulary.ARGUMENT_1.getURI());
            URI classURI = this.consumer.getResourceObject(firstObject, SWRLVocabulary.CLASS_PREDICATE.getURI(), true);
            OWLDescription desc = this.consumer.translateDescription(classURI);
            return this.dataFactory.getSWRLClassAtom(desc, iObject);
        }
        if (this.consumer.isSWRLDataRangeAtom(firstObject)) {
            SWRLAtomDObject dObject = this.translateSWRLAtomDObject(firstObject, SWRLVocabulary.ARGUMENT_1.getURI());
            URI dataRangeURI = this.consumer.getResourceObject(firstObject, SWRLVocabulary.DATA_RANGE.getURI(), true);
            OWLDataRange dataRange = this.consumer.translateDataRange(dataRangeURI);
            return this.dataFactory.getSWRLDataRangeAtom(dataRange, dObject);
        }
        if (this.consumer.isSWRLDataValuedPropertyAtom(firstObject)) {
            SWRLAtomIObject arg1 = this.translateSWRLAtomIObject(firstObject, SWRLVocabulary.ARGUMENT_1.getURI());
            SWRLAtomDObject arg2 = this.translateSWRLAtomDObject(firstObject, SWRLVocabulary.ARGUMENT_2.getURI());
            URI dataPropertyURI = this.consumer.getResourceObject(firstObject, SWRLVocabulary.PROPERTY_PREDICATE.getURI(), true);
            OWLDataPropertyExpression prop = this.consumer.translateDataPropertyExpression(dataPropertyURI);
            return this.dataFactory.getSWRLDataValuedPropertyAtom(prop, arg1, arg2);
        }
        if (this.consumer.isSWRLIndividualPropertyAtom(firstObject)) {
            SWRLAtomIObject arg1 = this.translateSWRLAtomIObject(firstObject, SWRLVocabulary.ARGUMENT_1.getURI());
            SWRLAtomIObject arg2 = this.translateSWRLAtomIObject(firstObject, SWRLVocabulary.ARGUMENT_2.getURI());
            URI objectPropertyURI = this.consumer.getResourceObject(firstObject, SWRLVocabulary.PROPERTY_PREDICATE.getURI(), true);
            OWLObjectPropertyExpression prop = this.consumer.translateObjectPropertyExpression(objectPropertyURI);
            return this.dataFactory.getSWRLObjectPropertyAtom(prop, arg1, arg2);
        }
        if (this.consumer.isSWRLSameAsAtom(firstObject)) {
            SWRLAtomIObject arg1 = this.translateSWRLAtomIObject(firstObject, SWRLVocabulary.ARGUMENT_1.getURI());
            SWRLAtomIObject arg2 = this.translateSWRLAtomIObject(firstObject, SWRLVocabulary.ARGUMENT_2.getURI());
            return this.dataFactory.getSWRLSameAsAtom(arg1, arg2);
        }
        if (this.consumer.isSWRLDifferentFromAtom(firstObject)) {
            SWRLAtomIObject arg1 = this.translateSWRLAtomIObject(firstObject, SWRLVocabulary.ARGUMENT_1.getURI());
            SWRLAtomIObject arg2 = this.translateSWRLAtomIObject(firstObject, SWRLVocabulary.ARGUMENT_2.getURI());
            return this.dataFactory.getSWRLDifferentFromAtom(arg1, arg2);
        }
        throw new OWLRDFXMLParserMalformedNodeException("Don't know how to translate SWRL Atom: " + firstObject);
    }

    @Override
    public SWRLAtom translate(OWLConstant firstObject) throws OWLException {
        throw new OWLRDFXMLParserMalformedNodeException("Unexprected literal in atom list: " + firstObject);
    }

    private SWRLAtomIObject translateSWRLAtomIObject(URI mainURI, URI argPredicateURI) throws OWLException {
        URI argURI = this.consumer.getResourceObject(mainURI, argPredicateURI, true);
        if (argURI != null) {
            if (this.consumer.isSWRLVariable(argURI)) {
                return this.dataFactory.getSWRLAtomIVariable(argURI);
            }
            return this.dataFactory.getSWRLAtomIndividualObject(this.consumer.getOWLIndividual(argURI));
        }
        throw new OWLRDFXMLParserMalformedNodeException("Cannot translate SWRL Atom I-Object for " + argPredicateURI + " Triple not found.");
    }

    private SWRLAtomDObject translateSWRLAtomDObject(URI mainURI, URI argPredicateURI) throws OWLException {
        URI argURI = this.consumer.getResourceObject(mainURI, argPredicateURI, true);
        if (argURI != null) {
            if (!this.consumer.isSWRLVariable(argURI)) {
                logger.info("Expected SWRL variable for SWRL Data Object: " + argURI + "(possibly untyped)");
            }
            return this.dataFactory.getSWRLAtomDVariable(argURI);
        }
        OWLConstant con = this.consumer.getLiteralObject(mainURI, argPredicateURI, true);
        if (con != null) {
            return this.dataFactory.getSWRLAtomConstantObject(con);
        }
        throw new OWLRDFXMLParserMalformedNodeException("Cannot translate SWRL Atom D-Object for " + argPredicateURI + ". Triple not found.");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SWRLAtomDObjectListItemTranslator
    implements ListItemTranslator<SWRLAtomDObject> {
        private SWRLAtomDObjectListItemTranslator() {
        }

        @Override
        public SWRLAtomDObject translate(URI firstObject) throws OWLException {
            return SWRLAtomListItemTranslator.this.dataFactory.getSWRLAtomDVariable(firstObject);
        }

        @Override
        public SWRLAtomDObject translate(OWLConstant firstObject) throws OWLException {
            return SWRLAtomListItemTranslator.this.dataFactory.getSWRLAtomConstantObject(firstObject);
        }
    }
}

