/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owl.rdfxml.parser;

import java.net.URI;
import java.util.Collections;
import java.util.Set;
import org.coode.owl.rdfxml.parser.OWLRDFConsumer;
import org.coode.owl.rdfxml.parser.OptimisedListTranslator;
import org.coode.owl.rdfxml.parser.SWRLAtomListItemTranslator;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.SWRLAtom;
import org.semanticweb.owl.model.SWRLRule;
import org.semanticweb.owl.vocab.SWRLVocabulary;

public class SWRLRuleTranslator {
    private OWLRDFConsumer consumer;
    private OptimisedListTranslator<SWRLAtom> listTranslator;

    public SWRLRuleTranslator(OWLRDFConsumer consumer) {
        this.consumer = consumer;
        this.listTranslator = new OptimisedListTranslator<SWRLAtom>(consumer, new SWRLAtomListItemTranslator(consumer));
    }

    public void translateRule(URI mainNode) throws OWLException {
        Set<Object> consequent = Collections.emptySet();
        URI ruleHeadURI = this.consumer.getResourceObject(mainNode, SWRLVocabulary.HEAD.getURI(), true);
        if (ruleHeadURI != null) {
            consequent = this.listTranslator.translateToSet(ruleHeadURI);
        }
        Set<Object> antecedent = Collections.emptySet();
        URI ruleBodyURI = this.consumer.getResourceObject(mainNode, SWRLVocabulary.BODY.getURI(), true);
        if (ruleBodyURI != null) {
            antecedent = this.listTranslator.translateToSet(ruleBodyURI);
        }
        SWRLRule rule = null;
        rule = !this.consumer.isAnonymousNode(mainNode) ? this.consumer.getDataFactory().getSWRLRule(mainNode, antecedent, consequent) : this.consumer.getDataFactory().getSWRLRule(mainNode, true, antecedent, consequent);
        this.consumer.addAxiom(rule);
        this.consumer.addReifiedAxiom(mainNode, rule);
    }
}

