/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.owlxml.renderer;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.coode.owlapi.owlxml.renderer.OWLXMLObjectRenderer;
import org.coode.owlapi.owlxml.renderer.OWLXMLWriter;
import org.coode.xml.OWLOntologyNamespaceManager;
import org.semanticweb.owl.io.AbstractOWLRenderer;
import org.semanticweb.owl.io.OWLRendererException;
import org.semanticweb.owl.io.OWLRendererIOException;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyFormat;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.vocab.NamespaceOWLOntologyFormat;
import org.semanticweb.owl.vocab.Namespaces;

public class OWLXMLRenderer
extends AbstractOWLRenderer {
    public OWLXMLRenderer(OWLOntologyManager owlOntologyManager) {
        super(owlOntologyManager);
    }

    public void render(OWLOntology ontology, Writer writer, OWLOntologyFormat format) throws OWLRendererException {
        try {
            OWLOntologyNamespaceManager nsm = new OWLOntologyNamespaceManager(this.getOWLOntologyManager(), ontology);
            nsm.setDefaultNamespace(Namespaces.OWL2XML.toString());
            nsm.setPrefix("owl2xml", Namespaces.OWL2XML.toString());
            if (format instanceof NamespaceOWLOntologyFormat) {
                NamespaceOWLOntologyFormat namespaceFormat = (NamespaceOWLOntologyFormat)format;
                Map<String, String> nsByPrefixMap = namespaceFormat.getNamespacesByPrefixMap();
                for (String prefix : nsByPrefixMap.keySet()) {
                    String ns = nsByPrefixMap.get(prefix);
                    if (ns == null || ns.length() <= 0) continue;
                    nsm.setPrefix(prefix, ns);
                }
                if (namespaceFormat.getDefaultNamespace() != null) {
                    nsm.setDefaultNamespace(namespaceFormat.getDefaultNamespace());
                }
            }
            OWLXMLWriter w = new OWLXMLWriter(writer, nsm, ontology);
            w.startDocument(ontology);
            OWLXMLObjectRenderer ren = new OWLXMLObjectRenderer(ontology, w);
            ontology.accept(ren);
            w.endDocument();
            writer.flush();
        }
        catch (IOException e) {
            throw new OWLRendererIOException(e);
        }
    }

    public void render(OWLOntology ontology, Writer writer) throws OWLRendererException {
        this.render(ontology, writer, this.getOWLOntologyManager().getOntologyFormat(ontology));
    }
}

