/*
 * Decompiled with CFR 0.152.
 */
package org.coode.xml;

import java.net.URI;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.coode.xml.XMLWriterNamespaceManager;
import org.semanticweb.owl.io.RDFXMLOntologyFormat;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLNamedObject;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyFormat;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.util.NamespaceUtil;
import org.semanticweb.owl.vocab.NamespaceOWLOntologyFormat;
import org.semanticweb.owl.vocab.Namespaces;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLOntologyNamespaceManager
extends XMLWriterNamespaceManager {
    private OWLOntologyManager man;
    private OWLOntology ontology;
    private NamespaceUtil namespaceUtil;
    private static String[] splitResults = new String[2];
    private OWLOntologyFormat ontologyFormat;

    public OWLOntologyNamespaceManager(OWLOntologyManager man, OWLOntology ontology) {
        this(man, ontology, man.getOntologyFormat(ontology));
    }

    public OWLOntologyNamespaceManager(OWLOntologyManager man, OWLOntology ontology, OWLOntologyFormat format) {
        super(OWLOntologyNamespaceManager.getDefaultNamespace(ontology));
        this.man = man;
        this.ontology = ontology;
        this.namespaceUtil = new NamespaceUtil();
        this.ontologyFormat = format;
        this.processOntology();
    }

    protected OWLOntology getOntology() {
        return this.ontology;
    }

    private void processOntology() {
        this.namespaceUtil = new NamespaceUtil();
        if (this.ontologyFormat instanceof NamespaceOWLOntologyFormat) {
            NamespaceOWLOntologyFormat namespaceFormat = (NamespaceOWLOntologyFormat)this.ontologyFormat;
            Map<String, String> namespacesByPrefix = namespaceFormat.getNamespacesByPrefixMap();
            for (String prefix : namespacesByPrefix.keySet()) {
                if (prefix.length() <= 0) continue;
                this.namespaceUtil.setPrefix(namespacesByPrefix.get(prefix), prefix);
            }
            String defaultNamespace = namespaceFormat.getDefaultNamespace();
            if (defaultNamespace != null) {
                this.setDefaultNamespace(defaultNamespace);
            }
        }
        if (!this.ontology.getRules().isEmpty()) {
            this.namespaceUtil.setPrefix(Namespaces.SWRL.toString(), "swrl");
            this.namespaceUtil.setPrefix(Namespaces.SWRLB.toString(), "swrlb");
        }
        Set<OWLEntity> entities = this.getEntitiesThatRequireNamespaces();
        for (OWLEntity ent : entities) {
            this.processEntity(ent);
        }
        for (URI uri : this.getAnnotationURIsThatRequireNamespaces()) {
            this.processURI(uri);
        }
        Map<String, String> ns2prefixMap = this.namespaceUtil.getNamespace2PrefixMap();
        for (String ns : ns2prefixMap.keySet()) {
            if (ns.equals(Namespaces.OWL11.toString()) || ns.equals(Namespaces.OWL11XML.toString())) continue;
            this.setPrefix(ns2prefixMap.get(ns), ns);
        }
    }

    protected Set<OWLEntity> getEntitiesThatRequireNamespaces() {
        HashSet<OWLEntity> result = new HashSet<OWLEntity>();
        result.addAll(this.ontology.getReferencedClasses());
        result.addAll(this.ontology.getReferencedObjectProperties());
        result.addAll(this.ontology.getReferencedDataProperties());
        result.addAll(this.ontology.getReferencedIndividuals());
        return result;
    }

    protected Set<URI> getAnnotationURIsThatRequireNamespaces() {
        HashSet<URI> results = new HashSet<URI>();
        OWLOntologyFormat format = this.man.getOntologyFormat(this.ontology);
        if (format instanceof RDFXMLOntologyFormat) {
            RDFXMLOntologyFormat rdfXmlFormat = (RDFXMLOntologyFormat)format;
            results.addAll(rdfXmlFormat.getAnnotationURIs());
        }
        results.addAll(this.ontology.getAnnotationURIs());
        return results;
    }

    private void processEntity(OWLNamedObject entity) {
        URI uri = entity.getURI();
        this.processURI(uri);
    }

    private void processURI(URI uri) {
        String s = uri.toString();
        this.namespaceUtil.split(s, splitResults);
        if (!splitResults[0].equals("") || !splitResults[1].equals("")) {
            this.namespaceUtil.getPrefix(splitResults[0]);
        }
    }

    private static String getDefaultNamespace(OWLOntology ontology) {
        String base = ontology.getURI().toString();
        if (!base.endsWith("#") && !base.endsWith("/")) {
            base = base + "#";
        }
        return base;
    }

    @Override
    public String getQName(String name) {
        this.namespaceUtil.split(name, splitResults);
        if (splitResults[0].equals(this.getDefaultNamespace())) {
            return splitResults[1];
        }
        if (name.startsWith("xmlns") || name.startsWith("xml:")) {
            return name;
        }
        if (splitResults[0].equals("") && splitResults[1].equals("")) {
            return name;
        }
        String prefix = this.getPrefixForNamespace(splitResults[0]);
        if (prefix != null) {
            return prefix + ":" + splitResults[1];
        }
        return null;
    }
}

