/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.semanticweb.owl.AbstractCompositeOntologyChange;
import org.semanticweb.owl.model.OWLClassAxiom;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDisjointClassesAxiom;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyChange;
import org.semanticweb.owl.model.RemoveAxiom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveAllDisjointAxioms
extends AbstractCompositeOntologyChange {
    private Set<OWLOntology> ontologies;
    private List<OWLOntologyChange> changes;

    public RemoveAllDisjointAxioms(OWLDataFactory dataFactory, Set<OWLOntology> ontologies) {
        super(dataFactory);
        this.ontologies = ontologies;
        this.generateChanges();
    }

    private void generateChanges() {
        this.changes = new ArrayList<OWLOntologyChange>();
        for (OWLOntology ont : this.ontologies) {
            for (OWLClassAxiom ax : ont.getClassAxioms()) {
                if (!(ax instanceof OWLDisjointClassesAxiom)) continue;
                this.changes.add(new RemoveAxiom(ont, ax));
            }
        }
    }

    @Override
    public List<OWLOntologyChange> getChanges() {
        return this.changes;
    }
}

