/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.semanticweb.owl.AbstractCompositeOntologyChange;
import org.semanticweb.owl.model.AddAxiom;
import org.semanticweb.owl.model.AxiomType;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDataAllRestriction;
import org.semanticweb.owl.model.OWLDataExactCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDataMaxCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataMinCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataSomeRestriction;
import org.semanticweb.owl.model.OWLDataValueRestriction;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLDescriptionVisitor;
import org.semanticweb.owl.model.OWLObjectAllRestriction;
import org.semanticweb.owl.model.OWLObjectComplementOf;
import org.semanticweb.owl.model.OWLObjectExactCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectIntersectionOf;
import org.semanticweb.owl.model.OWLObjectMaxCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectMinCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectOneOf;
import org.semanticweb.owl.model.OWLObjectSelfRestriction;
import org.semanticweb.owl.model.OWLObjectSomeRestriction;
import org.semanticweb.owl.model.OWLObjectUnionOf;
import org.semanticweb.owl.model.OWLObjectValueRestriction;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyChange;
import org.semanticweb.owl.model.OWLSubClassAxiom;
import org.semanticweb.owl.model.RemoveAxiom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplitSubClassAxioms
extends AbstractCompositeOntologyChange {
    private List<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();

    public SplitSubClassAxioms(Set<OWLOntology> ontologies, OWLDataFactory dataFactory) {
        super(dataFactory);
        for (OWLOntology ont : ontologies) {
            for (OWLSubClassAxiom ax : ont.getAxioms(AxiomType.SUBCLASS)) {
                ConjunctSplitter splitter = new ConjunctSplitter();
                ax.getSuperClass().accept(splitter);
                if (splitter.result.size() <= 1) continue;
                this.changes.add(new RemoveAxiom(ont, ax));
                for (OWLDescription desc : splitter.result) {
                    OWLSubClassAxiom replAx = this.getDataFactory().getOWLSubClassAxiom(ax.getSubClass(), desc);
                    this.changes.add(new AddAxiom(ont, replAx));
                }
            }
        }
    }

    @Override
    public List<OWLOntologyChange> getChanges() {
        return this.changes;
    }

    private class ConjunctSplitter
    implements OWLDescriptionVisitor {
        private Set<OWLDescription> result = new HashSet<OWLDescription>();

        public void visit(OWLClass desc) {
            this.result.add(desc);
        }

        public void visit(OWLDataAllRestriction desc) {
            this.result.add(desc);
        }

        public void visit(OWLDataExactCardinalityRestriction desc) {
            this.result.add(desc);
        }

        public void visit(OWLDataMaxCardinalityRestriction desc) {
            this.result.add(desc);
        }

        public void visit(OWLDataMinCardinalityRestriction desc) {
            this.result.add(desc);
        }

        public void visit(OWLDataSomeRestriction desc) {
            this.result.add(desc);
        }

        public void visit(OWLDataValueRestriction desc) {
            this.result.add(desc);
        }

        public void visit(OWLObjectAllRestriction desc) {
            this.result.add(desc);
        }

        public void visit(OWLObjectComplementOf desc) {
            this.result.add(desc);
        }

        public void visit(OWLObjectExactCardinalityRestriction desc) {
            this.result.add(desc);
        }

        public void visit(OWLObjectIntersectionOf desc) {
            for (OWLDescription op : desc.getOperands()) {
                op.accept(this);
            }
        }

        public void visit(OWLObjectMaxCardinalityRestriction desc) {
            this.result.add(desc);
        }

        public void visit(OWLObjectMinCardinalityRestriction desc) {
            this.result.add(desc);
        }

        public void visit(OWLObjectOneOf desc) {
            this.result.add(desc);
        }

        public void visit(OWLObjectSelfRestriction desc) {
            this.result.add(desc);
        }

        public void visit(OWLObjectSomeRestriction desc) {
            this.result.add(desc);
        }

        public void visit(OWLObjectUnionOf desc) {
            this.result.add(desc);
        }

        public void visit(OWLObjectValueRestriction desc) {
            this.result.add(desc);
        }
    }
}

